/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.lobobrowser.html.style.FontInfo;
import org.lobobrowser.html.style.ListStyle;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.css.CSS2Properties;

public class HtmlValues {
    private static final Map SYSTEM_FONTS = new HashMap();
    public static final float DEFAULT_FONT_SIZE = 14.0f;
    public static final int DEFAULT_FONT_SIZE_INT = 14;
    public static final Float DEFAULT_FONT_SIZE_BOX = new Float(14.0f);

    static {
        FontInfo systemFont = new FontInfo();
        SYSTEM_FONTS.put("caption", systemFont);
        SYSTEM_FONTS.put("icon", systemFont);
        SYSTEM_FONTS.put("menu", systemFont);
        SYSTEM_FONTS.put("message-box", systemFont);
        SYSTEM_FONTS.put("small-caption", systemFont);
        SYSTEM_FONTS.put("status-bar", systemFont);
    }

    private HtmlValues() {
    }

    public static boolean isBorderStyle(String token) {
        return token.equalsIgnoreCase("solid") || token.equalsIgnoreCase("double") || token.equalsIgnoreCase("none") || token.equalsIgnoreCase("dashed") || token.equalsIgnoreCase("dotted") || token.equalsIgnoreCase("hidden") || token.equalsIgnoreCase("groove") || token.equalsIgnoreCase("ridge") || token.equalsIgnoreCase("inset") || token.equalsIgnoreCase("outset");
    }

    public static Insets getMarginInsets(CSS2Properties cssProperties, RenderState renderState) {
        String shortcutText = cssProperties.getMargin();
        Insets insets = null;
        if (shortcutText != null && !"".equals(shortcutText)) {
            insets = HtmlValues.getInsets(shortcutText, renderState, true);
        }
        String topText = cssProperties.getMarginTop();
        insets = HtmlValues.updateTopInset(insets, topText, renderState);
        String leftText = cssProperties.getMarginLeft();
        insets = HtmlValues.updateLeftInset(insets, leftText, renderState);
        String bottomText = cssProperties.getMarginBottom();
        insets = HtmlValues.updateBottomInset(insets, bottomText, renderState);
        String rightText = cssProperties.getMarginRight();
        insets = HtmlValues.updateRightInset(insets, rightText, renderState);
        return insets;
    }

    public static Insets getPaddingInsets(CSS2Properties cssProperties, RenderState renderState) {
        String shortcutText = cssProperties.getPadding();
        Insets insets = null;
        if (shortcutText != null && !"".equals(shortcutText)) {
            insets = HtmlValues.getInsets(shortcutText, renderState, false);
        }
        String topText = cssProperties.getPaddingTop();
        insets = HtmlValues.updateTopInset(insets, topText, renderState);
        String leftText = cssProperties.getPaddingLeft();
        insets = HtmlValues.updateLeftInset(insets, leftText, renderState);
        String bottomText = cssProperties.getPaddingBottom();
        insets = HtmlValues.updateBottomInset(insets, bottomText, renderState);
        String rightText = cssProperties.getPaddingRight();
        insets = HtmlValues.updateRightInset(insets, rightText, renderState);
        return insets;
    }

    public static Insets getBorderInsets(Insets insets, CSS2Properties cssProperties, RenderState renderState) {
        String shortcutText = cssProperties.getBorderWidth();
        if (shortcutText != null && !"".equals(shortcutText)) {
            insets = HtmlValues.getInsets(shortcutText, renderState, false);
        }
        String topText = cssProperties.getBorderTopWidth();
        insets = HtmlValues.updateTopInset(insets, topText, renderState);
        String leftText = cssProperties.getBorderLeftWidth();
        insets = HtmlValues.updateLeftInset(insets, leftText, renderState);
        String bottomText = cssProperties.getBorderBottomWidth();
        insets = HtmlValues.updateBottomInset(insets, bottomText, renderState);
        String rightText = cssProperties.getBorderRightWidth();
        insets = HtmlValues.updateRightInset(insets, rightText, renderState);
        return insets;
    }

    private static Insets updateTopInset(Insets insets, String sizeText, RenderState renderState) {
        if (sizeText == null || "".equals(sizeText)) {
            return insets;
        }
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.top = HtmlValues.getPixelSize(sizeText, renderState, 0);
        return insets;
    }

    private static Insets updateLeftInset(Insets insets, String sizeText, RenderState renderState) {
        if (sizeText == null || "".equals(sizeText)) {
            return insets;
        }
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.left = HtmlValues.getPixelSize(sizeText, renderState, 0);
        return insets;
    }

    private static Insets updateBottomInset(Insets insets, String sizeText, RenderState renderState) {
        if (sizeText == null || "".equals(sizeText)) {
            return insets;
        }
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.bottom = HtmlValues.getPixelSize(sizeText, renderState, 0);
        return insets;
    }

    private static Insets updateRightInset(Insets insets, String sizeText, RenderState renderState) {
        if (sizeText == null || "".equals(sizeText)) {
            return insets;
        }
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        insets.right = HtmlValues.getPixelSize(sizeText, renderState, 0);
        return insets;
    }

    public static Insets getInsets(String insetsSpec, RenderState renderState, boolean negativeOK) {
        int[] insetsArray = new int[4];
        int size = 0;
        StringTokenizer tok = new StringTokenizer(insetsSpec);
        if (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            insetsArray[0] = HtmlValues.getPixelSize(token, renderState, 0);
            if (negativeOK || insetsArray[0] >= 0) {
                size = 1;
                if (tok.hasMoreTokens()) {
                    token = tok.nextToken();
                    insetsArray[1] = HtmlValues.getPixelSize(token, renderState, 0);
                    if (negativeOK || insetsArray[1] >= 0) {
                        size = 2;
                        if (tok.hasMoreTokens()) {
                            token = tok.nextToken();
                            insetsArray[2] = HtmlValues.getPixelSize(token, renderState, 0);
                            if (negativeOK || insetsArray[2] >= 0) {
                                size = 3;
                                if (tok.hasMoreTokens()) {
                                    token = tok.nextToken();
                                    insetsArray[3] = HtmlValues.getPixelSize(token, renderState, 0);
                                    size = 4;
                                    if (!negativeOK && insetsArray[3] < 0) {
                                        insetsArray[3] = 0;
                                    }
                                }
                            } else {
                                size = 4;
                                insetsArray[2] = 0;
                            }
                        }
                    } else {
                        size = 4;
                        insetsArray[1] = 0;
                    }
                }
            } else {
                size = 1;
                insetsArray[0] = 0;
            }
        }
        if (size == 4) {
            return new Insets(insetsArray[0], insetsArray[3], insetsArray[2], insetsArray[1]);
        }
        if (size == 1) {
            int val = insetsArray[0];
            return new Insets(val, val, val, val);
        }
        if (size == 2) {
            return new Insets(insetsArray[0], insetsArray[1], insetsArray[0], insetsArray[1]);
        }
        if (size == 3) {
            return new Insets(insetsArray[0], insetsArray[1], insetsArray[2], insetsArray[1]);
        }
        return null;
    }

    public static Color[] getColors(String colorsSpec) {
        Color[] colorsArray = new Color[4];
        String[] colorStrings = HtmlValues.splitCssValue(colorsSpec);
        int size = colorStrings.length;
        if (size > 4) {
            size = 4;
        }
        int i = 0;
        while (i < size) {
            colorsArray[i] = ColorFactory.getInstance().getColor(colorStrings[i]);
            ++i;
        }
        if (size == 4) {
            return colorsArray;
        }
        if (size == 1) {
            Color color;
            colorsArray[1] = color = colorsArray[0];
            colorsArray[2] = color;
            colorsArray[3] = color;
            return colorsArray;
        }
        if (size == 2) {
            colorsArray[2] = colorsArray[0];
            colorsArray[3] = colorsArray[1];
            return colorsArray;
        }
        if (size == 3) {
            colorsArray[3] = colorsArray[1];
            return colorsArray;
        }
        throw new IllegalStateException("size=" + size);
    }

    public static final int getFontNumberOldStyle(String oldHtmlSpec, RenderState renderState) {
        int tentative;
        oldHtmlSpec = oldHtmlSpec.trim();
        try {
            tentative = oldHtmlSpec.startsWith("+") ? renderState.getFontBase() + Integer.parseInt(oldHtmlSpec.substring(1)) : (oldHtmlSpec.startsWith("-") ? renderState.getFontBase() + Integer.parseInt(oldHtmlSpec) : Integer.parseInt(oldHtmlSpec));
            if (tentative < 1) {
                tentative = 1;
            } else if (tentative > 7) {
                tentative = 7;
            }
        }
        catch (NumberFormatException nfe) {
            tentative = 3;
        }
        return tentative;
    }

    public static final float getFontSize(int fontNumber) {
        switch (fontNumber) {
            case 1: {
                return 10.0f;
            }
            case 2: {
                return 11.0f;
            }
            case 3: {
                return 13.0f;
            }
            case 4: {
                return 16.0f;
            }
            case 5: {
                return 21.0f;
            }
            case 6: {
                return 29.0f;
            }
            case 7: {
                return 42.0f;
            }
        }
        return 63.0f;
    }

    public static final float getFontSize(String spec, RenderState parentRenderState) {
        String specTL = spec.toLowerCase();
        if (specTL.endsWith("pt") || specTL.endsWith("px") || specTL.endsWith("cm") || specTL.endsWith("pc") || specTL.endsWith("cm") || specTL.endsWith("mm") || specTL.endsWith("em") || specTL.endsWith("ex")) {
            return HtmlValues.getPixelSize(spec, parentRenderState, 14);
        }
        if (specTL.endsWith("%")) {
            String value = specTL.substring(0, specTL.length() - 1);
            try {
                double valued = Double.parseDouble(value);
                double parentFontSize = parentRenderState == null ? 14.0 : (double)parentRenderState.getFont().getSize();
                return (float)(parentFontSize * valued / 100.0);
            }
            catch (NumberFormatException nfe) {
                return 14.0f;
            }
        }
        if ("small".equals(specTL)) {
            return 12.0f;
        }
        if ("medium".equals(specTL)) {
            return 14.0f;
        }
        if ("large".equals(specTL)) {
            return 20.0f;
        }
        if ("x-small".equals(specTL)) {
            return 11.0f;
        }
        if ("xx-small".equals(specTL)) {
            return 10.0f;
        }
        if ("x-large".equals(specTL)) {
            return 26.0f;
        }
        if ("xx-large".equals(specTL)) {
            return 40.0f;
        }
        if ("larger".equals(specTL)) {
            int parentFontSize = parentRenderState == null ? 14 : parentRenderState.getFont().getSize();
            return (float)parentFontSize * 1.2f;
        }
        if ("smaller".equals(specTL)) {
            int parentFontSize = parentRenderState == null ? 14 : parentRenderState.getFont().getSize();
            return (float)parentFontSize * 1.2f;
        }
        return HtmlValues.getPixelSize(spec, parentRenderState, 14);
    }

    public static final int getPixelSize(String spec, RenderState renderState, int errorValue, int availSize) {
        if (spec.endsWith("%")) {
            String perText = spec.substring(0, spec.length() - 1);
            try {
                double val = Double.parseDouble(perText);
                return (int)Math.round((double)availSize * val / 100.0);
            }
            catch (NumberFormatException nfe) {
                return errorValue;
            }
        }
        return HtmlValues.getPixelSize(spec, renderState, errorValue);
    }

    public static final int getPixelSize(String spec, RenderState renderState, int errorValue) {
        String lcSpec = spec.toLowerCase();
        if (lcSpec.endsWith("pt")) {
            double val;
            String valText = lcSpec.substring(0, lcSpec.length() - "pt".length());
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException nfe) {
                return errorValue;
            }
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            double inches = val / 72.0;
            return (int)Math.round((double)dpi * inches);
        }
        if (lcSpec.endsWith("px")) {
            String pxText = lcSpec.substring(0, lcSpec.length() - "px".length());
            try {
                return (int)Math.round(Double.parseDouble(pxText));
            }
            catch (NumberFormatException nfe) {
                return errorValue;
            }
        }
        if (lcSpec.endsWith("pc")) {
            double val;
            String valText = lcSpec.substring(0, lcSpec.length() - "pc".length());
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException nfe) {
                return errorValue;
            }
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            double inches = val / 6.0;
            return (int)Math.round((double)dpi * inches);
        }
        if (lcSpec.endsWith("cm")) {
            double val;
            String valText = lcSpec.substring(0, lcSpec.length() - "cm".length());
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException nfe) {
                return errorValue;
            }
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            double inches = val / 2.54;
            return (int)Math.round((double)dpi * inches);
        }
        if (lcSpec.endsWith("mm")) {
            double val;
            String valText = lcSpec.substring(0, lcSpec.length() - "mm".length());
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException nfe) {
                return errorValue;
            }
            int dpi = Toolkit.getDefaultToolkit().getScreenResolution();
            double inches = val / 25.4;
            return (int)Math.round((double)dpi * inches);
        }
        if (lcSpec.endsWith("ex") && renderState != null) {
            double val;
            FontMetrics fm = renderState.getFontMetrics();
            String valText = lcSpec.substring(0, lcSpec.length() - "ex".length());
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException nfe) {
                return errorValue;
            }
            return (int)Math.round((double)fm.getAscent() * val);
        }
        if (lcSpec.endsWith("em") && renderState != null) {
            double val;
            Font f = renderState.getFont();
            String valText = lcSpec.substring(0, lcSpec.length() - "ex".length());
            try {
                val = Double.parseDouble(valText);
            }
            catch (NumberFormatException nfe) {
                return errorValue;
            }
            return (int)Math.round((double)f.getSize() * val);
        }
        String pxText = lcSpec;
        try {
            return (int)Math.round(Double.parseDouble(pxText));
        }
        catch (NumberFormatException nfe) {
            return errorValue;
        }
    }

    public static int getOldSyntaxPixelSize(String spec, int availSize, int errorValue) {
        if (spec == null) {
            return errorValue;
        }
        spec = spec.trim();
        try {
            if (spec.endsWith("%")) {
                return availSize * Integer.parseInt(spec.substring(0, spec.length() - 1)) / 100;
            }
            return Integer.parseInt(spec);
        }
        catch (NumberFormatException nfe) {
            return errorValue;
        }
    }

    public static String getURIFromStyleValue(String styleValue) {
        String start = "url(";
        if (!styleValue.toLowerCase().startsWith(start)) {
            return null;
        }
        int startIdx = start.length();
        int closingIdx = styleValue.lastIndexOf(41);
        if (closingIdx == -1) {
            return null;
        }
        String quotedUrl = styleValue.substring(startIdx, closingIdx);
        return HtmlValues.unquoteAndUnescape(quotedUrl);
    }

    public static String unquoteAndUnescape(String text) {
        char ch;
        StringBuffer result = new StringBuffer();
        int index = 0;
        int length = text.length();
        boolean escape = false;
        boolean single = false;
        if (index < length) {
            ch = text.charAt(index);
            switch (ch) {
                case '\'': {
                    single = true;
                    break;
                }
                case '\"': {
                    break;
                }
                case '\\': {
                    escape = true;
                    break;
                }
                default: {
                    result.append(ch);
                }
            }
            ++index;
        }
        block10: while (index < length) {
            ch = text.charAt(index);
            switch (ch) {
                case '\'': {
                    if (!escape && single) break block10;
                    escape = false;
                    result.append(ch);
                    break;
                }
                case '\"': {
                    if (!escape && !single) break block10;
                    escape = false;
                    result.append(ch);
                    break;
                }
                case '\\': {
                    if (escape) {
                        escape = false;
                        result.append(ch);
                        break;
                    }
                    escape = true;
                    break;
                }
                default: {
                    if (escape) {
                        escape = false;
                        result.append('\\');
                    }
                    result.append(ch);
                }
            }
            ++index;
        }
        return result.toString();
    }

    public static String getColorFromBackground(String background) {
        String[] backgroundParts = HtmlValues.splitCssValue(background);
        int i = 0;
        while (i < backgroundParts.length) {
            String token = backgroundParts[i];
            if (ColorFactory.getInstance().isColor(token)) {
                return token;
            }
            ++i;
        }
        return null;
    }

    public static boolean isLength(String token) {
        if (token.endsWith("px") || token.endsWith("pt") || token.endsWith("pc") || token.endsWith("cm") || token.endsWith("mm") || token.endsWith("ex") || token.endsWith("em")) {
            return true;
        }
        try {
            Double.parseDouble(token);
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static String[] splitCssValue(String cssValue) {
        ArrayList<String> tokens = new ArrayList<String>();
        int len = cssValue.length();
        int parenCount = 0;
        StringBuffer currentWord = null;
        int i = 0;
        while (i < len) {
            char ch = cssValue.charAt(i);
            switch (ch) {
                case '(': {
                    ++parenCount;
                    if (currentWord == null) {
                        currentWord = new StringBuffer();
                    }
                    currentWord.append(ch);
                    break;
                }
                case ')': {
                    --parenCount;
                    if (currentWord == null) {
                        currentWord = new StringBuffer();
                    }
                    currentWord.append(ch);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (parenCount == 0) {
                        tokens.add(currentWord.toString());
                        currentWord = null;
                        break;
                    }
                }
                default: {
                    if (currentWord == null) {
                        currentWord = new StringBuffer();
                    }
                    currentWord.append(ch);
                }
            }
            ++i;
        }
        if (currentWord != null) {
            tokens.add(currentWord.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static boolean isUrl(String token) {
        return token.toLowerCase().startsWith("url(");
    }

    public static int getListStyleType(String token) {
        String tokenTL = token.toLowerCase();
        if ("disc".equals(tokenTL)) {
            return 1;
        }
        if ("circle".equals(tokenTL)) {
            return 2;
        }
        if ("square".equals(tokenTL)) {
            return 3;
        }
        if ("decimal".equals(tokenTL)) {
            return 4;
        }
        if ("lower-alpha".equals(tokenTL) || "lower-latin".equals(tokenTL)) {
            return 5;
        }
        if ("upper-alpha".equals(tokenTL) || "upper-latin".equals(tokenTL)) {
            return 6;
        }
        return 0;
    }

    public static int getListStyleTypeDeprecated(String token) {
        String tokenTL = token.toLowerCase();
        if ("disc".equals(tokenTL)) {
            return 1;
        }
        if ("circle".equals(tokenTL)) {
            return 2;
        }
        if ("square".equals(tokenTL)) {
            return 3;
        }
        if ("1".equals(tokenTL)) {
            return 4;
        }
        if ("a".equals(tokenTL)) {
            return 5;
        }
        if ("A".equals(tokenTL)) {
            return 6;
        }
        return 0;
    }

    public static int getListStylePosition(String token) {
        String tokenTL = token.toLowerCase();
        if ("inside".equals(tokenTL)) {
            return 0;
        }
        if ("outside".equals(tokenTL)) {
            return 0;
        }
        return 0;
    }

    public static ListStyle getListStyle(String listStyleText) {
        ListStyle listStyle = new ListStyle();
        String[] tokens = HtmlValues.splitCssValue(listStyleText);
        int i = 0;
        while (i < tokens.length) {
            int listStylePosition;
            String token = tokens[i];
            int listStyleType = HtmlValues.getListStyleType(token);
            if (listStyleType != 0) {
                listStyle.type = listStyleType;
            } else if (!HtmlValues.isUrl(token) && (listStylePosition = HtmlValues.getListStylePosition(token)) != 0) {
                listStyle.position = listStylePosition;
            }
            ++i;
        }
        return listStyle;
    }

    private static boolean isFontStyle(String token) {
        return "italic".equals(token) || "normal".equals(token) || "oblique".equals(token);
    }

    private static boolean isFontVariant(String token) {
        return "small-caps".equals(token) || "normal".equals(token);
    }

    private static boolean isFontWeight(String token) {
        if ("bold".equals(token) || "bolder".equals(token) || "lighter".equals(token)) {
            return true;
        }
        try {
            int value = Integer.parseInt(token);
            return value % 100 == 0 && value >= 100 && value <= 900;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static FontInfo createFontInfo(String fontSpec, RenderState parentRenderState) {
        String fontSpecTL = fontSpec.toLowerCase();
        FontInfo fontInfo = (FontInfo)SYSTEM_FONTS.get(fontSpecTL);
        if (fontInfo != null) {
            return fontInfo;
        }
        fontInfo = new FontInfo();
        String[] tokens = HtmlValues.splitCssValue(fontSpecTL);
        String token = null;
        int length = tokens.length;
        int i = 0;
        while (i < length) {
            token = tokens[i];
            if (HtmlValues.isFontStyle(token)) {
                fontInfo.fontStyle = token;
            } else if (HtmlValues.isFontVariant(token)) {
                fontInfo.fontVariant = token;
            } else {
                if (!HtmlValues.isFontWeight(token)) break;
                fontInfo.fontWeight = token;
            }
            ++i;
        }
        if (token != null) {
            int slashIdx = token.indexOf(47);
            String fontSizeText = slashIdx == -1 ? token : token.substring(0, slashIdx);
            fontInfo.fontSize = new Float(HtmlValues.getFontSize(fontSizeText, parentRenderState));
            if (++i < length) {
                StringBuffer fontFamilyBuff = new StringBuffer();
                do {
                    token = tokens[i];
                    fontFamilyBuff.append(token);
                    fontFamilyBuff.append(' ');
                } while (++i < length);
                fontInfo.fontFamily = fontFamilyBuff.toString();
            }
        }
        return fontInfo;
    }
}

