/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.lobobrowser.html.BrowserFrame;
import org.lobobrowser.html.FormInput;
import org.lobobrowser.html.HtmlObject;
import org.lobobrowser.html.HtmlParserContext;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.FrameNode;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.parser.InputSourceImpl;
import org.lobobrowser.html.test.SimpleBrowserFrame;
import org.lobobrowser.html.test.SimpleHtmlObject;
import org.lobobrowser.html.test.SimpleHtmlParserContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.lobobrowser.util.io.RecordedInputStream;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLCollection;
import org.w3c.dom.html2.HTMLElement;
import org.w3c.dom.html2.HTMLLinkElement;

public class SimpleHtmlRendererContext
implements HtmlRendererContext {
    private static final Logger logger;
    private static final Set mediaNames;
    private final HtmlPanel htmlPanel;
    private final HtmlRendererContext parentRcontext;
    private volatile String sourceCode;
    private volatile HtmlRendererContext opener;
    private UserAgentContext bcontext = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.html.test.SimpleHtmlRendererContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        mediaNames = new HashSet();
        Set mn = mediaNames;
        mn.add("screen");
        mn.add("tv");
        mn.add("tty");
        mn.add("all");
    }

    public SimpleHtmlRendererContext(HtmlPanel contextComponent) {
        this.htmlPanel = contextComponent;
        this.parentRcontext = null;
    }

    public SimpleHtmlRendererContext(HtmlPanel contextComponent, HtmlParserContext pcontext) {
        this(contextComponent, pcontext, null);
    }

    public SimpleHtmlRendererContext(HtmlPanel contextComponent, HtmlParserContext pcontext, HtmlRendererContext parentRcontext) {
        this.htmlPanel = contextComponent;
        this.parentRcontext = parentRcontext;
    }

    public SimpleHtmlRendererContext(HtmlPanel contextComponent, HtmlRendererContext parentRcontext) {
        this.htmlPanel = contextComponent;
        this.parentRcontext = parentRcontext;
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public HTMLCollection getFrames() {
        NodeImpl rootNode = this.htmlPanel.getRootNode();
        if (rootNode instanceof HTMLDocumentImpl) {
            return ((HTMLDocumentImpl)rootNode).getFrames();
        }
        return null;
    }

    protected HtmlParserContext createParserContext(URL url) {
        return new SimpleHtmlParserContext();
    }

    public void reload() {
        HTMLDocumentImpl document = (HTMLDocumentImpl)this.htmlPanel.getRootNode();
        if (document != null) {
            try {
                URL url = new URL(document.getDocumentURI());
                this.navigate(url, null);
            }
            catch (MalformedURLException throwable) {
                this.warn("reload(): Malformed URL", throwable);
            }
        }
    }

    public void navigate(final URL href, String target) {
        URL urlForLoading;
        if (target != null) {
            Node frame;
            HtmlRendererContext topCtx = this.getTop();
            HTMLCollection frames = topCtx.getFrames();
            if (frames != null && (frame = frames.namedItem(target)) instanceof FrameNode) {
                BrowserFrame bframe = ((FrameNode)((Object)frame)).getBrowserFrame();
                if (bframe == null) {
                    throw new IllegalStateException("Frame node without a BrowserFrame instance: " + frame);
                }
                if (bframe.getHtmlRendererContext() != this) {
                    bframe.loadURL(href);
                    return;
                }
            }
            if ("_top".equals(target = target.trim().toLowerCase())) {
                this.getTop().navigate(href, null);
                return;
            }
            if ("_parent".equals(target)) {
                HtmlRendererContext parent = this.getParent();
                if (parent != null) {
                    parent.navigate(href, null);
                    return;
                }
            } else if ("_blank".equals(target)) {
                this.open(href.toExternalForm(), "cobra.blank", "", false);
                return;
            }
        }
        if (href.getProtocol().equals("file")) {
            try {
                urlForLoading = new URL(href.getProtocol(), href.getHost(), href.getPort(), href.getPath());
            }
            catch (MalformedURLException throwable) {
                this.warn("malformed", throwable);
                urlForLoading = href;
            }
        } else {
            urlForLoading = href;
        }
        final URL finalURLForLoading = urlForLoading;
        new Thread(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                try {
                    URL uri = href;
                    logger.info("process(): Loading URI=[" + uri + "].");
                    long time0 = System.currentTimeMillis();
                    URLConnection connection = finalURLForLoading.openConnection();
                    connection.setRequestProperty("User-Agent", SimpleHtmlRendererContext.this.getUserAgentContext().getUserAgent());
                    connection.setRequestProperty("Cookie", "");
                    if (connection instanceof HttpURLConnection) {
                        HttpURLConnection hc = (HttpURLConnection)connection;
                        hc.setInstanceFollowRedirects(true);
                        int responseCode = hc.getResponseCode();
                        logger.info("process(): HTTP response code: " + responseCode);
                    }
                    InputStream in = connection.getInputStream();
                    try {
                        SimpleHtmlRendererContext.this.sourceCode = null;
                        long time1 = System.currentTimeMillis();
                        RecordedInputStream rin = new RecordedInputStream(in);
                        BufferedInputStream bin = new BufferedInputStream(rin, 8192);
                        HtmlParserContext pcontext = SimpleHtmlRendererContext.this.createParserContext(uri);
                        DocumentBuilderImpl builder = new DocumentBuilderImpl(pcontext, (HtmlRendererContext)SimpleHtmlRendererContext.this);
                        String actualURI = uri.toExternalForm();
                        HTMLDocumentImpl document = (HTMLDocumentImpl)builder.createDocument(new InputSourceImpl(bin, actualURI, "ISO-8859-1"));
                        SimpleHtmlRendererContext.this.htmlPanel.setDocument(document, SimpleHtmlRendererContext.this);
                        document.load();
                        long time2 = System.currentTimeMillis();
                        logger.info("Parsed URI=[" + uri + "]: Parse elapsed: " + (time2 - time1) + " ms. Connection elapsed: " + (time1 - time0) + " ms.");
                        SimpleHtmlRendererContext.this.sourceCode = rin.getString("ISO-8859-1");
                    }
                    catch (Throwable throwable) {
                        Object var16_16 = null;
                        in.close();
                        throw throwable;
                    }
                    {
                        Object var16_17 = null;
                        in.close();
                        return;
                    }
                }
                catch (Exception err) {
                    SimpleHtmlRendererContext.this.error("navigate(): Error loading or parsing request.", err);
                }
            }
        }.start();
    }

    public void submitForm(String method, URL action, String target, String enctype, FormInput[] formInputs) {
        StringBuffer sb = new StringBuffer();
        String lineBreak = System.getProperty("line.separator");
        if (formInputs != null) {
            int i = 0;
            while (i < formInputs.length) {
                sb.append("INPUT: " + formInputs[i].toString());
                sb.append(lineBreak);
                ++i;
            }
        }
        this.warn("submitForm(): Not overridden; method=" + method + "; action=" + action + "; target=" + target + "; enctype=" + enctype + lineBreak + sb);
    }

    public void alert(String message) {
        JOptionPane.showMessageDialog(this.htmlPanel, message);
    }

    public void back() {
        this.warn("back(): Not overridden");
    }

    public void blur() {
        this.warn("back(): Not overridden");
    }

    public void close() {
        this.warn("close(): Not overridden");
    }

    public boolean confirm(String message) {
        int retValue = JOptionPane.showConfirmDialog(this.htmlPanel, message, "Confirm", 0);
        return retValue == 0;
    }

    public void focus() {
        this.warn("focus(): Not overridden");
    }

    public HtmlRendererContext open(String url, String windowName, String windowFeatures, boolean replace) {
        this.warn("open(): Not overridden");
        return null;
    }

    public HtmlRendererContext open(URL url, String windowName, String windowFeatures, boolean replace) {
        this.warn("open(): Not overridden");
        return null;
    }

    public String prompt(String message, String inputDefault) {
        return JOptionPane.showInputDialog(this.htmlPanel, (Object)message);
    }

    public void scroll(int x, int y) {
        this.warn("scroll(): Not overridden");
    }

    public boolean isClosed() {
        this.warn("isClosed(): Not overridden");
        return false;
    }

    public String getDefaultStatus() {
        this.warn("getDefaultStatus(): Not overridden");
        return "";
    }

    public int getLength() {
        this.warn("getLength(): Not overridden");
        return 0;
    }

    public String getName() {
        this.warn("getName(): Not overridden");
        return "";
    }

    public HtmlRendererContext getParent() {
        return this.parentRcontext;
    }

    public HtmlRendererContext getOpener() {
        return this.opener;
    }

    public void setOpener(HtmlRendererContext opener) {
        this.opener = opener;
    }

    public String getStatus() {
        this.warn("getStatus(): Not overridden");
        return "";
    }

    public void setStatus(String message) {
        this.warn("setStatus(): Not overridden");
    }

    public HtmlRendererContext getTop() {
        HtmlRendererContext ancestor = this.parentRcontext;
        if (ancestor == null) {
            return this;
        }
        return ancestor.getTop();
    }

    public BrowserFrame createBrowserFrame() {
        return new SimpleBrowserFrame(this);
    }

    public void warn(String message, Throwable throwable) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, message, throwable);
        }
    }

    public void error(String message, Throwable throwable) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, message, throwable);
        }
    }

    public void warn(String message) {
        if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, message);
        }
    }

    public void error(String message) {
        if (logger.isLoggable(Level.SEVERE)) {
            logger.log(Level.SEVERE, message);
        }
    }

    public HtmlObject getHtmlObject(HTMLElement element) {
        SimpleHtmlObject result = "OBJECT".equalsIgnoreCase(element.getTagName()) ? null : new SimpleHtmlObject(element);
        this.warn("getHtmlObject(): Not overridden; returning " + result + " for " + element + ".");
        return result;
    }

    public void setDefaultStatus(String message) {
        this.warn("setDefaultStatus(): Not overridden.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserAgentContext getUserAgentContext() {
        this.warn("getUserAgentContext(): Not overridden; returning simple one.");
        SimpleHtmlRendererContext simpleHtmlRendererContext = this;
        synchronized (simpleHtmlRendererContext) {
            if (this.bcontext == null) {
                this.bcontext = new SimpleUserAgentContext();
            }
            return this.bcontext;
        }
    }

    public boolean isVisitedLink(HTMLLinkElement link) {
        return false;
    }

    public boolean isMedia(String mediaName) {
        return mediaNames.contains(mediaName.toLowerCase());
    }
}

