/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.gui.SelectionChangeEvent;
import org.lobobrowser.html.gui.SelectionChangeListener;
import org.lobobrowser.html.test.NodeTreeModel;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;

public class TestFrame
extends JFrame {
    private static final Logger logger;
    private final SimpleHtmlRendererContext rcontext;
    private final JTree tree;
    private final HtmlPanel htmlPanel;
    private final JTextArea textArea;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.html.test.TestFrame");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public TestFrame() throws HeadlessException {
        this("");
    }

    public TestFrame(String title) throws HeadlessException {
        super(title);
        JTextArea textArea;
        this.setDefaultCloseOperation(3);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        final JTextField textField = new JTextField();
        JButton button = new JButton("Parse & Render");
        final JTabbedPane tabbedPane = new JTabbedPane();
        final JTree tree = new JTree();
        final JScrollPane scrollPane = new JScrollPane(tree);
        this.tree = tree;
        contentPane.add((Component)topPanel, "North");
        contentPane.add((Component)bottomPanel, "Center");
        topPanel.add((Component)new JLabel("URL: "), "West");
        topPanel.add((Component)textField, "Center");
        topPanel.add((Component)button, "East");
        bottomPanel.add((Component)tabbedPane, "Center");
        final HtmlPanel panel = new HtmlPanel();
        panel.addSelectionChangeListener(new SelectionChangeListener(){

            public void selectionChanged(SelectionChangeEvent event) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("selectionChanged(): selection node: " + panel.getSelectionNode());
                }
            }
        });
        this.htmlPanel = panel;
        this.rcontext = new SimpleHtmlRendererContext(panel);
        this.textArea = textArea = new JTextArea();
        textArea.setEditable(false);
        final JScrollPane textAreaSp = new JScrollPane(textArea);
        tabbedPane.addTab("HTML", panel);
        tabbedPane.addTab("Tree", scrollPane);
        tabbedPane.addTab("Source", textAreaSp);
        tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Component component = tabbedPane.getSelectedComponent();
                if (component == scrollPane) {
                    tree.setModel(new NodeTreeModel(panel.getRootNode()));
                } else if (component == textAreaSp) {
                    textArea.setText(TestFrame.this.rcontext.getSourceCode());
                }
            }
        });
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                TestFrame.this.process(textField.getText());
            }
        });
    }

    private void process(String uri) {
        try {
            URL url;
            try {
                url = new URL(uri);
            }
            catch (MalformedURLException mfu) {
                int idx = uri.indexOf(58);
                if (idx == -1 || idx == 1) {
                    url = new URL("file:" + uri);
                }
                throw mfu;
            }
            this.rcontext.navigate(url, null);
        }
        catch (Exception err) {
            logger.log(Level.SEVERE, "Error trying to load URI=[" + uri + "].", err);
        }
    }
}

