/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.util.SimpleThreadPoolTask;

public class SimpleThreadPool {
    private static final Logger logger;
    private final LinkedList taskList = new LinkedList();
    private final Set runningSet = new HashSet();
    private final int minThreads;
    private final int maxThreads;
    private final String name;
    private final int idleAliveMillis;
    private final Object taskMonitor = new Object();
    private int numThreads = 0;
    private int numIdleThreads = 0;
    private int threadNumber = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.util.SimpleThreadPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public SimpleThreadPool(String name, int minShrinkToThreads, int maxThreads, int idleAliveMillis) {
        this.minThreads = minShrinkToThreads;
        this.maxThreads = maxThreads;
        this.idleAliveMillis = idleAliveMillis;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(SimpleThreadPoolTask task) {
        Object monitor;
        if (task == null) {
            throw new IllegalArgumentException("null task");
        }
        Object object = monitor = this.taskMonitor;
        synchronized (object) {
            if (this.numIdleThreads == 0) {
                this.addThreadImpl();
            }
            this.taskList.add(task);
            monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(SimpleThreadPoolTask task) {
        Object object = this.taskMonitor;
        synchronized (object) {
            this.taskList.remove(task);
        }
        task.cancel();
    }

    private void addThreadImpl() {
        if (this.numThreads < this.maxThreads) {
            Thread t = new Thread((Runnable)new ThreadRunnable(), String.valueOf(this.name) + this.threadNumber++);
            t.setDaemon(true);
            t.start();
            ++this.numThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAll() {
        Object object = this.taskMonitor;
        synchronized (object) {
            this.taskList.clear();
            Iterator i = this.runningSet.iterator();
            while (i.hasNext()) {
                ((SimpleThreadPoolTask)i.next()).cancel();
            }
        }
    }

    private class ThreadRunnable
    implements Runnable {
        private ThreadRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object monitor = SimpleThreadPool.this.taskMonitor;
            LinkedList tl = SimpleThreadPool.this.taskList;
            Set rs = SimpleThreadPool.this.runningSet;
            int iam = SimpleThreadPool.this.idleAliveMillis;
            SimpleThreadPoolTask task = null;
            while (true) {
                try {
                    while (true) {
                        Object object = monitor;
                        synchronized (object) {
                            Object var11_16;
                            block23: {
                                SimpleThreadPool simpleThreadPool;
                                block22: {
                                    if (task != null) {
                                        rs.remove(task);
                                    }
                                    SimpleThreadPool simpleThreadPool2 = SimpleThreadPool.this;
                                    simpleThreadPool2.numIdleThreads = simpleThreadPool2.numIdleThreads + 1;
                                    try {
                                        long waitBase = System.currentTimeMillis();
                                        while (tl.isEmpty()) {
                                            long maxWait = (long)iam - (System.currentTimeMillis() - waitBase);
                                            if (maxWait <= 0L) {
                                                if (SimpleThreadPool.this.numThreads > SimpleThreadPool.this.minThreads) {
                                                    SimpleThreadPool simpleThreadPool3 = SimpleThreadPool.this;
                                                    simpleThreadPool3.numThreads = simpleThreadPool3.numThreads - 1;
                                                    var11_16 = null;
                                                    simpleThreadPool = SimpleThreadPool.this;
                                                    break block22;
                                                } else {
                                                    waitBase = System.currentTimeMillis();
                                                    continue;
                                                }
                                            }
                                            monitor.wait(maxWait);
                                        }
                                        break block23;
                                    }
                                    catch (Throwable throwable) {
                                        var11_16 = null;
                                        SimpleThreadPool simpleThreadPool4 = SimpleThreadPool.this;
                                        simpleThreadPool4.numIdleThreads = simpleThreadPool4.numIdleThreads - 1;
                                        throw throwable;
                                    }
                                }
                                simpleThreadPool.numIdleThreads = simpleThreadPool.numIdleThreads - 1;
                                return;
                            }
                            var11_16 = null;
                            SimpleThreadPool simpleThreadPool = SimpleThreadPool.this;
                            simpleThreadPool.numIdleThreads = simpleThreadPool.numIdleThreads - 1;
                            task = (SimpleThreadPoolTask)SimpleThreadPool.this.taskList.removeFirst();
                            rs.add(task);
                        }
                        Thread currentThread = Thread.currentThread();
                        String baseName = currentThread.getName();
                        try {
                            try {
                                currentThread.setName(String.valueOf(baseName) + ":" + task.toString());
                            }
                            catch (Throwable thrown) {
                                logger.log(Level.WARNING, "run(): Unable to set task name.", thrown);
                            }
                            try {
                                task.run();
                            }
                            catch (Throwable thrown) {
                                logger.log(Level.SEVERE, "run(): Error in task: " + task + ".", thrown);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_15 = null;
                            currentThread.setName(baseName);
                            throw throwable;
                        }
                        {
                            Object var9_13 = null;
                            currentThread.setName(baseName);
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable thrown) {
                    logger.log(Level.SEVERE, "run(): Error in thread pool: " + SimpleThreadPool.this.name + ".", thrown);
                    continue;
                }
                break;
            }
        }
    }
}

