/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public class Strings {
    private static final MessageDigest MESSAGE_DIGEST;
    public static final String[] EMPTY_ARRAY;
    private static final String HEX_CHARS = "0123456789ABCDEF";

    static {
        MessageDigest md;
        EMPTY_ARRAY = new String[0];
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException err) {
            throw new IllegalStateException();
        }
        MESSAGE_DIGEST = md;
    }

    private Strings() {
    }

    public static int compareVersions(String version1, String version2) {
        return version1.compareTo(version2);
    }

    public static boolean isBlank(String text) {
        return text == null || "".equals(text);
    }

    public static int countLines(String text) {
        int lbIdx;
        int startIdx = 0;
        int lineCount = 1;
        while ((lbIdx = text.indexOf(10, startIdx)) != -1) {
            ++lineCount;
            startIdx = lbIdx + 1;
        }
        return lineCount;
    }

    public static boolean isJavaIdentifier(String id) {
        if (id == null) {
            return false;
        }
        int len = id.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(id.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < len) {
            if (!Character.isJavaIdentifierPart(id.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String getTextFromStream(InputStream in) throws IOException {
        int numRead;
        InputStreamReader reader = new InputStreamReader(in, "UTF-8");
        char[] buffer = new char[256];
        int offset = 0;
        while ((numRead = ((Reader)reader).read(buffer, offset, buffer.length - offset)) != -1) {
            if ((offset += numRead) < buffer.length * 2 / 3) continue;
            char[] newBuffer = new char[buffer.length * 2];
            System.arraycopy(buffer, 0, newBuffer, 0, offset);
            buffer = newBuffer;
        }
        return new String(buffer, 0, offset);
    }

    public static String getJavaStringLiteral(String text) {
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        int len = text.length();
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\\': {
                    buf.append("\\\\");
                    break;
                }
                case '\n': {
                    buf.append("\\n");
                    break;
                }
                case '\r': {
                    buf.append("\\r");
                    break;
                }
                case '\t': {
                    buf.append("\\t");
                    break;
                }
                case '\"': {
                    buf.append("\\\"");
                    break;
                }
                default: {
                    buf.append(ch);
                }
            }
            ++i;
        }
        buf.append('\"');
        return buf.toString();
    }

    public static String getJavaIdentifier(String candidateID) {
        int len = candidateID.length();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < len) {
            boolean good;
            char ch = candidateID.charAt(i);
            boolean bl = good = i == 0 ? Character.isJavaIdentifierStart(ch) : Character.isJavaIdentifierPart(ch);
            if (good) {
                buf.append(ch);
            } else {
                buf.append('_');
            }
            ++i;
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(String source) throws UnsupportedEncodingException {
        byte[] result;
        byte[] bytes = source.getBytes("UTF8");
        MessageDigest messageDigest = MESSAGE_DIGEST;
        synchronized (messageDigest) {
            MESSAGE_DIGEST.update(bytes);
            result = MESSAGE_DIGEST.digest();
        }
        char[] resChars = new char[32];
        int len = result.length;
        int i = 0;
        while (i < len) {
            byte b = result[i];
            int lo4 = b & 0xF;
            int hi4 = (b & 0xF0) >> 4;
            resChars[i * 2] = HEX_CHARS.charAt(hi4);
            resChars[i * 2 + 1] = HEX_CHARS.charAt(lo4);
            ++i;
        }
        return new String(resChars);
    }

    public static String getHash32(String source) throws UnsupportedEncodingException {
        String md5 = Strings.getMD5(source);
        return md5.substring(0, 8);
    }

    public static String getHash64(String source) throws UnsupportedEncodingException {
        String md5 = Strings.getMD5(source);
        return md5.substring(0, 16);
    }

    public static int countChars(String text, char ch) {
        int len = text.length();
        int count = 0;
        int i = 0;
        while (i < len) {
            if (ch == text.charAt(i)) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static String unquote(String text) {
        if (text.startsWith("\"") && text.endsWith("\"")) {
            return text.substring(1, text.length() - 2);
        }
        return text;
    }

    public static String[] split(String phrase) {
        int length = phrase.length();
        ArrayList<String> wordList = new ArrayList<String>();
        StringBuffer word = null;
        int i = 0;
        while (i < length) {
            char ch = phrase.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (word == null) break;
                    wordList.add(word.toString());
                    word = null;
                    break;
                }
                default: {
                    if (word == null) {
                        word = new StringBuffer();
                    }
                    word.append(ch);
                }
            }
            ++i;
        }
        if (word != null) {
            wordList.add(word.toString());
        }
        return wordList.toArray(EMPTY_ARRAY);
    }

    public static String truncate(String text, int maxLength) {
        if (text == null) {
            return null;
        }
        if (text.length() <= maxLength) {
            return text;
        }
        return String.valueOf(text.substring(0, Math.max(maxLength - 3, 0))) + "...";
    }

    public static String strictHtmlEncode(String rawText) {
        StringBuffer output = new StringBuffer();
        int length = rawText.length();
        int i = 0;
        while (i < length) {
            char ch = rawText.charAt(i);
            switch (ch) {
                case '&': {
                    output.append("&amp;");
                    break;
                }
                case '\"': {
                    output.append("&quot;");
                    break;
                }
                case '<': {
                    output.append("&lt;");
                    break;
                }
                case '>': {
                    output.append("&gt;");
                    break;
                }
                default: {
                    output.append(ch);
                }
            }
            ++i;
        }
        return output.toString();
    }

    public static String trimForAlphaNumDash(String rawText) {
        int length = rawText.length();
        int i = 0;
        while (i < length) {
            char ch = rawText.charAt(i);
            if (!(ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '-')) {
                return rawText.substring(0, i);
            }
            ++i;
        }
        return rawText;
    }
}

