/*
 * Decompiled with CFR 0.152.
 */
package ecriture;

import ecriture.Roman;
import junit.framework.TestCase;

public class RomanTest
extends TestCase {
    public RomanTest(String arg0) {
        super(arg0);
    }

    public void testConsonneApicale() {
        if (!Roman.consonneApicale('n')) {
            RomanTest.fail();
        }
    }

    public void testTypeLettre() {
        RomanTest.assertTrue((String)"'a' pas reconnue comme une voyelle.", (Roman.typeLettreLat('a') == Roman.V ? 1 : 0) != 0);
        RomanTest.assertTrue((String)"'n' pas reconnue comme une consonne.", (Roman.typeLettreLat('n') == Roman.C ? 1 : 0) != 0);
        RomanTest.assertTrue((String)"'N' pas reconnue comme une consonne.", (Roman.typeLettreLat('N') == Roman.C ? 1 : 0) != 0);
    }

    public void testVoyellePointee() {
        RomanTest.assertTrue((String)"", (boolean)Roman.voyellePointee('\u1432'));
    }

    public void testVoyelleSimple() {
        RomanTest.assertTrue((String)"", (boolean)Roman.voyelleSimple('\u1591'));
    }

    public void testA() {
        RomanTest.assertTrue((String)"", (boolean)Roman.a('\u140a'));
    }

    public void testSylWithSameVowel() {
        RomanTest.assertTrue((String)"", (boolean)Roman.sylWithSameVowel('\u14aa', '\u140a'));
        RomanTest.assertTrue((String)"", (!Roman.sylWithSameVowel('\u14ac', '\u140a') ? 1 : 0) != 0);
    }

    public void testPointeeAdouble() {
        char[] va = Roman.pointeeAdouble('\u14ab');
        RomanTest.assertTrue((String)"", (va != null && va[0] == '\u14aa' && va[1] == '\u140a' ? 1 : 0) != 0);
    }

    public void testTranscodeToUnicodeStringString() {
        String res;
        String targ;
        String str;
        String[][] words = new String[][]{{"pinasualaursimanngituq", "\u1431\u14c7\u14f1\u140a\u14da\u1405\u1550\u14ef\u14aa\u1671\u1450\u1585"}, {"atanngiijjutauniaqpuq", "\u140a\u1455\u1672\u153e\u152a\u1455\u1405\u14c2\u140a\u1585\u1433\u1585"}, {"nunannguatigut", "\u14c4\u14c7\u1673\u140a\u144e\u148d\u1466"}, {"kinnguumajanginnik", "\u146d\u1674\u14aa\u152d\u158f\u14d0\u14c2\u1483"}, {"tunngasugitsi", "\u1450\u1675\u14f1\u148b\u1466\u14ef"}, {"uqautivinngaa", "\u1405\u1583\u1405\u144e\u1555\u1676"}, {"kangiq&iniup", "\u1472\u158f\u1585\u15a0\u14c2\u1405\u1449"}, {"ajjingiinngittuniinniaqtutik", "\u140a\u153e\u1528\u1590\u1671\u1466\u1450\u14c3\u14d0\u14c2\u140a\u1585\u1450\u144e\u1483"}, {"angutiillu", "\u140a\u1591\u144f\u14ea\u14d7"}, {"arraanguulaaqtumi", "\u140a\u1550\u154c\u1592\u14db\u1585\u1450\u14a5"}, {"gavamangannik", "\u1490\u1559\u14aa\u1593\u14d0\u14c2\u1483"}, {"maligaliurvingmiingaarnikuuvugut", "\u14aa\u14d5\u1490\u14d5\u1405\u1550\u1555\u1595\u14a6\u1594\u1550\u14c2\u1470\u1557\u148d\u1466"}, {"utaqqiniq", "\u1405\u1455\u1585\u146d\u14c2\u1585"}, {"utaqqiinnaqtuq", "\u1405\u1455\u1585\u146e\u14d0\u14c7\u1585\u1450\u1585"}, {"nirriku", "\u14c2\u1550\u1546\u146f"}, {"tarriijaamit", "\u1455\u1550\u1547\u152e\u14a5\u1466"}, {"qimiqqujiujut", "\u157f\u14a5\u1585\u146f\u1528\u1405\u152a\u1466"}, {"ilitariqquupuq", "\u1403\u14d5\u1455\u1546\u1585\u1470\u1433\u1585"}, {"qimirruagait", "\u157f\u14a5\u1550\u1548\u140a\u1490\u1403\u1466"}, {"marruuk", "\u14aa\u1550\u1549\u1483"}, {"iniuqqavik", "\u1403\u14c2\u1405\u1585\u1472\u1555\u1483"}, {"itiqqaaqpunga", "\u1403\u144e\u1585\u1473\u1585\u1433\u1593"}, {"angirrapaa", "\u140a\u158f\u1550\u154b\u1439"}, {"arraagu", "\u140a\u1550\u154c\u148d"}, {"ippigitsiaruk", "\u1403\u1449\u1431\u148b\u1466\u14ef\u140a\u1548\u1483"}, {"taku&ugit", "\u1455\u146f\u15a2\u148b\u1466"}, {"ikak&ak", "\u1403\u1472\u1483\u15a4\u1483"}, {"uvvaluunniit", "\u1405\u155d\u1559\u14d8\u14d0\u14c3\u1466"}, {"iilaak", "\u1404\u14db\u1483"}, {"Haamlaujunit", "\u157c\u140b\u14bb\u14da\u1405\u152a\u14c2\u1466"}, {"angillivaalliarjussimajuumuppuq", "\u140a\u158f\u14ea\u14d5\u155a\u14ea\u14d5\u140a\u1550\u152a\u1505\u14ef\u14aa\u152b\u14a7\u1449\u1433\u1585"}, {"taakkuangu&&aqpuq", "\u1456\u1483\u146f\u140a\u1591\u15a6\u15a4\u1585\u1433\u1585"}, {"uumajur&aasuut", "\u1406\u14aa\u152a\u1550\u15a5\u14f2\u1466"}, {"i&uuraarjungnik", "\u1403\u15a3\u154c\u1550\u152a\u1595\u14c2\u1483"}, {"sivu&iinnaq", "\u14ef\u1557\u15a1\u14d0\u14c7\u1585"}, {"marruuliqtuunni", "\u14aa\u1550\u1549\u14d5\u1585\u1451\u14d0\u14c2"}, {"iluunnaaguut", "\u1403\u14d8\u14d0\u14c8\u148e\u1466"}, {"nunavuulimaaq", "\u14c4\u14c7\u1558\u14d5\u14ab\u1585"}, {"sapuulutait", "\u14f4\u1434\u14d7\u1455\u1403\u1466"}, {"tamatumuuna", "\u1455\u14aa\u1450\u14a8\u14c7"}, {"aaggaa", "\u140b\u14a1\u1491"}, {"aajiiqatigiinniq", "\u140b\u1529\u1583\u144e\u148c\u14d0\u14c2\u1585"}, {"siarrijaarviit", "\u14ef\u140a\u1550\u1546\u152e\u1550\u1556\u1466"}, {"unikkaaliulauqpiit", "\u1405\u14c2\u1483\u1473\u14d5\u1405\u14da\u1405\u1585\u1432\u1466"}, {"iliilauqpisii", "\u1403\u14d6\u14da\u1405\u1585\u1431\u14f0"}, {"kiinaujallariit", "\u146e\u14c7\u1405\u152d\u14ea\u14da\u1547\u1466"}};
        String[][] wordsAI = new String[][]{{"aippiqtaulluni", "\u140a\u1403\u1449\u1431\u1585\u1455\u1405\u14ea\u14d7\u14c2", "\u1401\u1449\u1431\u1585\u1455\u1405\u14ea\u14d7\u14c2"}, {"paippaamullu", "\u1438\u1403\u1449\u1439\u14a7\u14ea\u14d7", "\u142f\u1449\u1439\u14a7\u14ea\u14d7"}, {"taikkua", "\u1455\u1403\u1483\u146f\u140a", "\u144c\u1483\u146f\u140a"}, {"kaivallalluaqsunga", "\u1472\u1403\u1559\u14ea\u14da\u14ea\u14d7\u140a\u1585\u14f1\u1593", "\u146b\u1559\u14ea\u14da\u14ea\u14d7\u140a\u1585\u14f1\u1593"}, {"turaagait", "\u1450\u154c\u1490\u1403\u1466", "\u1450\u154c\u1489\u1466"}, {"tamaita", "\u1455\u14aa\u1403\u1455", "\u1455\u14a3\u1455"}, {"nalunairlugu", "\u14c7\u14d7\u14c7\u1403\u1550\u14d7\u148d", "\u14c7\u14d7\u14c0\u1550\u14d7\u148d"}, {"tungaliritsainartilugit", "\u1450\u1593\u14d5\u1546\u1466\u14f4\u1403\u14c7\u1550\u144e\u14d7\u148b\u1466", "\u1450\u1593\u14d5\u1546\u1466\u14ed\u14c7\u1550\u144e\u14d7\u148b\u1466"}, {"allait", "\u140a\u14ea\u14da\u1403\u1466", "\u140a\u14ea\u14d3\u1466"}, {"nunalituqatsajait", "\u14c4\u14c7\u14d5\u1450\u1583\u1466\u14f4\u152d\u1403\u1466", "\u14c4\u14c7\u14d5\u1450\u1583\u1466\u14f4\u1526\u1466"}, {"sanirvaisimavugut", "\u14f4\u14c2\u1550\u1559\u1403\u14ef\u14aa\u1557\u148d\u1466", "\u14f4\u14c2\u1550\u1553\u14ef\u14aa\u1557\u148d\u1466"}, {"nutarait", "\u14c4\u1455\u154b\u1403\u1466", "\u14c4\u1455\u1542\u1466"}, {"qaisimalaurtutuit", "\u1583\u1403\u14ef\u14aa\u14da\u1405\u1550\u1450\u1450\u1403\u1466", "\u166f\u14ef\u14aa\u14da\u1405\u1550\u1450\u1450\u1403\u1466"}, {"tamakkuningaiglunit", "\u1455\u14aa\u1483\u146f\u14c2\u1593\u1403\u14a1\u14d7\u14c2\u1466", "\u1455\u14aa\u1483\u146f\u14c2\u1670\u14a1\u14d7\u14c2\u1466"}, {"saanngainnaraktigu", "\u14f5\u1675\u1403\u14d0\u14c7\u154b\u1483\u144e\u148d", "\u14f5\u1596\u1489\u14d0\u14c7\u154b\u1483\u144e\u148d"}, {"tuqsunuuqqaivuq", "\u1450\u1585\u14f1\u14c5\u1585\u1472\u1403\u1557\u1585", "\u1450\u1585\u14f1\u14c5\u1585\u146b\u1557\u1585"}, {"ikarrait", "\u1403\u1472\u1550\u154b\u1403\u1466", "\u1403\u1472\u1550\u1542\u1466"}};
        int i = 0;
        while (i < words.length) {
            str = words[i][0];
            targ = words[i][1];
            res = Roman.transcodeToUnicode(str, null);
            RomanTest.assertEquals((String)("1. " + res + " au lieu de " + targ), (String)targ, (String)res);
            ++i;
        }
        i = 0;
        while (i < wordsAI.length) {
            str = wordsAI[i][0];
            targ = wordsAI[i][1];
            String targa = wordsAI[i][2];
            res = Roman.transcodeToUnicode(str, null);
            RomanTest.assertEquals((String)("2a. " + res + " au lieu de " + targ), (String)targ, (String)res);
            res = Roman.transcodeToUnicode(str, "aipaitai");
            RomanTest.assertEquals((String)("2b. " + res + " au lieu de " + targa), (String)targa, (String)res);
            ++i;
        }
    }
}

