/*
 * Decompiled with CFR 0.152.
 */
package ecriture;

import java.util.Enumeration;
import java.util.Hashtable;

public class Syllabics {
    public static Hashtable sylXunicode = new Hashtable();
    public static Hashtable unicodeXsyl = new Hashtable();
    static String[][] syllabicsToRomanICI;
    static String[][] syllabicsToRomanAIPAITAI;

    static {
        Syllabics.makeSylXunicode(Short.unicodeXsyl);
        Syllabics.makeSylXunicode(Long.unicodeXsyl);
        Syllabics.makeSylXunicode(Final.unicodeXsyl);
        Syllabics.makeUnicodeXsyl(Short.unicodeXsyl);
        Syllabics.makeUnicodeXsyl(Long.unicodeXsyl);
        Syllabics.makeUnicodeXsyl(Final.unicodeXsyl);
        syllabicsToRomanICI = new String[][]{{"\u1403", "i"}, {"\u1431", "pi"}, {"\u144e", "ti"}, {"\u146d", "ki"}, {"\u148b", "gi"}, {"\u14a5", "mi"}, {"\u14c2", "ni"}, {"\u14ef", "si"}, {"\u14d5", "li"}, {"\u1528", "ji"}, {"\u1555", "vi"}, {"\u1546", "ri"}, {"\u157f", "qi"}, {"\u1585\u146d", "qqi"}, {"\u158f", "ngi"}, {"\u1671", "nngi"}, {"\u158f", "Ni"}, {"\u1671", "Xi"}, {"\u15a0", "&i"}, {"\u1405", "u"}, {"\u1433", "pu"}, {"\u1450", "tu"}, {"\u146f", "ku"}, {"\u148d", "gu"}, {"\u14a7", "mu"}, {"\u14c4", "nu"}, {"\u14f1", "su"}, {"\u14d7", "lu"}, {"\u152a", "ju"}, {"\u1557", "vu"}, {"\u1548", "ru"}, {"\u1581", "qu"}, {"\u1585\u146f", "qqu"}, {"\u1591", "ngu"}, {"\u1673", "nngu"}, {"\u1591", "Nu"}, {"\u1673", "Xu"}, {"\u15a2", "&u"}, {"\u140a", "a"}, {"\u1438", "pa"}, {"\u1455", "ta"}, {"\u1472", "ka"}, {"\u1490", "ga"}, {"\u14aa", "ma"}, {"\u14c7", "na"}, {"\u14f4", "sa"}, {"\u14da", "la"}, {"\u152d", "ja"}, {"\u1559", "va"}, {"\u154b", "ra"}, {"\u1583", "qa"}, {"\u1585\u1472", "qqa"}, {"\u1593", "nga"}, {"\u1675", "nnga"}, {"\u1593", "Na"}, {"\u1675", "Xa"}, {"\u15a4", "&a"}, {"\u1404", "ii"}, {"\u1432", "pii"}, {"\u144f", "tii"}, {"\u146e", "kii"}, {"\u148c", "gii"}, {"\u14a6", "mii"}, {"\u14c3", "nii"}, {"\u14f0", "sii"}, {"\u14d6", "lii"}, {"\u1529", "jii"}, {"\u1556", "vii"}, {"\u1547", "rii"}, {"\u1580", "qii"}, {"\u1585\u146e", "qqii"}, {"\u1590", "ngii"}, {"\u1672", "nngii"}, {"\u1590", "Nii"}, {"\u1672", "Xii"}, {"\u15a1", "&ii"}, {"\u1406", "uu"}, {"\u1434", "puu"}, {"\u1451", "tuu"}, {"\u1470", "kuu"}, {"\u148e", "guu"}, {"\u14a8", "muu"}, {"\u14c5", "nuu"}, {"\u14f2", "suu"}, {"\u14d8", "luu"}, {"\u152b", "juu"}, {"\u1558", "vuu"}, {"\u1549", "ruu"}, {"\u1582", "quu"}, {"\u1585\u1470", "qquu"}, {"\u1592", "nguu"}, {"\u1674", "nnguu"}, {"\u1592", "Nuu"}, {"\u1674", "Xuu"}, {"\u15a3", "&uu"}, {"\u140b", "aa"}, {"\u1439", "paa"}, {"\u1456", "taa"}, {"\u1473", "kaa"}, {"\u1491", "gaa"}, {"\u14ab", "maa"}, {"\u14c8", "naa"}, {"\u14f5", "saa"}, {"\u14db", "laa"}, {"\u152e", "jaa"}, {"\u155a", "vaa"}, {"\u154c", "raa"}, {"\u1584", "qaa"}, {"\u1585\u1473", "qqaa"}, {"\u1594", "ngaa"}, {"\u1676", "nngaa"}, {"\u1594", "Naa"}, {"\u1676", "Xaa"}, {"\u15a5", "&aa"}, {"\u1449", "p"}, {"\u1449", "b"}, {"\u1466", "t"}, {"\u1466", "d"}, {"\u1483", "k"}, {"\u14a1", "g"}, {"\u14bb", "m"}, {"\u14d0", "n"}, {"\u1505", "s"}, {"\u14ea", "l"}, {"\u153e", "j"}, {"\u155d", "v"}, {"\u1550", "r"}, {"\u1585", "q"}, {"\u1595", "ng"}, {"\u1596", "nng"}, {"\u1595", "N"}, {"\u1596", "X"}, {"\u15a6", "&"}, {"\u157c", "h"}, {"\u15af", "b"}};
        syllabicsToRomanAIPAITAI = new String[][]{{"\u1401", "ai"}, {"\u142f", "pai"}, {"\u144c", "tai"}, {"\u146b", "kai"}, {"\u1489", "gai"}, {"\u14a3", "mai"}, {"\u14c0", "nai"}, {"\u14ed", "sai"}, {"\u14d3", "lai"}, {"\u1526", "jai"}, {"\u1553", "vai"}, {"\u1543", "rai"}, {"\u166f", "qai"}, {"\u1670", "ngai"}};
    }

    private static void makeSylXunicode(Hashtable ht) {
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = (String)ht.get(key);
            sylXunicode.put(value, (Character)key);
        }
    }

    private static void makeUnicodeXsyl(Hashtable ht) {
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            String value = (String)ht.get(key);
            unicodeXsyl.put((Character)key, value);
        }
    }

    public static boolean isInuktitutCharacter(char character) {
        return unicodeXsyl.containsKey(new Character(character));
    }

    public static boolean isInuktitutCharacter(Character character) {
        return unicodeXsyl.containsKey(character);
    }

    public static String getSyl(Character character) {
        return (String)unicodeXsyl.get(character);
    }

    public static String getSyl(char character) {
        return (String)unicodeXsyl.get(new Character(character));
    }

    public static Character getCharacter(String syl) {
        return (Character)sylXunicode.get(syl);
    }

    public static boolean allInuktitut(String word) {
        char[] chars = word.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (!Syllabics.isInuktitutCharacter(chars[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsInuktitut(String word) {
        char[] chars = word.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (Syllabics.isInuktitutCharacter(chars[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String transcodeToRoman(String s) {
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            String d;
            char c = s.charAt(i);
            block0 : switch (c) {
                case '\u1403': {
                    d = "i";
                    break;
                }
                case '\u1431': {
                    d = "pi";
                    break;
                }
                case '\u144e': {
                    d = "ti";
                    break;
                }
                case '\u146d': {
                    d = "ki";
                    break;
                }
                case '\u148b': {
                    d = "gi";
                    break;
                }
                case '\u14a5': {
                    d = "mi";
                    break;
                }
                case '\u14c2': {
                    d = "ni";
                    break;
                }
                case '\u14ef': {
                    d = "si";
                    break;
                }
                case '\u14d5': {
                    d = "li";
                    break;
                }
                case '\u1528': {
                    d = "ji";
                    break;
                }
                case '\u1555': {
                    d = "vi";
                    break;
                }
                case '\u1546': {
                    d = "ri";
                    break;
                }
                case '\u157f': {
                    d = "qi";
                    break;
                }
                case '\u158f': {
                    d = "ngi";
                    break;
                }
                case '\u1671': {
                    d = "nngi";
                    break;
                }
                case '\u15a0': {
                    d = "&i";
                    break;
                }
                case '\u1405': {
                    d = "u";
                    break;
                }
                case '\u1433': {
                    d = "pu";
                    break;
                }
                case '\u1450': {
                    d = "tu";
                    break;
                }
                case '\u146f': {
                    d = "ku";
                    break;
                }
                case '\u148d': {
                    d = "gu";
                    break;
                }
                case '\u14a7': {
                    d = "mu";
                    break;
                }
                case '\u14c4': {
                    d = "nu";
                    break;
                }
                case '\u14f1': {
                    d = "su";
                    break;
                }
                case '\u14d7': {
                    d = "lu";
                    break;
                }
                case '\u152a': {
                    d = "ju";
                    break;
                }
                case '\u1557': {
                    d = "vu";
                    break;
                }
                case '\u1548': {
                    d = "ru";
                    break;
                }
                case '\u1581': {
                    d = "qu";
                    break;
                }
                case '\u1591': {
                    d = "ngu";
                    break;
                }
                case '\u1673': {
                    d = "nngu";
                    break;
                }
                case '\u15a2': {
                    d = "&u";
                    break;
                }
                case '\u140a': {
                    d = "a";
                    break;
                }
                case '\u1438': {
                    d = "pa";
                    break;
                }
                case '\u1455': {
                    d = "ta";
                    break;
                }
                case '\u1472': {
                    d = "ka";
                    break;
                }
                case '\u1490': {
                    d = "ga";
                    break;
                }
                case '\u14aa': {
                    d = "ma";
                    break;
                }
                case '\u14c7': {
                    d = "na";
                    break;
                }
                case '\u14f4': {
                    d = "sa";
                    break;
                }
                case '\u14da': {
                    d = "la";
                    break;
                }
                case '\u152d': {
                    d = "ja";
                    break;
                }
                case '\u1559': {
                    d = "va";
                    break;
                }
                case '\u154b': {
                    d = "ra";
                    break;
                }
                case '\u1583': {
                    d = "qa";
                    break;
                }
                case '\u1593': {
                    d = "nga";
                    break;
                }
                case '\u1675': {
                    d = "nnga";
                    break;
                }
                case '\u15a4': {
                    d = "&a";
                    break;
                }
                case '\u1404': {
                    d = "ii";
                    break;
                }
                case '\u1432': {
                    d = "pii";
                    break;
                }
                case '\u144f': {
                    d = "tii";
                    break;
                }
                case '\u146e': {
                    d = "kii";
                    break;
                }
                case '\u148c': {
                    d = "gii";
                    break;
                }
                case '\u14a6': {
                    d = "mii";
                    break;
                }
                case '\u14c3': {
                    d = "nii";
                    break;
                }
                case '\u14f0': {
                    d = "sii";
                    break;
                }
                case '\u14d6': {
                    d = "lii";
                    break;
                }
                case '\u1529': {
                    d = "jii";
                    break;
                }
                case '\u1556': {
                    d = "vii";
                    break;
                }
                case '\u1547': {
                    d = "rii";
                    break;
                }
                case '\u1580': {
                    d = "qii";
                    break;
                }
                case '\u1590': {
                    d = "ngii";
                    break;
                }
                case '\u1672': {
                    d = "nngii";
                    break;
                }
                case '\u15a1': {
                    d = "&ii";
                    break;
                }
                case '\u1406': {
                    d = "uu";
                    break;
                }
                case '\u1434': {
                    d = "puu";
                    break;
                }
                case '\u1451': {
                    d = "tuu";
                    break;
                }
                case '\u1470': {
                    d = "kuu";
                    break;
                }
                case '\u148e': {
                    d = "guu";
                    break;
                }
                case '\u14a8': {
                    d = "muu";
                    break;
                }
                case '\u14c5': {
                    d = "nuu";
                    break;
                }
                case '\u14f2': {
                    d = "suu";
                    break;
                }
                case '\u14d8': {
                    d = "luu";
                    break;
                }
                case '\u152b': {
                    d = "juu";
                    break;
                }
                case '\u1558': {
                    d = "vuu";
                    break;
                }
                case '\u1549': {
                    d = "ruu";
                    break;
                }
                case '\u1582': {
                    d = "quu";
                    break;
                }
                case '\u1592': {
                    d = "nguu";
                    break;
                }
                case '\u1674': {
                    d = "nnguu";
                    break;
                }
                case '\u15a3': {
                    d = "&uu";
                    break;
                }
                case '\u140b': {
                    d = "aa";
                    break;
                }
                case '\u1439': {
                    d = "paa";
                    break;
                }
                case '\u1456': {
                    d = "taa";
                    break;
                }
                case '\u1473': {
                    d = "kaa";
                    break;
                }
                case '\u1491': {
                    d = "gaa";
                    break;
                }
                case '\u14ab': {
                    d = "maa";
                    break;
                }
                case '\u14c8': {
                    d = "naa";
                    break;
                }
                case '\u14f5': {
                    d = "saa";
                    break;
                }
                case '\u14db': {
                    d = "laa";
                    break;
                }
                case '\u152e': {
                    d = "jaa";
                    break;
                }
                case '\u155a': {
                    d = "vaa";
                    break;
                }
                case '\u154c': {
                    d = "raa";
                    break;
                }
                case '\u1584': {
                    d = "qaa";
                    break;
                }
                case '\u1594': {
                    d = "ngaa";
                    break;
                }
                case '\u1676': {
                    d = "nngaa";
                    break;
                }
                case '\u15a5': {
                    d = "&aa";
                    break;
                }
                case '\u1449': {
                    d = "p";
                    break;
                }
                case '\u1466': {
                    d = "t";
                    break;
                }
                case '\u1483': {
                    d = "k";
                    break;
                }
                case '\u14a1': {
                    d = "g";
                    break;
                }
                case '\u14bb': {
                    d = "m";
                    break;
                }
                case '\u14d0': {
                    d = "n";
                    break;
                }
                case '\u1505': {
                    d = "s";
                    break;
                }
                case '\u14ea': {
                    d = "l";
                    break;
                }
                case '\u153e': {
                    d = "j";
                    break;
                }
                case '\u155d': {
                    d = "v";
                    break;
                }
                case '\u1550': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u146d': {
                                d = "qi";
                                break block0;
                            }
                            case '\u146f': {
                                d = "qu";
                                break block0;
                            }
                            case '\u1472': {
                                d = "qa";
                                break block0;
                            }
                            case '\u146e': {
                                d = "qii";
                                break block0;
                            }
                            case '\u1470': {
                                d = "quu";
                                break block0;
                            }
                            case '\u1473': {
                                d = "qaa";
                                break block0;
                            }
                            case '\u146b': {
                                d = "qai";
                                break block0;
                            }
                        }
                        d = "r";
                        --i;
                        break;
                    }
                    --i;
                    d = "r";
                    break;
                }
                case '\u1585': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u146d': {
                                d = "qqi";
                                break block0;
                            }
                            case '\u146f': {
                                d = "qqu";
                                break block0;
                            }
                            case '\u1472': {
                                d = "qqa";
                                break block0;
                            }
                            case '\u146e': {
                                d = "qqii";
                                break block0;
                            }
                            case '\u1470': {
                                d = "qquu";
                                break block0;
                            }
                            case '\u1473': {
                                d = "qqaa";
                                break block0;
                            }
                            case '\u146b': {
                                d = "qqai";
                                break block0;
                            }
                        }
                        d = "q";
                        --i;
                        break;
                    }
                    --i;
                    d = "q";
                    break;
                }
                case '\u1595': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u148b': {
                                d = "ngi";
                                break block0;
                            }
                            case '\u148d': {
                                d = "ngu";
                                break block0;
                            }
                            case '\u1490': {
                                d = "nga";
                                break block0;
                            }
                            case '\u148c': {
                                d = "ngii";
                                break block0;
                            }
                            case '\u148e': {
                                d = "nguu";
                                break block0;
                            }
                            case '\u1491': {
                                d = "ngaa";
                                break block0;
                            }
                            case '\u1489': {
                                d = "ngai";
                                break block0;
                            }
                        }
                        d = "ng";
                        --i;
                        break;
                    }
                    --i;
                    d = "ng";
                    break;
                }
                case '\u1596': {
                    char e;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u148b': {
                                d = "nngi";
                                break block0;
                            }
                            case '\u148d': {
                                d = "nngu";
                                break block0;
                            }
                            case '\u1490': {
                                d = "nnga";
                                break block0;
                            }
                            case '\u148c': {
                                d = "nngii";
                                break block0;
                            }
                            case '\u148e': {
                                d = "nnguu";
                                break block0;
                            }
                            case '\u1491': {
                                d = "nngaa";
                                break block0;
                            }
                            case '\u1489': {
                                d = "nngai";
                                break block0;
                            }
                        }
                        d = "nng";
                        --i;
                        break;
                    }
                    --i;
                    d = "nng";
                    break;
                }
                case '\u15a6': {
                    d = "&";
                    break;
                }
                case '\u157c': {
                    d = "H";
                    break;
                }
                case '\u1574': {
                    d = "hai";
                    break;
                }
                case '\u1575': {
                    d = "hi";
                    break;
                }
                case '\u1576': {
                    d = "hii";
                    break;
                }
                case '\u1577': {
                    d = "hu";
                    break;
                }
                case '\u1578': {
                    d = "huu";
                    break;
                }
                case '\u1579': {
                    d = "ha";
                    break;
                }
                case '\u157a': {
                    d = "haa";
                    break;
                }
                case '\u15af': {
                    d = "b";
                    break;
                }
                case '\u1401': {
                    d = "ai";
                    break;
                }
                case '\u142f': {
                    d = "pai";
                    break;
                }
                case '\u144c': {
                    d = "tai";
                    break;
                }
                case '\u146b': {
                    d = "kai";
                    break;
                }
                case '\u1489': {
                    d = "gai";
                    break;
                }
                case '\u14a3': {
                    d = "mai";
                    break;
                }
                case '\u14c0': {
                    d = "nai";
                    break;
                }
                case '\u14ed': {
                    d = "sai";
                    break;
                }
                case '\u14d3': {
                    d = "lai";
                    break;
                }
                case '\u1526': {
                    d = "jai";
                    break;
                }
                case '\u1553': {
                    d = "vai";
                    break;
                }
                case '\u1543': {
                    d = "rai";
                    break;
                }
                case '\u1542': {
                    d = "rai";
                    break;
                }
                case '\u166f': {
                    d = "qai";
                    break;
                }
                case '\u1670': {
                    d = "ngai";
                    break;
                }
                default: {
                    d = new String(new char[]{c});
                }
            }
            ++i;
            sb.append(d);
        }
        return sb.toString();
    }

    public static String unicodeAIPAITAItoICI(String s) {
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            char c = s.charAt(i);
            switch (c) {
                case '\u1401': {
                    sb.append("\u140a\u1403");
                    break;
                }
                case '\u142f': {
                    sb.append("\u1438\u1403");
                    break;
                }
                case '\u144c': {
                    sb.append("\u1455\u1403");
                    break;
                }
                case '\u146b': {
                    sb.append("\u1472\u1403");
                    break;
                }
                case '\u1489': {
                    sb.append("\u1490\u1403");
                    break;
                }
                case '\u14a3': {
                    sb.append("\u14aa\u1403");
                    break;
                }
                case '\u14c0': {
                    sb.append("\u14c7\u1403");
                    break;
                }
                case '\u14ed': {
                    sb.append("\u14f4\u1403");
                    break;
                }
                case '\u14d3': {
                    sb.append("\u14da\u1403");
                    break;
                }
                case '\u1526': {
                    sb.append("\u152d\u1403");
                    break;
                }
                case '\u1553': {
                    sb.append("\u1559\u1403");
                    break;
                }
                case '\u1543': {
                    sb.append("\u154b\u1403");
                    break;
                }
                case '\u166f': {
                    sb.append("\u1583\u1403");
                    break;
                }
                case '\u1670': {
                    sb.append("\u1593\u1403");
                    break;
                }
                case '\u1596': {
                    int j = i + 1;
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1489': {
                            sb.append("\u1675\u1403");
                            i = j;
                        }
                    }
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String unicodeICItoAIPAITAI(String s) {
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            int c;
            int d = c = s.charAt(i);
            int j = i + 1;
            switch (c) {
                case 5130: {
                    char e;
                    if (j < l) {
                        e = s.charAt(j);
                        switch (e) {
                            case '\u1403': {
                                d = 5121;
                                i = j;
                            }
                        }
                    }
                }
                case 5176: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5167;
                            i = j;
                        }
                    }
                    break;
                }
                case 5205: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5196;
                            i = j;
                        }
                    }
                    break;
                }
                case 5234: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5227;
                            i = j;
                        }
                    }
                    break;
                }
                case 5264: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5257;
                            i = j;
                        }
                    }
                    break;
                }
                case 5290: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5283;
                            i = j;
                        }
                    }
                    break;
                }
                case 5319: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5312;
                            i = j;
                        }
                    }
                    break;
                }
                case 5364: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5357;
                            i = j;
                        }
                    }
                    break;
                }
                case 5338: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5331;
                            i = j;
                        }
                    }
                    break;
                }
                case 5421: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5414;
                            i = j;
                        }
                    }
                    break;
                }
                case 5465: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5459;
                            i = j;
                        }
                    }
                    break;
                }
                case 5451: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5442;
                            i = j;
                        }
                    }
                    break;
                }
                case 5507: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5743;
                            i = j;
                        }
                    }
                    break;
                }
                case 5523: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            d = 5744;
                            i = j;
                        }
                    }
                    break;
                }
                case 5749: {
                    if (j >= l) break;
                    char e = s.charAt(j);
                    switch (e) {
                        case '\u1403': {
                            sb.append('\u1596');
                            d = 5257;
                            i = j;
                        }
                    }
                }
            }
            sb.append((char)d);
            ++i;
        }
        return sb.toString();
    }

    public static class Final {
        public static Hashtable unicodeXsyl = new Hashtable();

        static {
            unicodeXsyl.put(new Character('\u1449'), "p");
            unicodeXsyl.put(new Character('\u1466'), "t");
            unicodeXsyl.put(new Character('\u1483'), "k");
            unicodeXsyl.put(new Character('\u14a1'), "g");
            unicodeXsyl.put(new Character('\u14bb'), "m");
            unicodeXsyl.put(new Character('\u14d0'), "n");
            unicodeXsyl.put(new Character('\u1505'), "s");
            unicodeXsyl.put(new Character('\u14ea'), "l");
            unicodeXsyl.put(new Character('\u153e'), "j");
            unicodeXsyl.put(new Character('\u155d'), "v");
            unicodeXsyl.put(new Character('\u1550'), "r");
            unicodeXsyl.put(new Character('\u1585'), "q");
            unicodeXsyl.put(new Character('\u1595'), "N");
            unicodeXsyl.put(new Character('\u1596'), "X");
            unicodeXsyl.put(new Character('\u15a6'), "&");
            unicodeXsyl.put(new Character('\u157c'), "h");
            unicodeXsyl.put(new Character('\u15af'), "b");
        }
    }

    public static class Long {
        public static Hashtable unicodeXsyl = new Hashtable();

        static {
            unicodeXsyl.put(new Character('\u1404'), "ii");
            unicodeXsyl.put(new Character('\u1432'), "pii");
            unicodeXsyl.put(new Character('\u144f'), "tii");
            unicodeXsyl.put(new Character('\u146e'), "kii");
            unicodeXsyl.put(new Character('\u148c'), "gii");
            unicodeXsyl.put(new Character('\u14a6'), "mii");
            unicodeXsyl.put(new Character('\u14c3'), "nii");
            unicodeXsyl.put(new Character('\u14f0'), "sii");
            unicodeXsyl.put(new Character('\u14d6'), "lii");
            unicodeXsyl.put(new Character('\u1529'), "jii");
            unicodeXsyl.put(new Character('\u1556'), "vii");
            unicodeXsyl.put(new Character('\u1547'), "rii");
            unicodeXsyl.put(new Character('\u1580'), "qii");
            unicodeXsyl.put(new Character('\u1590'), "Nii");
            unicodeXsyl.put(new Character('\u1672'), "Xii");
            unicodeXsyl.put(new Character('\u15a1'), "&ii");
            unicodeXsyl.put(new Character('\u1406'), "uu");
            unicodeXsyl.put(new Character('\u1434'), "puu");
            unicodeXsyl.put(new Character('\u1451'), "tuu");
            unicodeXsyl.put(new Character('\u1470'), "kuu");
            unicodeXsyl.put(new Character('\u148e'), "guu");
            unicodeXsyl.put(new Character('\u14a8'), "muu");
            unicodeXsyl.put(new Character('\u14c5'), "nuu");
            unicodeXsyl.put(new Character('\u14f2'), "suu");
            unicodeXsyl.put(new Character('\u14d8'), "luu");
            unicodeXsyl.put(new Character('\u152b'), "juu");
            unicodeXsyl.put(new Character('\u1558'), "vuu");
            unicodeXsyl.put(new Character('\u1549'), "ruu");
            unicodeXsyl.put(new Character('\u1582'), "quu");
            unicodeXsyl.put(new Character('\u1592'), "Nuu");
            unicodeXsyl.put(new Character('\u1674'), "Xuu");
            unicodeXsyl.put(new Character('\u15a3'), "&uu");
            unicodeXsyl.put(new Character('\u140b'), "aa");
            unicodeXsyl.put(new Character('\u1439'), "paa");
            unicodeXsyl.put(new Character('\u1456'), "taa");
            unicodeXsyl.put(new Character('\u1473'), "kaa");
            unicodeXsyl.put(new Character('\u1491'), "gaa");
            unicodeXsyl.put(new Character('\u14ab'), "maa");
            unicodeXsyl.put(new Character('\u14c8'), "naa");
            unicodeXsyl.put(new Character('\u14f5'), "saa");
            unicodeXsyl.put(new Character('\u14db'), "laa");
            unicodeXsyl.put(new Character('\u152e'), "jaa");
            unicodeXsyl.put(new Character('\u155a'), "vaa");
            unicodeXsyl.put(new Character('\u154c'), "raa");
            unicodeXsyl.put(new Character('\u1584'), "qaa");
            unicodeXsyl.put(new Character('\u1594'), "Naa");
            unicodeXsyl.put(new Character('\u1676'), "Xaa");
            unicodeXsyl.put(new Character('\u15a5'), "&aa");
        }
    }

    public static class Short {
        public static Hashtable unicodeXsyl = new Hashtable();

        static {
            unicodeXsyl.put(new Character('\u1403'), "i");
            unicodeXsyl.put(new Character('\u1431'), "pi");
            unicodeXsyl.put(new Character('\u144e'), "ti");
            unicodeXsyl.put(new Character('\u146d'), "ki");
            unicodeXsyl.put(new Character('\u148b'), "gi");
            unicodeXsyl.put(new Character('\u14a5'), "mi");
            unicodeXsyl.put(new Character('\u14c2'), "ni");
            unicodeXsyl.put(new Character('\u14ef'), "si");
            unicodeXsyl.put(new Character('\u14d5'), "li");
            unicodeXsyl.put(new Character('\u1528'), "ji");
            unicodeXsyl.put(new Character('\u1555'), "vi");
            unicodeXsyl.put(new Character('\u1546'), "ri");
            unicodeXsyl.put(new Character('\u157f'), "qi");
            unicodeXsyl.put(new Character('\u158f'), "Ni");
            unicodeXsyl.put(new Character('\u1671'), "Xi");
            unicodeXsyl.put(new Character('\u15a0'), "&i");
            unicodeXsyl.put(new Character('\u1405'), "u");
            unicodeXsyl.put(new Character('\u1433'), "pu");
            unicodeXsyl.put(new Character('\u1450'), "tu");
            unicodeXsyl.put(new Character('\u146f'), "ku");
            unicodeXsyl.put(new Character('\u148d'), "gu");
            unicodeXsyl.put(new Character('\u14a7'), "mu");
            unicodeXsyl.put(new Character('\u14c4'), "nu");
            unicodeXsyl.put(new Character('\u14f1'), "su");
            unicodeXsyl.put(new Character('\u14d7'), "lu");
            unicodeXsyl.put(new Character('\u152a'), "ju");
            unicodeXsyl.put(new Character('\u1557'), "vu");
            unicodeXsyl.put(new Character('\u1548'), "ru");
            unicodeXsyl.put(new Character('\u1581'), "qu");
            unicodeXsyl.put(new Character('\u1591'), "Nu");
            unicodeXsyl.put(new Character('\u1673'), "Xu");
            unicodeXsyl.put(new Character('\u15a2'), "&u");
            unicodeXsyl.put(new Character('\u140a'), "a");
            unicodeXsyl.put(new Character('\u1438'), "pa");
            unicodeXsyl.put(new Character('\u1455'), "ta");
            unicodeXsyl.put(new Character('\u1472'), "ka");
            unicodeXsyl.put(new Character('\u1490'), "ga");
            unicodeXsyl.put(new Character('\u14aa'), "ma");
            unicodeXsyl.put(new Character('\u14c7'), "na");
            unicodeXsyl.put(new Character('\u14f4'), "sa");
            unicodeXsyl.put(new Character('\u14da'), "la");
            unicodeXsyl.put(new Character('\u152d'), "ja");
            unicodeXsyl.put(new Character('\u1559'), "va");
            unicodeXsyl.put(new Character('\u154b'), "ra");
            unicodeXsyl.put(new Character('\u1583'), "qa");
            unicodeXsyl.put(new Character('\u1593'), "Na");
            unicodeXsyl.put(new Character('\u1675'), "Xa");
            unicodeXsyl.put(new Character('\u15a4'), "&a");
        }
    }
}

