/*
 * Decompiled with CFR 0.152.
 */
package ecriture;

import ecriture.Syllabics;
import ecriture.TransCoder;
import html.HtmlEntities;
import org.apache.log4j.Logger;
import utilites1.Util;

public class Transcode {
    private static Logger LOG;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ecriture.Transcode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = Logger.getLogger((Class)clazz);
    }

    public static String transcode(String[] args) {
        String text = "";
        String from = Util.getArgument(args, "From");
        String to = Util.getArgument(args, "To");
        String toaipaitai = Util.getArgument(args, "ToAipaitai");
        boolean aipaitai = false;
        if (toaipaitai != null) {
            aipaitai = true;
        }
        String fromLC = from.toLowerCase();
        String toLC = to.toLowerCase();
        String source = Util.getArgument(args, "source");
        LOG.debug((Object)("source= " + source));
        if (fromLC.equals("unicode")) {
            if (toLC.equals("roman alphabet")) {
                text = TransCoder.unicodeToRoman(source);
            } else if (toLC.equals("url encoding")) {
                text = TransCoder.unicodeToUrlencoding(source);
            } else if (toLC.equals("unicode")) {
                text = toaipaitai != null ? Syllabics.unicodeICItoAIPAITAI(source) : source;
            } else if (toLC.equals("unicode \\uxxxx")) {
                text = toaipaitai != null ? TransCoder.unicodeToUnistring(Syllabics.unicodeICItoAIPAITAI(source)) : TransCoder.unicodeToUnistring(source);
            } else if (toLC.equals("html entity")) {
                text = toaipaitai != null ? Syllabics.unicodeICItoAIPAITAI(source) : source;
                text = TransCoder.unicodeToHtmlEntity(text);
            } else {
                text = TransCoder.unicodeToLegacy(source, toLC);
            }
        } else if (fromLC.equals("unicode \\uxxxx")) {
            String uni = TransCoder.unistringToUnicode(source);
            text = toLC.equals("roman alphabet") ? TransCoder.unicodeToRoman(uni) : (toLC.equals("url encoding") ? TransCoder.unicodeToUrlencoding(uni) : (toLC.equals("unicode") ? (toaipaitai != null ? Syllabics.unicodeICItoAIPAITAI(uni) : Syllabics.unicodeAIPAITAItoICI(uni)) : (toLC.equals("unicode \\uxxxx") ? (toaipaitai != null ? TransCoder.unicodeToUnistring(Syllabics.unicodeICItoAIPAITAI(uni)) : source) : TransCoder.unicodeToLegacy(uni, toLC))));
        } else if (fromLC.equals("html entity")) {
            String uni = HtmlEntities.fromHTMLEntity(source);
            if (toLC.equals("roman alphabet")) {
                text = TransCoder.unicodeToRoman(uni);
            } else if (toLC.equals("html entity")) {
                text = source;
                text = text.replaceAll("&", "&amp;");
            } else {
                text = toLC.equals("url encoding") ? TransCoder.unicodeToUrlencoding(uni) : (toLC.equals("unicode") ? (toaipaitai != null ? Syllabics.unicodeICItoAIPAITAI(uni) : Syllabics.unicodeAIPAITAItoICI(uni)) : (toLC.equals("unicode \\uxxxx") ? (toaipaitai != null ? TransCoder.unicodeToUnistring(Syllabics.unicodeICItoAIPAITAI(uni)) : source) : TransCoder.unicodeToLegacy(uni, toLC)));
            }
        } else if (fromLC.equals("roman alphabet")) {
            if (toLC.equals("aipainunavik") || toLC.equals("aipainuna") || toLC.equals("ainunavik")) {
                text = TransCoder.romanToUnicode(source, true);
                text = TransCoder.unicodeToLegacy(text, to);
            } else if (toLC.equals("roman alphabet")) {
                text = source;
            } else if (toLC.equals("url encoding")) {
                text = TransCoder.romanToUnicode(source, true);
                text = TransCoder.unicodeToUrlencoding(text);
            } else if (toLC.equals("unicode")) {
                text = toaipaitai != null ? TransCoder.romanToUnicode(source, true) : TransCoder.romanToUnicode(source);
            } else if (toLC.equals("unicode \\uxxxx")) {
                text = toaipaitai != null ? TransCoder.romanToUnicode(source, true) : TransCoder.romanToUnicode(source);
                text = TransCoder.unicodeToUnistring(text);
            } else if (toLC.equals("html entity")) {
                text = toaipaitai != null ? TransCoder.romanToUnicode(source, true) : TransCoder.romanToUnicode(source);
                text = TransCoder.unicodeToHtmlEntity(text);
            } else {
                text = TransCoder.romanToUnicode(source);
                text = TransCoder.unicodeToLegacy(text, to);
            }
        } else if (toLC.equals("aipainunavik") || toLC.equals("ainunavik") || toLC.equals("aipainuna")) {
            text = TransCoder.legacyToUnicode(source, from, true);
            text = TransCoder.unicodeToLegacy(text, to);
        } else if (toLC.equals("roman alphabet")) {
            text = TransCoder.legacyToRoman(source, from);
        } else if (toLC.equals("url encoding")) {
            text = TransCoder.legacyToUnicode(source, from);
            text = TransCoder.unicodeToUrlencoding(text);
        } else if (toLC.equals("unicode")) {
            text = TransCoder.legacyToUnicode(source, from, aipaitai);
        } else if (toLC.equals("unicode \\uxxxx")) {
            text = TransCoder.legacyToUnicode(source, from, aipaitai);
            text = TransCoder.unicodeToUnistring(text);
        } else if (toLC.equals("html entity")) {
            text = TransCoder.legacyToUnicode(source, from, aipaitai);
            text = TransCoder.unicodeToHtmlEntity(text);
        } else {
            text = TransCoder.legacyToUnicode(source, from);
            text = TransCoder.unicodeToLegacy(text, to);
        }
        return text;
    }

    public static void main(String[] args) {
        String txt = Transcode.transcode(args);
        System.out.println(txt);
    }
}

