/*
 * Decompiled with CFR 0.152.
 */
package html;

import documents.WebPageReader;
import html.BetweenTag;
import html.DynamicArrayOfByte;
import html.HTMLDocuElement;
import html.Tag;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class HtmlDocu {
    public String encoding = null;
    public String encodingSource = null;
    public Vector elements = null;
    public URL url = null;
    static Object[][] bom = new Object[][]{{new Byte[]{new Byte(-17), new Byte(-69), new Byte(-65)}, "UTF-8"}, {new Byte[]{new Byte(-2), new Byte(-1)}, "UTF-16BE"}, {new Byte[]{new Byte(-1), new Byte(-2)}, "UTF-16LE"}};

    public HtmlDocu(URL url) throws MalformedURLException, IOException {
        WebPageReader wpr = new WebPageReader(url.toExternalForm());
        this.url = wpr.url;
        String contentType = wpr.connection.getContentType().toLowerCase();
        if (contentType != null) {
            try {
                Pattern p = Pattern.compile("text/html;\\s?charset=(.+)");
                Matcher mp = p.matcher(contentType);
                if (mp.find()) {
                    this.encoding = mp.group(1);
                    this.encodingSource = "http header";
                }
            }
            catch (PatternSyntaxException e) {
                e.printStackTrace(System.err);
            }
        }
        InputStream stream = this.url.openStream();
        this.parse(stream);
        HTMLDocuElement first = (HTMLDocuElement)this.elements.elementAt(0);
        if (first.getType() == 2) {
            byte[] bs = first.getBytes();
            int i = 0;
            while (i < bom.length) {
                Byte[] bbom = (Byte[])bom[i][0];
                if (bbom.length == bs.length) {
                    int j = 0;
                    j = 0;
                    while (j < bbom.length) {
                        if (bbom[j] != bs[j]) break;
                        ++j;
                    }
                    if (j == bbom.length) {
                        if (this.encoding == null) {
                            this.encoding = (String)bom[i][1];
                            this.encodingSource = "bom";
                        }
                        this.elements.remove(0);
                        break;
                    }
                }
                ++i;
            }
        }
        if (this.encoding == null) {
            this.encoding = "ISO-8859-1";
        }
        int i = 0;
        while (i < this.elements.size()) {
            HTMLDocuElement elm = (HTMLDocuElement)this.elements.elementAt(i);
            if (elm.getType() == 2) {
                elm.setText(this.encoding);
            }
            ++i;
        }
        stream.close();
    }

    public HtmlDocu(File file, String encoding) throws IOException {
        FileInputStream is = new FileInputStream(file);
        this.parse(is);
        int i = 0;
        while (i < this.elements.size()) {
            HTMLDocuElement elm = (HTMLDocuElement)this.elements.elementAt(i);
            if (elm.getType() == 2 || elm.getType() == 1) {
                elm.setText(encoding);
            }
            ++i;
        }
        this.encoding = encoding;
        ((InputStream)is).close();
    }

    public HtmlDocu(InputStream is, String encoding) throws IOException {
        this.parse(is);
        int i = 0;
        while (i < this.elements.size()) {
            HTMLDocuElement elm = (HTMLDocuElement)this.elements.elementAt(i);
            if (elm.getType() == 2 || elm.getType() == 1) {
                elm.setText(encoding);
            }
            ++i;
        }
        this.encoding = encoding;
        is.close();
    }

    static boolean isHtmlSpace(int c) {
        switch (c) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: 
            case 8203: {
                return true;
            }
        }
        return false;
    }

    void parse(InputStream is) throws IOException {
        int c;
        Pattern tagPattern = Pattern.compile("^<([^\\s>]+)");
        boolean readingTag = false;
        boolean tagIsRead = false;
        boolean readingHtmlComment = false;
        DynamicArrayOfByte tagBs = new DynamicArrayOfByte(100);
        DynamicArrayOfByte txtBs = new DynamicArrayOfByte(100);
        this.elements = new Vector();
        while ((c = is.read()) != -1) {
            if ((byte)c == 62) {
                if (readingTag) {
                    if (readingHtmlComment && tagBs.get(-1) == 45 && tagBs.get(-2) == 45 || !readingHtmlComment) {
                        String enc;
                        tagBs.add((byte)c);
                        readingTag = false;
                        Tag tag = new Tag(tagBs);
                        if (this.encoding == null && tag.tag.equals("meta") && (enc = tag.getEncodingFromMetaTag()) != null) {
                            this.encoding = enc;
                        }
                        tagBs = new DynamicArrayOfByte(100);
                        tagIsRead = false;
                        readingHtmlComment = false;
                        this.elements.add(tag);
                        continue;
                    }
                    tagBs.add((byte)c);
                    continue;
                }
                txtBs.add((byte)c);
                continue;
            }
            if (readingTag) {
                if (!tagIsRead && HtmlDocu.isHtmlSpace(c)) {
                    try {
                        String tagCandidate = new String(tagBs.getBytes());
                        Matcher mtag = tagPattern.matcher(tagCandidate);
                        mtag.find();
                        String tag = mtag.group(1);
                        if (tag.equals("!--")) {
                            readingHtmlComment = true;
                        }
                        tagIsRead = true;
                    }
                    catch (PatternSyntaxException e) {
                        e.printStackTrace(System.err);
                    }
                }
                tagBs.add((byte)c);
                continue;
            }
            if ((byte)c == 60 && !readingTag) {
                int c1 = is.read();
                if (c1 == -1) break;
                if (HtmlDocu.isHtmlSpace(c1)) {
                    txtBs.add((byte)c1);
                    continue;
                }
                readingTag = true;
                tagBs.add((byte)c);
                tagBs.add((byte)c1);
                if (txtBs.size() != 0) {
                    this.elements.add(new BetweenTag(txtBs));
                }
                txtBs = new DynamicArrayOfByte(100);
                continue;
            }
            txtBs.add((byte)c);
        }
    }

    public void write(OutputStream os) throws IOException {
        int i = 0;
        while (i < this.elements.size()) {
            HTMLDocuElement elm = (HTMLDocuElement)this.elements.elementAt(i);
            os.write(elm.getBytes());
            ++i;
        }
        os.flush();
    }

    public void write(OutputStream os, String encoding) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, encoding);
        int i = 0;
        while (i < this.elements.size()) {
            HTMLDocuElement elm = (HTMLDocuElement)this.elements.elementAt(i);
            String str = elm.getText();
            int j = 0;
            while (j < str.length()) {
                osw.write(str.charAt(j));
                ++j;
            }
            ++i;
        }
        osw.flush();
    }

    public String print() {
        StringBuffer res = new StringBuffer("");
        int i = 0;
        while (i < this.elements.size()) {
            HTMLDocuElement elm = (HTMLDocuElement)this.elements.elementAt(i);
            res.append(elm.getText());
            ++i;
        }
        return res.toString();
    }

    public void insertBase(String urlName) {
        Tag base = new Tag(HtmlDocu.makeBaseTag(urlName), null);
        this.insertTagInHead(base);
    }

    public void insertBase(URL url) {
        Tag base = new Tag(HtmlDocu.makeBaseTag(url), null);
        this.insertTagInHead(base);
    }

    public void insertLinkCSS(String url) {
        Tag link = new Tag("<link href=\"" + url + "\" rel=\"stylesheet\" type=\"text/css\"", "iso-8859-1");
        this.insertTagInHead(link);
    }

    private void insertTagInHead(Tag newtag) {
        int i = 0;
        while (i < this.elements.size()) {
            String tag;
            HTMLDocuElement elm = (HTMLDocuElement)this.elements.elementAt(i);
            if (elm.getType() == 1 && !(tag = ((Tag)elm).tag).equals("html")) {
                if (tag.equals("head")) {
                    this.elements.add(i + 1, newtag);
                    break;
                }
                if (Character.isLetter(tag.charAt(0))) {
                    this.elements.add(i, newtag);
                    break;
                }
            }
            ++i;
        }
    }

    static String makeBaseTag(URL url) {
        return "<base href=\"" + url.toExternalForm() + "\">";
    }

    static String makeBaseTag(String urlName) {
        return "<base href=\"" + urlName + "\">";
    }

    public void insertMetaContentType(String charset) {
        Tag meta = new Tag(HtmlDocu.makeMetaContentTypeTag(charset), null);
        this.insertTagInHead(meta);
    }

    static String makeMetaContentTypeTag(String charset) {
        return "<meta http-equiv=\"Content-Type\" content=\"text/html" + (charset == null ? "\">" : "; charset=" + charset + "\">");
    }
}

