/*
 * Decompiled with CFR 0.152.
 */
package html;

import html.DynamicArrayOfByte;
import java.io.UnsupportedEncodingException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.tidy.EntityTable;

public final class HtmlEntities {
    public static Pattern pEntity = Pattern.compile("(&[^;]+?);");
    static Pattern pEnt = Pattern.compile("&[^;]+?;");
    public static EntityTable et = EntityTable.getDefaultEntityTable();
    public static Pattern pHtmlEntity = Pattern.compile("&((#[xX]?[a-fA-F0-9]+)|([a-zA-Z0-9]+))");

    public static String entityToChar(String str) {
        int pos = 0;
        int limit = str.length();
        StringBuffer sb = new StringBuffer();
        Matcher mpEntity = pHtmlEntity.matcher(str);
        while (pos < limit) {
            if (mpEntity.find(pos)) {
                String ent = new String(mpEntity.group());
                sb.append(str.substring(pos, mpEntity.start()));
                short d = et.entityCode(ent);
                char c = (char)d;
                sb.append(c);
                pos = mpEntity.end();
                if (pos >= limit || str.charAt(pos) != ';') continue;
                ++pos;
                continue;
            }
            sb.append(str.charAt(pos++));
        }
        return sb.toString();
    }

    public static String entityToChar(DynamicArrayOfByte bs, String encoding) {
        byte[] bytes = bs.getBytes();
        String str = null;
        try {
            str = encoding == null ? new String(bytes) : new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String str1 = HtmlEntities.entityToChar(str);
        return str1;
    }

    public static String toStringInuktitut(String str) {
        int pos = 0;
        int limit = str.length();
        StringBuffer sb = new StringBuffer();
        while (pos < limit) {
            Matcher mpEntity = pHtmlEntity.matcher(str);
            if (mpEntity.find(pos)) {
                String ent = new String(mpEntity.group());
                if (et.entityCode(ent) > 5120 && et.entityCode(ent) < 5759) {
                    sb.append(str.substring(pos, mpEntity.start()));
                    sb.append((char)et.entityCode(ent));
                    pos = mpEntity.end();
                    if (pos >= limit || str.charAt(pos) != ';') continue;
                    ++pos;
                    continue;
                }
                sb.append(str.substring(pos, mpEntity.start()));
                sb.append(mpEntity.group());
                pos = mpEntity.end();
                continue;
            }
            sb.append(str.charAt(pos++));
        }
        return sb.toString();
    }

    public static String substring(String str, int startPos) {
        return HtmlEntities.substring(str, startPos, str.length());
    }

    public static String substring(String str, int startPos, int endPos) {
        Matcher m = pHtmlEntity.matcher(str);
        int pos = 0;
        int cntr = 0;
        String sub = "";
        int limit = str.length();
        while (pos < str.length()) {
            if (m.find(pos) && m.start() == pos) {
                if (cntr >= startPos && cntr < endPos) {
                    sub = String.valueOf(sub) + str.substring(pos, m.end());
                    if (str.charAt(m.end()) == ';') {
                        sub = String.valueOf(sub) + ";";
                    }
                }
                ++cntr;
                pos = m.end();
                if (pos >= limit || str.charAt(pos) != ';') continue;
                ++pos;
                continue;
            }
            if (cntr >= startPos && cntr < endPos) {
                sub = String.valueOf(sub) + str.charAt(pos);
            }
            ++cntr;
            ++pos;
        }
        return sub;
    }

    public static String fromHTMLEntity(String s) {
        String str = HtmlEntities.entityToChar(s);
        return str;
    }

    public static String toHtmlEntity(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            sb.append("&#" + Integer.toString(s.charAt(i), 10) + ";");
            ++i;
        }
        return sb.toString();
    }
}

