/*
 * Decompiled with CFR 0.152.
 */
package polices;

import ecriture.TransCoder;
import java.util.HashSet;
import java.util.Set;

public class PoliceAipainunavik {
    public static String[][] unicodesICIaCodes;
    public static String[][] unicodesICIaCodesDigits;
    public static String[][] unicodesICIaCodesOthers;
    public static String[][] unicodesAIPAITAIaCodes;
    public static TransCoder transcoderToUnicodeICI;
    public static TransCoder transcoderToUnicodeAIPAITAI;
    public static TransCoder transcoderToFontICI;
    public static TransCoder transcoderToFontAIPAITAI;
    public static String wordChars;
    public static Set policeChars;

    static {
        int j;
        unicodesICIaCodes = new String[][]{{"\u1403", "w"}, {"\u1431", "W"}, {"\u144e", "t"}, {"\u146d", "r"}, {"\u148b", "Q"}, {"\u14a5", "u"}, {"\u14c2", "i"}, {"\u14ef", "y"}, {"\u14d5", "o"}, {"\u1528", "p"}, {"\u1555", "["}, {"\u1546", "E"}, {"\u157f", "e"}, {"\u158f", "q"}, {"\u1671", "\u2021"}, {"\u1671", "\u0087"}, {"\u15a0", "\u00c3"}, {"\u1404", "\u2122"}, {"\u1404", "\u0099"}, {"\u1432", "\u201e"}, {"\u1432", "\u0084"}, {"\u144f", "\u2020"}, {"\u144f", "\u0086"}, {"\u146e", "\u00ae"}, {"\u148c", "\u0152"}, {"\u148c", "\u008c"}, {"\u14a6", "\u00fc"}, {"\u14c3", "\u00ee"}, {"\u14f0", "\u00a5"}, {"\u14d6", "\u00f8"}, {"\u1529", "\u00ba"}, {"\u1556", "\u201c"}, {"\u1556", "\u0093"}, {"\u1547", "\u2030"}, {"\u1547", "\u0089"}, {"\u1580", "\u00e9"}, {"\u1590", "\u0153"}, {"\u1590", "\u009c"}, {"\u1672", "\u00b7"}, {"\u15a1", "\u00ed"}, {"\u1405", "s"}, {"\u1433", "S"}, {"\u1450", "g"}, {"\u146f", "f"}, {"\u148d", "A"}, {"\u14a7", "j"}, {"\u14c4", "k"}, {"\u14f1", "h"}, {"\u14d7", "l"}, {"\u152a", "J"}, {"\u1557", "K"}, {"\u1548", "D"}, {"\u1581", "d"}, {"\u1591", "a"}, {"\u1673", "\u201a"}, {"\u1673", "\u0082"}, {"\u15a2", "\u00c0"}, {"\u1406", "\u00df"}, {"\u1434", "\u00cd"}, {"\u1451", "\u00a9"}, {"\u1470", "\u0192"}, {"\u1470", "\u0083"}, {"\u148e", "\u00c5"}, {"\u14a8", "\u00cb"}, {"\u14c5", "\u00aa"}, {"\u14f2", "\u00a7"}, {"\u14d8", "\u00ac"}, {"\u152b", "\u00d4"}, {"\u1558", "\u00d3"}, {"\u1549", "\u00ce"}, {"\u1582", "\u00da"}, {"\u1592", "\u00e5"}, {"\u1674", "\u00c2"}, {"\u15a3", "\u00ec"}, {"\u140a", "x"}, {"\u1438", "X"}, {"\u1455", "b"}, {"\u1472", "v"}, {"\u1490", "Z"}, {"\u14aa", "m"}, {"\u14c7", "N"}, {"\u14f4", "n"}, {"\u14da", "M"}, {"\u152d", "/"}, {"\u1559", "?"}, {"\u154b", "C"}, {"\u1583", "c"}, {"\u1593", "z"}, {"\u1675", "\u00ca"}, {"\u15a4", "\u0178"}, {"\u15a4", "\u009f"}, {"\u140b", "\u20ac"}, {"\u140b", "\u0080"}, {"\u1439", "\u00d9"}, {"\u1456", "\u00cc"}, {"\u1473", "\u00cf"}, {"\u1491", "\u00db"}, {"\u14ab", "\u00b5"}, {"\u14c8", "\u02c6"}, {"\u14c8", "\u0088"}, {"\u14f5", "\u00f1"}, {"\u14db", "\u02dc"}, {"\u14db", "\u0098"}, {"\u152e", "\u00f7"}, {"\u155a", "\u00bf"}, {"\u154c", "\u00c7"}, {"\u1584", "\u00e7"}, {"\u1594", "\u00af"}, {"\u1676", "\u00c1"}, {"\u15a5", "\u00ef"}, {"\u1449", "2"}, {"\u1466", "5"}, {"\u1483", "4"}, {"\u14a1", "="}, {"\u14bb", "7"}, {"\u14d0", "8"}, {"\u1505", "+"}, {"\u14ea", "9"}, {"\u153e", "0"}, {"\u155d", "{"}, {"\u1550", "3"}, {"\u1585", "6"}, {"\u1595", "1"}, {"\u1596", "\u00d2"}, {"\u15a6", "\u00d5"}, {"\u157c", "\u00ff"}, {"\u157b", "\""}, {"\u1575", "L"}, {"\u1576", "\u00d8"}, {"\u1577", "O"}, {"\u1578", "\u201d"}, {"\u1578", "\u0094"}, {"\u1579", "P"}, {"\u157a", "\u00bb"}, {"\u1574", "\u00a8"}};
        unicodesICIaCodesDigits = new String[][]{{"1", "!"}, {"3", "#"}, {"4", "$"}, {"5", "%"}, {"7", "&"}, {"9", "("}, {"0", ")"}, {"8", "*"}, {"6", "^"}, {"2", "@"}};
        unicodesICIaCodesOthers = new String[][]{{"'", "<"}, {"\"", ">"}, {"\u00f7", "B"}, {"/", "F"}, {"(", "G"}, {")", "H"}, {"$", "R"}, {"+", "T"}, {"=", "U"}, {"?", "V"}, {"\u00d7", "Y"}, {"[", "]"}, {"]", "}"}, {"\u2026", "\u0085"}, {"\u00ab", "\u2039"}, {"\u00ab", "\u008b"}, {"\u201c", "\u2018"}, {"\u201c", "\u0091"}, {"\u201d", "\u2019"}, {"\u201d", "\u0092"}, {"*", "\u2022"}, {"*", "\u0095"}, {"\u00bb", "\u203a"}, {"\u00bb", "\u009b"}, {"!", "\u00a1"}, {"#", "\u00a3"}, {"\u2022", "\u00ab"}, {"&", "\u00b4"}, {"%", "\u00b6"}, {"\u141e", "\u00b8"}, {"@", "\u00c4"}, {"\u2019", "\u00c6"}, {"\u2018", "\u00e6"}, {"F", "\u00f3"}, {"\u00b6", "\u00f5"}, {"\u00a7", "\u00f6"}, {"\u00a9", "\u00f9"}, {"\u2122", "\u00fa"}, {"\u00ae", "\u00fb"}, {"\u140a\u1403", "\u00c9"}, {"\u1438\u1403", "\u00d1"}, {"\u1455\u1403", "\u00d6"}, {"\u1472\u1403", "\u00dc"}, {"\u1490\u1403", "\u00e1"}, {"\u14aa\u1403", "\u00e0"}, {"\u14c7\u1403", "\u00e2"}, {"\u14f4\u1403", "\u00e3"}, {"\u14da\u1403", "\u00e4"}, {"\u152d\u1403", "\u00e8"}, {"\u1559\u1403", "\u00eb"}, {"\u154b\u1403", "\u00ea"}, {"\u1583\u1403", "\u00f2"}, {"\u1593\u1403", "\u00f4"}};
        unicodesAIPAITAIaCodes = new String[][]{{"\u1401", "\u00c9"}, {"\u142f", "\u00d1"}, {"\u144c", "\u00d6"}, {"\u146b", "\u00dc"}, {"\u1489", "\u00e1"}, {"\u14a3", "\u00e0"}, {"\u14c0", "\u00e2"}, {"\u14ed", "\u00e3"}, {"\u14d3", "\u00e4"}, {"\u1526", "\u00e8"}, {"\u1553", "\u00eb"}, {"\u1543", "\u00ea"}, {"\u166f", "\u00f2"}, {"\u1670", "\u00f4"}};
        policeChars = new HashSet();
        wordChars = "[!#-&(-*@\"+/0-9=?AC-EJ-QSWXZ\\[\\^a-z{\\u2022\\u0095\\u20ac\\u0080\\u201a\\u0082\\u0192\\u0083\\u201e";
        wordChars = String.valueOf(wordChars) + "\\u0084\\u2020\\u0086\\u2021\\u0087\\u02c6\\u0088\\u2030\\u0089";
        wordChars = String.valueOf(wordChars) + "\\u0152\\u008c\\u201c\\u0093\\u201d\\u0094\\u02dc\\u0098\\u2122";
        wordChars = String.valueOf(wordChars) + "\\u0099\\u0153\\u009c\\u0178\\u009f\\u00a5\\u00a7-\\u00aa\\u00ac";
        wordChars = String.valueOf(wordChars) + "\\u00ae\\u00af\\u00ba\\u00bb\\u00bf\\u00c0-\\u00c3\\u00c5\\u00c7";
        wordChars = String.valueOf(wordChars) + "\\u00c9-\\u00cf\\u00d1-\\u00d6\\u00d8-\\u00dc\\u00df-\\u00ef";
        wordChars = String.valueOf(wordChars) + "\\u00f1\\u00f2\\u00f4\\u00f7\\u00f8\\u00fc\\u00ff\\u1400-\\u167f";
        wordChars = String.valueOf(wordChars) + "]";
        int i = 0;
        while (i < unicodesICIaCodes.length) {
            j = 0;
            while (j < unicodesICIaCodes[i][1].length()) {
                policeChars.add(new Character(unicodesICIaCodes[i][1].charAt(j)));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < unicodesICIaCodesDigits.length) {
            j = 0;
            while (j < unicodesICIaCodesDigits[i][1].length()) {
                policeChars.add(new Character(unicodesICIaCodesDigits[i][1].charAt(j)));
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < unicodesAIPAITAIaCodes.length) {
            j = 0;
            while (j < unicodesAIPAITAIaCodes[i][1].length()) {
                policeChars.add(new Character(unicodesAIPAITAIaCodes[i][1].charAt(j)));
                ++j;
            }
            ++i;
        }
    }

    public static String transcodeToUnicode(String s) {
        return PoliceAipainunavik.transcodeToUnicode(s, null);
    }

    public static String transcodeToUnicode(String s, String aipaitaiMode) {
        int aipaitai = aipaitaiMode == null ? 0 : (aipaitaiMode.equals("aipaitai") ? 1 : 0);
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            int d;
            int sbl = sb.length();
            char c = s.charAt(i);
            block0 : switch (c) {
                case 'w': {
                    d = 5123;
                    break;
                }
                case 'W': {
                    d = 5169;
                    break;
                }
                case 't': {
                    d = 5198;
                    break;
                }
                case 'r': {
                    d = 5229;
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5503;
                    break;
                }
                case 'Q': {
                    d = 5259;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5519;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5745;
                        }
                    }
                    break;
                }
                case 'u': {
                    d = 5285;
                    break;
                }
                case 'i': {
                    d = 5314;
                    break;
                }
                case 'y': {
                    d = 5359;
                    break;
                }
                case 'o': {
                    d = 5333;
                    break;
                }
                case 'p': {
                    d = 5416;
                    break;
                }
                case '[': {
                    d = 5461;
                    break;
                }
                case 'E': {
                    d = 5446;
                    break;
                }
                case 'e': {
                    d = 5503;
                    break;
                }
                case 'q': {
                    d = 5519;
                    break;
                }
                case '\u0087': 
                case '\u2021': {
                    d = 5745;
                    break;
                }
                case '\u00c3': {
                    d = 5536;
                    break;
                }
                case '\u0099': 
                case '\u2122': {
                    d = 5124;
                    break;
                }
                case '\u0084': 
                case '\u201e': {
                    d = 5170;
                    break;
                }
                case '\u0086': 
                case '\u2020': {
                    d = 5199;
                    break;
                }
                case '\u00ae': {
                    d = 5230;
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5504;
                    break;
                }
                case '\u008c': 
                case '\u0152': {
                    d = 5260;
                    if (sbl <= 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5520;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5746;
                        }
                    }
                    break;
                }
                case '\u00fc': {
                    d = 5286;
                    break;
                }
                case '\u00ee': {
                    d = 5315;
                    break;
                }
                case '\u00a5': {
                    d = 5360;
                    break;
                }
                case '\u00f8': {
                    d = 5334;
                    break;
                }
                case '\u00ba': {
                    d = 5417;
                    break;
                }
                case '\u0093': 
                case '\u201c': {
                    d = 5462;
                    break;
                }
                case '\u0089': 
                case '\u2030': {
                    d = 5447;
                    break;
                }
                case '\u00e9': {
                    d = 5504;
                    break;
                }
                case '\u009c': 
                case '\u0153': {
                    d = 5520;
                    break;
                }
                case '\u00b7': 
                case '\u2219': {
                    d = 5746;
                    break;
                }
                case '\u00ed': {
                    d = 5537;
                    break;
                }
                case 's': {
                    d = 5125;
                    break;
                }
                case 'S': {
                    d = 5171;
                    break;
                }
                case 'g': {
                    d = 5200;
                    break;
                }
                case 'f': {
                    d = 5231;
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5505;
                    break;
                }
                case 'A': {
                    d = 5261;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5521;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5747;
                        }
                    }
                    break;
                }
                case 'j': {
                    d = 5287;
                    break;
                }
                case 'k': {
                    d = 5316;
                    break;
                }
                case 'h': {
                    d = 5361;
                    break;
                }
                case 'l': {
                    d = 5335;
                    break;
                }
                case 'J': {
                    d = 5418;
                    break;
                }
                case 'K': {
                    d = 5463;
                    break;
                }
                case 'D': {
                    d = 5448;
                    break;
                }
                case 'd': {
                    d = 5505;
                    break;
                }
                case 'a': {
                    d = 5521;
                    break;
                }
                case '\u0082': 
                case '\u201a': {
                    d = 5747;
                    break;
                }
                case '\u00c0': {
                    d = 5538;
                    break;
                }
                case '\u00df': {
                    d = 5126;
                    break;
                }
                case '\u00cd': {
                    d = 5172;
                    break;
                }
                case '\u00a9': {
                    d = 5201;
                    break;
                }
                case '\u0083': 
                case '\u0192': {
                    d = 5232;
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5506;
                    break;
                }
                case '\u00c5': {
                    d = 5262;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5522;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5748;
                        }
                    }
                    break;
                }
                case '\u00cb': {
                    d = 5288;
                    break;
                }
                case '\u00aa': {
                    d = 5317;
                    break;
                }
                case '\u00a7': {
                    d = 5362;
                    break;
                }
                case '\u00ac': {
                    d = 5336;
                    break;
                }
                case '\u00d4': {
                    d = 5419;
                    break;
                }
                case '\u00d3': {
                    d = 5464;
                    break;
                }
                case '\u00ce': {
                    d = 5449;
                    break;
                }
                case '\u00da': {
                    d = 5506;
                    break;
                }
                case '\u00e5': {
                    d = 5522;
                    break;
                }
                case '\u00c2': {
                    d = 5748;
                    break;
                }
                case '\u00ec': {
                    d = 5539;
                    break;
                }
                case 'x': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5121;
                        ++i;
                        break;
                    }
                    d = 5130;
                    break;
                }
                case 'X': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5167;
                        ++i;
                        break;
                    }
                    d = 5176;
                    break;
                }
                case 'b': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5196;
                        ++i;
                        break;
                    }
                    d = 5205;
                    break;
                }
                case 'v': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                            sb.deleteCharAt(sbl - 1);
                            d = 5743;
                        } else {
                            d = 5227;
                        }
                        ++i;
                        break;
                    }
                    if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5507;
                        break;
                    }
                    d = 5234;
                    break;
                }
                case 'Z': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                            sb.deleteCharAt(sbl - 1);
                            d = 5744;
                        } else {
                            d = 5257;
                        }
                        ++i;
                        break;
                    }
                    if (sbl != 0 && sb.charAt(sbl - 1) == '\u1595') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5523;
                        break;
                    }
                    if (sbl != 0 && sb.charAt(sbl - 1) == '\u1596') {
                        sb.deleteCharAt(sbl - 1);
                        d = 5749;
                        break;
                    }
                    d = 5264;
                    break;
                }
                case 'm': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5283;
                        ++i;
                        break;
                    }
                    d = 5290;
                    break;
                }
                case 'N': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5312;
                        ++i;
                        break;
                    }
                    d = 5319;
                    break;
                }
                case 'n': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5357;
                        ++i;
                        break;
                    }
                    d = 5364;
                    break;
                }
                case 'M': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5331;
                        ++i;
                        break;
                    }
                    d = 5338;
                    break;
                }
                case '/': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5414;
                        ++i;
                        break;
                    }
                    d = 5421;
                    break;
                }
                case '?': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5459;
                        ++i;
                        break;
                    }
                    d = 5465;
                    break;
                }
                case 'C': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5442;
                        ++i;
                        break;
                    }
                    d = 5451;
                    break;
                }
                case 'c': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5743;
                        ++i;
                        break;
                    }
                    d = 5507;
                    break;
                }
                case 'z': {
                    if (aipaitai == 1 && i + 1 < l && s.charAt(i + 1) == 'w') {
                        d = 5744;
                        ++i;
                        break;
                    }
                    d = 5523;
                    break;
                }
                case '\u00ca': {
                    d = 5749;
                    break;
                }
                case '\u009f': 
                case '\u0178': {
                    d = 5540;
                    break;
                }
                case '\u0080': 
                case '\u20ac': {
                    d = 5131;
                    break;
                }
                case '\u00d9': {
                    d = 5177;
                    break;
                }
                case '\u00cc': {
                    d = 5206;
                    break;
                }
                case '\u00cf': {
                    d = 5235;
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1550') {
                        sb.deleteCharAt(sbl - 1);
                        sb.deleteCharAt(sbl - 2);
                        sb.append('\u1585');
                        break;
                    }
                    if (sbl > 1 && sb.charAt(sbl - 1) == '\u1550' && sb.charAt(sbl - 2) == '\u1585') {
                        sb.deleteCharAt(sbl - 1);
                        break;
                    }
                    if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break;
                    sb.deleteCharAt(sbl - 1);
                    d = 5508;
                    break;
                }
                case '\u00db': {
                    d = 5265;
                    if (sbl == 0) break;
                    char e = sb.charAt(sbl - 1);
                    switch (e) {
                        case '\u1595': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5524;
                            break;
                        }
                        case '\u1596': {
                            sb.deleteCharAt(sbl - 1);
                            d = 5750;
                        }
                    }
                    break;
                }
                case '\u00b5': {
                    d = 5291;
                    break;
                }
                case '\u0088': 
                case '\u02c6': {
                    d = 5320;
                    break;
                }
                case '\u00f1': {
                    d = 5365;
                    break;
                }
                case '\u0098': 
                case '\u02dc': {
                    d = 5339;
                    break;
                }
                case '\u00f7': {
                    d = 5422;
                    break;
                }
                case '\u00bf': {
                    d = 5466;
                    break;
                }
                case '\u00c7': {
                    d = 5452;
                    break;
                }
                case '\u00e7': {
                    d = 5508;
                    break;
                }
                case '\u00af': {
                    d = 5524;
                    break;
                }
                case '\u00c1': {
                    d = 5750;
                    break;
                }
                case '\u00ef': {
                    d = 5541;
                    break;
                }
                case '2': {
                    d = 5193;
                    break;
                }
                case '5': {
                    d = 5222;
                    break;
                }
                case '4': {
                    d = 5251;
                    break;
                }
                case '=': {
                    d = 5281;
                    break;
                }
                case '7': {
                    d = 5307;
                    break;
                }
                case '8': {
                    d = 5328;
                    break;
                }
                case '+': {
                    d = 5381;
                    break;
                }
                case '9': {
                    d = 5354;
                    break;
                }
                case '0': {
                    d = 5438;
                    break;
                }
                case '{': {
                    d = 5469;
                    break;
                }
                case '3': {
                    d = 5456;
                    break;
                }
                case '6': {
                    d = 5509;
                    break;
                }
                case '\u00d5': {
                    d = 5542;
                    break;
                }
                case '\u00ff': {
                    d = 5500;
                    break;
                }
                case '1': {
                    d = 5525;
                    break;
                }
                case '\u00d2': {
                    d = 5526;
                    break;
                }
                case '!': {
                    d = 49;
                    break;
                }
                case '#': {
                    d = 51;
                    break;
                }
                case '$': {
                    d = 52;
                    break;
                }
                case '%': {
                    d = 53;
                    break;
                }
                case '&': {
                    d = 55;
                    break;
                }
                case '(': {
                    d = 57;
                    break;
                }
                case ')': {
                    d = 48;
                    break;
                }
                case '*': {
                    d = 56;
                    break;
                }
                case '^': {
                    d = 54;
                    break;
                }
                case '@': {
                    d = 50;
                    break;
                }
                case ',': {
                    d = 44;
                    break;
                }
                case '-': {
                    d = 45;
                    break;
                }
                case '.': {
                    d = 46;
                    break;
                }
                case ':': {
                    d = 58;
                    break;
                }
                case ';': {
                    d = 59;
                    break;
                }
                case '<': {
                    d = 39;
                    break;
                }
                case '>': {
                    d = 34;
                    break;
                }
                case 'B': {
                    d = 247;
                    break;
                }
                case 'F': {
                    d = 47;
                    break;
                }
                case 'G': {
                    d = 40;
                    break;
                }
                case 'H': {
                    d = 41;
                    break;
                }
                case 'R': {
                    d = 36;
                    break;
                }
                case 'T': {
                    d = 43;
                    break;
                }
                case 'U': {
                    d = 61;
                    break;
                }
                case 'V': {
                    d = 63;
                    break;
                }
                case 'Y': {
                    d = 215;
                    break;
                }
                case '\\': {
                    d = 92;
                    break;
                }
                case ']': {
                    d = 91;
                    break;
                }
                case '_': {
                    d = 95;
                    break;
                }
                case '|': {
                    d = 124;
                    break;
                }
                case '}': {
                    d = 93;
                    break;
                }
                case '~': {
                    d = 126;
                    break;
                }
                case '\u00a0': {
                    d = 160;
                    break;
                }
                case '\u00a1': {
                    d = 33;
                    break;
                }
                case '\u00a2': {
                    d = 162;
                    break;
                }
                case '\u00a3': {
                    d = 35;
                    break;
                }
                case '\u00ab': {
                    d = 8226;
                    break;
                }
                case '\u00b0': {
                    d = 176;
                    break;
                }
                case '\u00b1': {
                    d = 177;
                    break;
                }
                case '\u00b4': {
                    d = 38;
                    break;
                }
                case '\u00b6': {
                    d = 37;
                    break;
                }
                case '\u00b8': {
                    d = 5150;
                    break;
                }
                case '\u00c4': {
                    d = 64;
                    break;
                }
                case '\u00c6': {
                    d = 8217;
                    break;
                }
                case '\u00e6': {
                    d = 8216;
                    break;
                }
                case '\u00f3': {
                    d = 5556;
                    break;
                }
                case '\u00f5': {
                    d = 182;
                    break;
                }
                case '\u00f6': {
                    d = 167;
                    break;
                }
                case '\u00f9': {
                    d = 169;
                    break;
                }
                case '\u00fa': {
                    d = 8482;
                    break;
                }
                case '\u00fb': {
                    d = 174;
                    break;
                }
                case '\u02c7': {
                    d = 729;
                    break;
                }
                case '\u2013': {
                    d = 8211;
                    break;
                }
                case '\u2014': {
                    d = 8212;
                    break;
                }
                case '\u0091': 
                case '\u2018': {
                    d = 8220;
                    break;
                }
                case '\u0092': 
                case '\u2019': {
                    d = 8221;
                    break;
                }
                case '\u0095': 
                case '\u2022': {
                    d = 42;
                    break;
                }
                case '\u0085': 
                case '\u2026': {
                    d = 8230;
                    break;
                }
                case '\u008b': 
                case '\u2039': {
                    d = 171;
                    break;
                }
                case '\u009b': 
                case '\u203a': {
                    d = 187;
                    break;
                }
                case '\u00c9': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5121;
                            break block0;
                        }
                    }
                    sb.append('\u140a');
                    d = 5123;
                    break;
                }
                case '\u00d1': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5167;
                            break block0;
                        }
                    }
                    sb.append('\u1438');
                    d = 5123;
                    break;
                }
                case '\u00d6': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5196;
                            break block0;
                        }
                    }
                    sb.append('\u1455');
                    d = 5123;
                    break;
                }
                case '\u00dc': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5227;
                            if (sbl <= 0 || sb.charAt(sbl - 1) != '\u1550') break block0;
                            sb.deleteCharAt(sbl - 1);
                            d = 5743;
                            break;
                        }
                        default: {
                            if (sbl > 0 && sb.charAt(sbl - 1) == '\u1550') {
                                sb.deleteCharAt(sbl - 1);
                                d = 5503;
                            } else {
                                sb.append('\u1472');
                            }
                            d = 5123;
                            break;
                        }
                    }
                    break;
                }
                case '\u00e1': {
                    char e;
                    switch (aipaitai) {
                        case 1: {
                            d = 5257;
                            if (sbl == 0) break block0;
                            e = sb.charAt(sbl - 1);
                            switch (e) {
                                case '\u1595': {
                                    sb.deleteCharAt(sbl - 1);
                                    d = 5744;
                                }
                            }
                            break;
                        }
                        default: {
                            if (sbl != 0) {
                                e = sb.charAt(sbl - 1);
                                switch (e) {
                                    case '\u1595': {
                                        sb.deleteCharAt(sbl - 1);
                                        sb.append('\u1593');
                                        break;
                                    }
                                    case '\u1596': {
                                        sb.deleteCharAt(sbl - 1);
                                        sb.append('\u1675');
                                        break;
                                    }
                                    default: {
                                        sb.append('\u1490');
                                    }
                                }
                            }
                            d = 5123;
                            break;
                        }
                    }
                    break;
                }
                case '\u00e0': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5283;
                            break block0;
                        }
                    }
                    sb.append('\u14aa');
                    d = 5123;
                    break;
                }
                case '\u00e2': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5312;
                            break block0;
                        }
                    }
                    sb.append('\u14c7');
                    d = 5123;
                    break;
                }
                case '\u00e3': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5357;
                            break block0;
                        }
                    }
                    sb.append('\u14f4');
                    d = 5123;
                    break;
                }
                case '\u00e4': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5331;
                            break block0;
                        }
                    }
                    sb.append('\u14da');
                    d = 5123;
                    break;
                }
                case '\u00e8': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5414;
                            break block0;
                        }
                    }
                    sb.append('\u152d');
                    d = 5123;
                    break;
                }
                case '\u00eb': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5459;
                            break block0;
                        }
                    }
                    sb.append('\u1559');
                    d = 5123;
                    break;
                }
                case '\u00ea': {
                    switch (aipaitai) {
                        case 1: {
                            d = 5443;
                            break block0;
                        }
                    }
                    sb.append('\u154b');
                    d = 5123;
                    break;
                }
                case '\u00f2': {
                    boolean precr = false;
                    switch (aipaitai) {
                        case 1: {
                            d = 5743;
                            if (!precr) break block0;
                            sb.append('\u1585');
                            d = 5227;
                            break;
                        }
                        default: {
                            if (precr) {
                                sb.append('\u1585');
                                sb.append('\u1472');
                            } else {
                                sb.append('\u1583');
                            }
                            d = 5123;
                            break;
                        }
                    }
                    break;
                }
                case '\u00f4': {
                    boolean precn = false;
                    switch (aipaitai) {
                        case 1: {
                            d = 5744;
                            if (!precn) break block0;
                            sb.append('\u1596');
                            d = 5257;
                            break;
                        }
                        default: {
                            if (precn) {
                                sb.append('\u1675');
                            } else {
                                sb.append('\u1593');
                            }
                            d = 5123;
                            break;
                        }
                    }
                    break;
                }
                case '\"': {
                    d = 5499;
                    break;
                }
                case 'L': {
                    d = 5493;
                    break;
                }
                case '\u00d8': {
                    d = 5494;
                    break;
                }
                case 'O': {
                    d = 5495;
                    break;
                }
                case '\u201d': {
                    d = 5496;
                    break;
                }
                case 'P': {
                    d = 5497;
                    break;
                }
                case '\u00bb': {
                    d = 5498;
                    break;
                }
                case '\u00a8': {
                    d = 5492;
                    break;
                }
                default: {
                    d = c > ' ' ? 32 : (int)c;
                }
            }
            ++i;
            sb.append((char)d);
        }
        return sb.toString();
    }

    public static String transcodeFromUnicode(String s) {
        int i = 0;
        int l = s.length();
        StringBuffer sb = new StringBuffer();
        while (i < l) {
            int d;
            int c = s.charAt(i);
            block0 : switch (c) {
                case 5123: {
                    d = 119;
                    break;
                }
                case 5169: {
                    d = 87;
                    break;
                }
                case 5198: {
                    d = 116;
                    break;
                }
                case 5229: {
                    d = 114;
                    break;
                }
                case 5259: {
                    d = 81;
                    break;
                }
                case 5285: {
                    d = 117;
                    break;
                }
                case 5314: {
                    d = 105;
                    break;
                }
                case 5359: {
                    d = 121;
                    break;
                }
                case 5333: {
                    d = 111;
                    break;
                }
                case 5416: {
                    d = 112;
                    break;
                }
                case 5461: {
                    d = 91;
                    break;
                }
                case 5446: {
                    d = 69;
                    break;
                }
                case 5503: {
                    d = 101;
                    break;
                }
                case 5519: {
                    d = 113;
                    break;
                }
                case 5745: {
                    d = 8225;
                    break;
                }
                case 5536: {
                    d = 195;
                    break;
                }
                case 5124: {
                    d = 8482;
                    break;
                }
                case 5170: {
                    d = 8222;
                    break;
                }
                case 5199: {
                    d = 8224;
                    break;
                }
                case 5230: {
                    d = 174;
                    break;
                }
                case 5260: {
                    d = 338;
                    break;
                }
                case 5286: {
                    d = 252;
                    break;
                }
                case 5315: {
                    d = 238;
                    break;
                }
                case 5360: {
                    d = 165;
                    break;
                }
                case 5334: {
                    d = 248;
                    break;
                }
                case 5417: {
                    d = 186;
                    break;
                }
                case 5462: {
                    d = 8220;
                    break;
                }
                case 5447: {
                    d = 8240;
                    break;
                }
                case 5504: {
                    d = 233;
                    break;
                }
                case 5520: {
                    d = 339;
                    break;
                }
                case 5746: {
                    d = 183;
                    break;
                }
                case 5537: {
                    d = 237;
                    break;
                }
                case 5125: {
                    d = 115;
                    break;
                }
                case 5171: {
                    d = 83;
                    break;
                }
                case 5200: {
                    d = 103;
                    break;
                }
                case 5231: {
                    d = 102;
                    break;
                }
                case 5261: {
                    d = 65;
                    break;
                }
                case 5287: {
                    d = 106;
                    break;
                }
                case 5316: {
                    d = 107;
                    break;
                }
                case 5361: {
                    d = 104;
                    break;
                }
                case 5335: {
                    d = 108;
                    break;
                }
                case 5418: {
                    d = 74;
                    break;
                }
                case 5463: {
                    d = 75;
                    break;
                }
                case 5448: {
                    d = 68;
                    break;
                }
                case 5505: {
                    d = 100;
                    break;
                }
                case 5521: {
                    d = 97;
                    break;
                }
                case 5747: {
                    d = 8218;
                    break;
                }
                case 5538: {
                    d = 192;
                    break;
                }
                case 5126: {
                    d = 223;
                    break;
                }
                case 5172: {
                    d = 205;
                    break;
                }
                case 5201: {
                    d = 169;
                    break;
                }
                case 5232: {
                    d = 402;
                    break;
                }
                case 5262: {
                    d = 197;
                    break;
                }
                case 5288: {
                    d = 203;
                    break;
                }
                case 5317: {
                    d = 170;
                    break;
                }
                case 5362: {
                    d = 167;
                    break;
                }
                case 5336: {
                    d = 172;
                    break;
                }
                case 5419: {
                    d = 212;
                    break;
                }
                case 5464: {
                    d = 211;
                    break;
                }
                case 5449: {
                    d = 206;
                    break;
                }
                case 5506: {
                    d = 218;
                    break;
                }
                case 5522: {
                    d = 229;
                    break;
                }
                case 5748: {
                    d = 194;
                    break;
                }
                case 5539: {
                    d = 236;
                    break;
                }
                case 5130: {
                    char e;
                    d = c = 120;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 201;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5176: {
                    char e;
                    d = c = 88;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 209;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5205: {
                    char e;
                    d = c = 98;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 214;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5234: {
                    char e;
                    d = c = 118;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 220;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5264: {
                    char e;
                    d = c = 90;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 225;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5290: {
                    char e;
                    d = c = 109;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 224;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5319: {
                    char e;
                    d = c = 78;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 226;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5364: {
                    char e;
                    d = c = 110;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 227;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5338: {
                    char e;
                    d = c = 77;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 228;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5421: {
                    char e;
                    d = c = 47;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 232;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5465: {
                    char e;
                    d = c = 63;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 235;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5451: {
                    char e;
                    d = c = 67;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 234;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5507: {
                    char e;
                    d = c = 99;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 242;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5523: {
                    char e;
                    d = c = 122;
                    if (++i < l) {
                        e = s.charAt(i);
                        switch (e) {
                            case '\u1403': {
                                d = 244;
                                break block0;
                            }
                        }
                        --i;
                        break;
                    }
                    --i;
                    break;
                }
                case 5749: {
                    d = 202;
                    break;
                }
                case 5540: {
                    d = 376;
                    break;
                }
                case 5131: {
                    d = 8364;
                    break;
                }
                case 5177: {
                    d = 217;
                    break;
                }
                case 5206: {
                    d = 204;
                    break;
                }
                case 5235: {
                    d = 207;
                    break;
                }
                case 5265: {
                    d = 219;
                    break;
                }
                case 5291: {
                    d = 181;
                    break;
                }
                case 5320: {
                    d = 710;
                    break;
                }
                case 5365: {
                    d = 241;
                    break;
                }
                case 5339: {
                    d = 732;
                    break;
                }
                case 5422: {
                    d = 247;
                    break;
                }
                case 5466: {
                    d = 191;
                    break;
                }
                case 5452: {
                    d = 199;
                    break;
                }
                case 5508: {
                    d = 231;
                    break;
                }
                case 5524: {
                    d = 175;
                    break;
                }
                case 5750: {
                    d = 193;
                    break;
                }
                case 5541: {
                    d = 239;
                    break;
                }
                case 5193: {
                    d = 50;
                    break;
                }
                case 5222: {
                    d = 53;
                    break;
                }
                case 5251: {
                    d = 52;
                    break;
                }
                case 5281: {
                    d = 61;
                    break;
                }
                case 5307: {
                    d = 55;
                    break;
                }
                case 5328: {
                    d = 56;
                    break;
                }
                case 5381: {
                    d = 43;
                    break;
                }
                case 5354: {
                    d = 57;
                    break;
                }
                case 5438: {
                    d = 48;
                    break;
                }
                case 5469: {
                    d = 123;
                    break;
                }
                case 5456: {
                    d = 51;
                    break;
                }
                case 5509: {
                    d = 54;
                    break;
                }
                case 5525: {
                    d = 49;
                    break;
                }
                case 5526: {
                    d = 210;
                    break;
                }
                case 5542: {
                    d = 213;
                    break;
                }
                case 5500: {
                    d = 255;
                    break;
                }
                case 5499: {
                    d = 34;
                    break;
                }
                case 5493: {
                    d = 76;
                    break;
                }
                case 5494: {
                    d = 216;
                    break;
                }
                case 5495: {
                    d = 79;
                    break;
                }
                case 5496: {
                    d = 8221;
                    break;
                }
                case 5497: {
                    d = 80;
                    break;
                }
                case 5498: {
                    d = 187;
                    break;
                }
                case 5492: {
                    d = 168;
                    break;
                }
                case 49: {
                    d = 33;
                    break;
                }
                case 51: {
                    d = 35;
                    break;
                }
                case 52: {
                    d = 36;
                    break;
                }
                case 53: {
                    d = 37;
                    break;
                }
                case 55: {
                    d = 38;
                    break;
                }
                case 57: {
                    d = 40;
                    break;
                }
                case 48: {
                    d = 41;
                    break;
                }
                case 56: {
                    d = 42;
                    break;
                }
                case 54: {
                    d = 94;
                    break;
                }
                case 50: {
                    d = 64;
                    break;
                }
                case 39: {
                    d = 60;
                    break;
                }
                case 34: {
                    d = 62;
                    break;
                }
                case 247: {
                    d = 66;
                    break;
                }
                case 47: {
                    d = 70;
                    break;
                }
                case 40: {
                    d = 71;
                    break;
                }
                case 41: {
                    d = 72;
                    break;
                }
                case 36: {
                    d = 82;
                    break;
                }
                case 43: {
                    d = 84;
                    break;
                }
                case 61: {
                    d = 85;
                    break;
                }
                case 63: {
                    d = 86;
                    break;
                }
                case 215: {
                    d = 89;
                    break;
                }
                case 91: {
                    d = 93;
                    break;
                }
                case 93: {
                    d = 125;
                    break;
                }
                case 8230: {
                    d = 133;
                    break;
                }
                case 171: {
                    d = 8249;
                    break;
                }
                case 8220: {
                    d = 8216;
                    break;
                }
                case 8221: {
                    d = 8217;
                    break;
                }
                case 42: {
                    d = 8226;
                    break;
                }
                case 187: {
                    d = 8250;
                    break;
                }
                case 33: {
                    d = 161;
                    break;
                }
                case 35: {
                    d = 163;
                    break;
                }
                case 8226: {
                    d = 171;
                    break;
                }
                case 38: {
                    d = 180;
                    break;
                }
                case 37: {
                    d = 182;
                    break;
                }
                case 5150: {
                    d = 184;
                    break;
                }
                case 64: {
                    d = 196;
                    break;
                }
                case 8217: {
                    d = 198;
                    break;
                }
                case 8216: {
                    d = 230;
                    break;
                }
                case 70: {
                    d = 243;
                    break;
                }
                case 182: {
                    d = 245;
                    break;
                }
                case 167: {
                    d = 246;
                    break;
                }
                case 169: {
                    d = 249;
                    break;
                }
                case 8482: {
                    d = 250;
                    break;
                }
                case 174: {
                    d = 251;
                    break;
                }
                case 5121: {
                    d = 201;
                    break;
                }
                case 5167: {
                    d = 209;
                    break;
                }
                case 5196: {
                    d = 214;
                    break;
                }
                case 5227: {
                    d = 220;
                    break;
                }
                case 5257: {
                    d = 225;
                    break;
                }
                case 5283: {
                    d = 224;
                    break;
                }
                case 5312: {
                    d = 226;
                    break;
                }
                case 5357: {
                    d = 227;
                    break;
                }
                case 5331: {
                    d = 228;
                    break;
                }
                case 5414: {
                    d = 232;
                    break;
                }
                case 5459: {
                    d = 235;
                    break;
                }
                case 5443: {
                    d = 234;
                    break;
                }
                case 5442: {
                    d = 234;
                    break;
                }
                case 5743: {
                    d = 242;
                    break;
                }
                case 5744: {
                    d = 244;
                    break;
                }
                default: {
                    d = c;
                }
            }
            ++i;
            sb.append((char)d);
        }
        return sb.toString();
    }
}

