/*
 * Decompiled with CFR 0.152.
 */
package polices;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import junit.framework.TestCase;
import polices.Police;
import polices.ngrammes.Ngramme;
import utilites1.Util;

public class PoliceTest
extends TestCase {
    public void testTranscoder3toUnicodeICI() {
        String res = null;
        Method meth = Police.getTranscoder3("nunacom", "ToUnicode");
        String[][] words = new String[][]{{"|wte", "iitiqi", "\u1404\u144e\u157f"}, {"xwg", "aitu", "\u140a\u1403\u1450"}, {"n6rt9lA", "saqqitillugu", "\u14f4\u1585\u146d\u144e\u14ea\u14d7\u148d"}, {"xR+A|t5", "annguutiit", "\u140a\u1674\u144f\u1466"}, {"w3+f3t5", "iquurtit", "\u1403\u1582\u1550\u144e\u1466"}};
        int i = 0;
        while (i < words.length) {
            String str = words[i][0];
            String targ = words[i][2];
            try {
                Object[] objectArray = new Object[2];
                objectArray[0] = str;
                res = (String)meth.invoke(null, objectArray);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            PoliceTest.assertEquals((String)"", (String)targ, res);
            ++i;
        }
        meth = Police.getTranscoder3("ainunavik", "ToUnicode");
        String[][] words2 = new String[][]{{"WNhxMs3ym1qg6", "\u1431\u14c7\u14f1\u140a\u14da\u1405\u1550\u14ef\u14aa\u1671\u1450\u1585"}};
        int i2 = 0;
        while (i2 < words2.length) {
            String str = words2[i2][0];
            String targ = words2[i2][1];
            try {
                Object[] objectArray = new Object[2];
                objectArray[0] = str;
                res = (String)meth.invoke(null, objectArray);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            PoliceTest.assertEquals((String)"", (String)targ, (String)res);
            ++i2;
        }
    }

    public void testTranscoder3toUnicodeAIPAITAI() {
        String res = null;
        Method meth = Police.getTranscoder3("nunacom", "ToUnicode");
        String[][] words = new String[][]{{"|wte", "iitiqi", "\u1404\u144e\u157f"}, {"xwg", "aitu", "\u1401\u1450"}, {"n6rt9lA", "saqqitillugu", "\u14f4\u1585\u146d\u144e\u14ea\u14d7\u148d"}, {"xR+A|t5", "annguutiit", "\u140a\u1674\u144f\u1466"}, {"w3+f3t5", "iquurtit", "\u1403\u1582\u1550\u144e\u1466"}};
        int i = 0;
        while (i < words.length) {
            String str = words[i][0];
            String targ = words[i][2];
            try {
                res = (String)meth.invoke(null, str, "aipaitai");
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            PoliceTest.assertEquals((String)"", (String)targ, res);
            ++i;
        }
    }

    public void ttestDetermineFontByNgrams() throws IOException {
        String expectedFont;
        String font;
        float val;
        Ngramme.FontNgramme fng;
        int i;
        PrintWriter out;
        String text = "\u22484v, wkoEpgc4f5 uiybz5 C8 sF8 bm8N iDx6yisc5b6g6 eu3D/sd9lA g[oxi iDxo6Xb moZos6t4nu1i4 kNK5 moZos6tq8i4, x7ml bm8N wvJ6y6bs9li kNK5 Z?m4noEp4fq8i5, kNK5 g8zF4f5 tuz8k5 x7ml Xs4\ufffdt4f8k5. kNKu moZos6tsj5 xy0p3yJ8N3ix6g5 iDx6bsiE?4bq8i4 moZos6tsJ5 bm8N eu3D/sMs6t9lA, bm8Nl W9lA slExN6gc8qM6 \u22486r4bsNh4g6 bm8N s4gCD8N6XK5.";
        Ngramme fontsNgrams = Police.determineFontsByNgrams(text);
        try {
            out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "utf-8"), true);
            i = 0;
            while (i < fontsNgrams.fontNgrammes.size()) {
                fng = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i);
                val = (float)fng.ngrammesTrouves / (float)fng.ngrammes * 100.0f;
                out.println(String.valueOf(fng.font) + "..." + fng.ngrammesTrouves + " sur " + fng.ngrammes + " (" + val + ") " + " moy: " + fng.freqAverage);
                out.println(Util.array2string(fng.pasTrouves));
                ++i;
            }
            font = "";
            expectedFont = "naamajut";
            out.println("2a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
            out.println();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, "utf-8"), true);
            File f = new File("c:\\inuktitut\\polices\\ngrammes", "i_commission.txt");
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "utf-8"));
            text = br.readLine();
            fontsNgrams = Police.determineFontsByNgrams(text);
            i = 0;
            while (i < fontsNgrams.fontNgrammes.size()) {
                fng = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i);
                val = (float)fng.ngrammesTrouves / (float)fng.ngrammes * 100.0f;
                out.println(String.valueOf(fng.font) + "..." + fng.ngrammesTrouves + " sur " + fng.ngrammes + " (" + val + ") " + " moy: " + fng.freqAverage);
                out.println(Util.array2string(fng.pasTrouves));
                ++i;
            }
            font = "";
            expectedFont = "ainunavik";
            out.println("3a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
            out.println();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        text = "v7SM8f5 X3Nwix6g5 nN/4n6`bD8Nd2lQ5 W?9oxt5ti3j5 X3Nstu4, W?9ox4v8iD8Nd2lQ5 wkw5 nNJ8N6yiq5 x7ml `W/3lt4 gl6b3=s?4g5 nN/4n6`bCh1i3j5. r?9o6 wkw5 vg0pct`Q4f5 wvJ3ix6g5 W?9oxt5ti3j5 X3Nstu4 WoEctc3lt4 xyq8i4 tusJi4 NlNw/wi3j5 xJq8iE/sJi4 WJ8N3iE/sJi[l r?9o3u wkw5 nNJ8N3iq8k5 x7ml c2ysiq8k5 r?9o3u wkw5 nNJ8NC/6g5 w8k4yJ8NC/6g5 nN}=1i4. bm8N X3Nst s2luj5 `x6rQx6bsc5b3l x3CAb`m5.";
        fontsNgrams = Police.determineFontsByNgrams(text);
        int i2 = 0;
        while (i2 < fontsNgrams.fontNgrammes.size()) {
            Ngramme.FontNgramme fng2 = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i2);
            float val2 = (float)fng2.ngrammesTrouves / (float)fng2.ngrammes * 100.0f;
            System.out.println(String.valueOf(fng2.font) + "..." + fng2.ngrammesTrouves + " sur " + fng2.ngrammes + " (" + val2 + ") " + " moy: " + fng2.freqAverage);
            ++i2;
        }
        font = "";
        expectedFont = "prosyl";
        System.out.println("4a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
        System.out.println();
        text = "kNos2 W?9oxizb X3Nbsiz vq3hJxu wkq5 cspmJ\ufffd7mb WAm/q8i4 kNoub x3\ufffd\ufffdMzJi b9omsMzJi. X3Nwi3ui, wko?5 wh?\ufffdtQ/ui4 scsycc5bMs3mb, g\ufffdDm/ui4, X3NwDm/ui4, WsyEAm/ui9l wko?3tbsic3ht4 vq3hJxus5 x5pOE1qgk5 vtmps[o8k5. vtmpxWs[\ufffd5 eu3DD8Nc5bMs3d5 wko?5 whmQ/q8i4, wMQx3hQ9\ufffd\ufffd5 k?i4 whm?Eym/ui4, bwm x3\ufffdAk5 b9omkxzJu4 X3NwD8NyixoCu4 yK9oXs5/sQxosJi4. kNoub xzJ3cz8k5 bf/st5hQ5 kNu9l tAux3tsJ4f5 xzJ3\ufffdz8k5, bwm eu3Dixo3m\ufffd4 bm4fiz.";
        fontsNgrams = Police.determineFontsByNgrams(text);
        i2 = 0;
        while (i2 < fontsNgrams.fontNgrammes.size()) {
            Ngramme.FontNgramme fng3 = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i2);
            float val3 = (float)fng3.ngrammesTrouves / (float)fng3.ngrammes * 100.0f;
            System.out.println(String.valueOf(fng3.font) + "..." + fng3.ngrammesTrouves + " sur " + fng3.ngrammes + " (" + val3 + ") " + " moy: " + fng3.freqAverage);
            ++i2;
        }
        font = "";
        expectedFont = "ainunavik";
        System.out.println("5a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
        System.out.println();
        text = "yK9ou, v?m5noE?5 wmwQxDt5nsJE5yK5 x5pOE1qgi4 kN[7u tu7mEsJi4 vtt3bsQxc3gE5yht4 Wsyc3lt4 yKjx5tyQx3insZI3gu4 XX5yicDbsQxc3izi4 wkw5 wo3dyzb. w?4 scDbsZhx3S6 x?b6 WsygcoE[4 tu7mE4 wMQIsQxc3m5 Wcbs7ut9lQ5 xyq5 Nso??ozJw5 tu7m\ufffd5, wMQos5pIsli vtt3bsQx5yxymJj5 v?mj5. x?b4f5 scsy5ncDt[iq5 v?m5noEpk5 si4vsyc3S5 bw5hm tus2 Gx?bs2H kwbsi[izi4 !(*)-u >Iwu+ Xw2 xqctOE8izb raixWxi, iWr5gxW7u4 i5\ufffd\ufffdW5ht4 wkw5 wkgcq5b csp\ufffdEZhxDtQxW5bzis4 W7mExlCb3i4 r1aic3gcExzi4 W5Jtst9lQ5 wo3dys2 scsyc3isl \ufffdq8\ufffdbsi[iQ4.> scsyEI[\ufffd5 bf5nst5yQK5 x3\ufffdAi WQx3Xoxi3ui x?bs2 WA8N[7uA5 WZhx3i[izi4 WsoxEIst5yZhx3hi xyst5ybwoZhx3hi WJut5yZhx3hil wkw5 scsyq8i4 wo3dyq8il, WAt5nc5yxq5gmEsZlx3hi. NlN1qyx3S6 WixC5nui4 vJyt5yi3ui kN[7u v?msZI3g6 r1\ufffdm5y\ufffd3m5 x?bs2";
        fontsNgrams = Police.determineFontsByNgrams(text);
        i2 = 0;
        while (i2 < fontsNgrams.fontNgrammes.size()) {
            Ngramme.FontNgramme fng4 = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i2);
            float val4 = (float)fng4.ngrammesTrouves / (float)fng4.ngrammes * 100.0f;
            System.out.println(String.valueOf(fng4.font) + "..." + fng4.ngrammesTrouves + " sur " + fng4.ngrammes + " (" + val4 + ") " + " moy: " + fng4.freqAverage);
            ++i2;
        }
        font = "";
        expectedFont = "ainunavik";
        System.out.println("6a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
        System.out.println();
        text = "wl8Nt4 Nf3uAm/K5 s?5ti4 wvJcbMs3g5 x7ml cspm/ui cspt5ycbht4 wvJDmi3ui4 xg3ht4, b4fx WMsqXb bm8N cspn3isJ6 vJyA8NMsqm5, Wlx3gu4 : w{ uh x7ml \ufffd7+ xo+n8g WymJ4 wMQn4fi ; m3yx9 mS5; bmp7mEz x7ml WNhtq5 \ufffd5Jx2 is[3ix[zi, Sx5n8 Kx3i WymJ6 kNo8i w9loEp7mEq8i \ufffd5Jxu; mwf fxb, yKo3t4 x7ml \ufffdu \ufffdbu \ufffd5Jx2 v??Wzi; /8 C?8hx ts8 WymJ6 vNbu w9lw5 xro3gbsiq8i x7ml w9loEis2 fxSEnzi; /8Wx3 MSx5t N7ui6 w9lc3iu WNhx3bsq8i4 vmJ xbs5yf3typ4 Wym5hi vt[4 kNoo? v?mzi; x7ml wl8Nq8i4 wMQaJi wMscbMs3gi is[3t5 WsyEhq8i4 gryix3[scbMs3gi x7ml \ufffdn c9l6, wk5tgo3tycbMs3m5.";
        fontsNgrams = Police.determineFontsByNgrams(text);
        i2 = 0;
        while (i2 < fontsNgrams.fontNgrammes.size()) {
            Ngramme.FontNgramme fng5 = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i2);
            float val5 = (float)fng5.ngrammesTrouves / (float)fng5.ngrammes * 100.0f;
            System.out.println(String.valueOf(fng5.font) + "..." + fng5.ngrammesTrouves + " sur " + fng5.ngrammes + " (" + val5 + ") " + " moy: " + fng5.freqAverage);
            ++i2;
        }
        font = "";
        expectedFont = "aipainunavik";
        System.out.println("7a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
        System.out.println();
        text = "cspn3=1u smJ5 hD3N3gcExq5 cspn3bscb3ymJ5 srs3b3g7u smJ5 cspn3bsMs3ymNt4. smJ5 cspn3=1u cspn3bsJ5 hD3N3g3gcExq5 Gbmfx smJ5 cspn3bsJ5 hD3N3gc3g8i4 Wtbs?4Lt4H srs3b3g7u smJ5 hD3N3gc3iq5b sz=bk5 hD3N3go3bs?4Lt4 cspn3=1u. srs3b3g7u smJ5 hD3N3gc3iq5 h9o csp/symMEqm5b xbsysqg7u4 hD3N3g7u4 Wbc3tlA h3l wrbwoJt5 wloq5 ckwoJbsN/Exq5 csp/symMEqm5b.";
        fontsNgrams = Police.determineFontsByNgrams(text);
        i2 = 0;
        while (i2 < fontsNgrams.fontNgrammes.size()) {
            Ngramme.FontNgramme fng6 = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i2);
            float val6 = (float)fng6.ngrammesTrouves / (float)fng6.ngrammes * 100.0f;
            System.out.println(String.valueOf(fng6.font) + "..." + fng6.ngrammesTrouves + " sur " + fng6.ngrammes + " (" + val6 + ") " + " moy: " + fng6.freqAverage);
            ++i2;
        }
        font = "";
        expectedFont = "nunacom";
        System.out.println("8a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
        System.out.println();
        text = "N5y6 X3Nw6g6 isFx5- ncc5b\ufffdExu4 y5N g0/s7u4 rNgw8N3j5 kNox?j5, Wlx6gu4 w?h5gk5 xy?6tk5. yKi5nc- Dm7uJ6bs6 X6nw?5 isFc5b- C/d9lQ5, wv\ufffdtQix3mA NlNw4fbc3FQlA xgEx3i4 st6- bCc5b?D8\ufffd3lt4 NJ\ufffd6ym- /q8k5, x7ml g0/wA8N6ylt4. \ufffdwkw5 X6nwJ\ufffd5g5 wv- J6bsQxcw8N?a7u7mb5bs6,\ufffd bw8N scMs6g6. gxJlw5 u5~\ufffd5g5 g0/w\ufffd5 isFxaymo6g5, wMQ/s9lt4 b9om5 isFxaMs6g5 kNK5 gxF3N6goEi3j5 xsM5ypk5 x7ml ybm5 wfW=FoEp4f8k5. N5y6 scMs3uJ6 X6nw?5 xgc5b3iC6gQ5 ?i\ufffdXu x7ml SEt{ vM7Wxu vJyic5yx6ymiCwym9lt4. \ufffdg0pw7u4 dFxQ- /\ufffd5.\ufffd";
        fontsNgrams = Police.determineFontsByNgrams(text);
        i2 = 0;
        while (i2 < fontsNgrams.fontNgrammes.size()) {
            Ngramme.FontNgramme fng7 = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i2);
            float val7 = (float)fng7.ngrammesTrouves / (float)fng7.ngrammes * 100.0f;
            System.out.println(String.valueOf(fng7.font) + "..." + fng7.ngrammesTrouves + " sur " + fng7.ngrammes + " (" + val7 + ") " + " moy: " + fng7.freqAverage);
            ++i2;
        }
        font = "";
        expectedFont = "naamajut";
        System.out.println("9a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
        System.out.println();
        text = "kwtbsJ[is5hi k[7X !(((-u, raizA5 Wix3ioEi3j5 xqctOE8is2 xtos3bsJ[is2 kN[s2 r=Zg3tq8k5, fXw7j5 x7ml vNbj5, kN[s2 v?m5noEpz giI[isK6 toIsmstu4 kw5ydIs5ht4 wmwAbsA8NgEIui4 v?mcDysA8Ngu4 kN[7u. v?m5noE?5 gr?MsJK5 yK9oXs5pMz5ht4 wko?3tyi3i4 vtmi3i4 x7ml vtm5yi3i4 Nso??ozJoEJi4 Gxi3tEJo??ozJoEJi4H kNdtsJo??ozJoEJi9l w\ufffd8Nq8i kN[s2 kNodtq8i. v?m5noE?5 whmysEMsJQK5 kNc3\ufffdymJw5 kNoq8i4 x7ml kNc3\ufffdym\u05083tgi4 yM3ctQIsJi4 Gni9oEIsJi4H kN[7j5. ra9oXuo, vtm5yv5bg7mEsc5bMsJK5 whmysEi3j5 cspn3icc5bht4 xuhw7mExl8i4 v?mw5 Wp5yC3tq8i4 ?4fN1z5 fXw7u5, vNbu5, kN?7u5 x7ml xfr5gu5. NlNwIwAtq5b W9MEsiq5 v?m5noE?5 wmwQxDt5nsJEIq8i sfxAK5:";
        fontsNgrams = Police.determineFontsByNgrams(text);
        i2 = 0;
        while (i2 < fontsNgrams.fontNgrammes.size()) {
            Ngramme.FontNgramme fng8 = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i2);
            float val8 = (float)fng8.ngrammesTrouves / (float)fng8.ngrammes * 100.0f;
            System.out.println(String.valueOf(fng8.font) + "..." + fng8.ngrammesTrouves + " sur " + fng8.ngrammes + " (" + val8 + ") " + " moy: " + fng8.freqAverage);
            ++i2;
        }
        font = "";
        expectedFont = "ainunavik";
        System.out.println("10a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
        System.out.println();
        text = "b2fx4 w~k4 ttC3}g4 w~ky3ui4 ttC3bq5 WsJx~l4. ttC5tx3ymJx~l2lt4l. sco]m3bs/Exc3g5 wk1k5 bmw8k5, wo5t+?9o3Fsix3mb, ck6 w~k5tx3is2 u4]nk5. wkw9l i3Jt9l xF8i6 xJ3g5, +h3l |b2fx4 jxt +xl~l6 x7ml +X9 wnrx6 ttC3mt4, w~kis2 u4]nk5. kNK5 m8N kN5tx?7mExl4, wkw5 s?A5 `N7mQ/2t8i4, iei4l, WD3gi4l kNu Wbcs3m5. b[? bm4fNU5 w8N3i5 scs0J3bs?4SA5 s0p3g5txd/s2lb. x7ml, s0p3g5tx3iK5 s?2t8k5 wv+Jtc3ix6Li w~kct2t8k9l. b[? bwm8N w8Nw5 s?~l8`i5 w8Nm`E5, bwm8N `NM5txd/sc5b3S5 sc9Mo|Czb. scsyq5 m4f4gi5 wobs?9oxix3mb. x7ml w8N3i4 wvJc5bd/s2lb scs0/s?4SA5 xzJ6]v2t8k5, wvJc5bDF5 wexhc5bT4fF5 w~ky5txE`MCF5 x7ml w~k4+h/D]mCF5. b[? bm4fx w~kct}Q5tx3i3j5 g|C3g5.";
        fontsNgrams = Police.determineFontsByNgrams(text);
        i2 = 0;
        while (i2 < fontsNgrams.fontNgrammes.size()) {
            Ngramme.FontNgramme fng9 = (Ngramme.FontNgramme)fontsNgrams.fontNgrammes.get(i2);
            float val9 = (float)fng9.ngrammesTrouves / (float)fng9.ngrammes * 100.0f;
            System.out.println(String.valueOf(fng9.font) + "..." + fng9.ngrammesTrouves + " sur " + fng9.ngrammes + " (" + val9 + ") " + " moy: " + fng9.freqAverage);
            ++i2;
        }
        font = "";
        expectedFont = "nunacom";
        System.out.println("11a.R\ufffdsultat attendu: " + expectedFont + "; r\ufffdsultat obtenu: " + font);
        System.out.println();
    }
}

