/*
 * Decompiled with CFR 0.152.
 */
package polices;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextCat {
    private static TextCat ref;
    static String nonWordCharactersPattern;
    static String wordCharactersPattern;
    static int opt_a;
    static int opt_f;
    static int opt_t;
    static String opt_d;

    static {
        nonWordCharactersPattern = "[\\s]+";
        wordCharactersPattern = "[^\\s]+";
        opt_a = 10;
        opt_f = 0;
        opt_t = 400;
        opt_d = "LM";
    }

    private TextCat() {
    }

    public static TextCat getSingletonObject() {
        if (ref == null) {
            ref = new TextCat();
        }
        return ref;
    }

    public static String classify(String input) {
        String[] languages = TextCat.getLanguages();
        String[] unknown = TextCat.create_lm(input);
        Hashtable<String, Integer> results = new Hashtable<String, Integer>();
        int maxp = opt_t;
        TextCat textcat = TextCat.getSingletonObject();
        String packageName = textcat.getClass().getPackage().getName();
        File dir = new File(packageName, opt_d);
        int i = 0;
        while (i < languages.length) {
            String language = languages[i];
            Hashtable<String, Integer> ngram = new Hashtable<String, Integer>();
            int rang = 1;
            try {
                File file = new File(dir, String.valueOf(language) + ".lm");
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "iso-8859-1");
                BufferedReader br = new BufferedReader(isr);
                Pattern pat = Pattern.compile("^(" + wordCharactersPattern + ")\\s+[0-9]+");
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        Matcher mpat = pat.matcher(line);
                        if (!mpat.find()) continue;
                        ngram.put(mpat.group(1), new Integer(rang++));
                    }
                    br.close();
                    int p = 0;
                    int j = 0;
                    while (j < unknown.length) {
                        Integer val = (Integer)ngram.get(unknown[j]);
                        p = val != null ? (p += Math.abs(val - j)) : (p += maxp);
                        ++j;
                    }
                    results.put(language, new Integer(p));
                }
                catch (IOException iOException) {}
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            ++i;
        }
        String[] sorted = results.keySet().toArray(new String[0]);
        Arrays.sort(sorted, new TextCat_Comparator(results, true));
        return sorted[0];
    }

    public static String[] create_lm(String input) {
        Hashtable<String, Integer> ngram = new Hashtable<String, Integer>();
        String[] words = TextCat.getWords(input);
        int i = 0;
        while (i < words.length) {
            int len;
            String word = "_" + words[i] + "_";
            int flen = len = word.length();
            int j = 0;
            while (j < flen) {
                int nv;
                Integer n;
                String key;
                if (len > 4) {
                    key = word.substring(j, j + 5);
                    n = (Integer)ngram.get(key);
                    if (n == null) {
                        n = new Integer(0);
                    }
                    nv = n;
                    n = new Integer(++nv);
                    ngram.put(key, n);
                }
                if (len > 3) {
                    key = word.substring(j, j + 4);
                    n = (Integer)ngram.get(key);
                    if (n == null) {
                        n = new Integer(0);
                    }
                    nv = n;
                    n = new Integer(++nv);
                    ngram.put(key, n);
                }
                if (len > 2) {
                    key = word.substring(j, j + 3);
                    n = (Integer)ngram.get(key);
                    if (n == null) {
                        n = new Integer(0);
                    }
                    nv = n;
                    n = new Integer(++nv);
                    ngram.put(key, n);
                }
                if (len > 1) {
                    key = word.substring(j, j + 2);
                    n = (Integer)ngram.get(key);
                    if (n == null) {
                        n = new Integer(0);
                    }
                    nv = n;
                    n = new Integer(++nv);
                    ngram.put(key, n);
                }
                if ((n = (Integer)ngram.get(key = word.substring(j, j + 1))) == null) {
                    n = new Integer(0);
                }
                nv = n;
                n = new Integer(++nv);
                ngram.put(key, n);
                --len;
                ++j;
            }
            ++i;
        }
        Enumeration e = ngram.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            if ((Integer)ngram.get(key) > opt_f) continue;
            ngram.remove(key);
        }
        String[] sorted = ngram.keySet().toArray(new String[0]);
        Arrays.sort(sorted, new TextCat_Comparator(ngram, false));
        String[] sorted_t = TextCat.sub_array(sorted, 0, opt_t);
        return sorted_t;
    }

    public static String[] getLanguages() {
        TextCat textcat = TextCat.getSingletonObject();
        String packageName = textcat.getClass().getPackage().getName();
        File dir = new File(packageName, opt_d);
        String[] lmFilenames = dir.list(new TextCat_FilenameFilter(dir));
        int i = 0;
        while (i < lmFilenames.length) {
            lmFilenames[i] = lmFilenames[i].replace(".lm", "");
            ++i;
        }
        return lmFilenames;
    }

    public static void main(String[] args) {
        if (args[0].equals("-l")) {
            String[] languages = TextCat.getLanguages();
            int i = 0;
            while (i < languages.length) {
                System.out.println(languages[i]);
                ++i;
            }
        } else if (args[0].equals("-c")) {
            String input = args[1];
            String font = TextCat.classify(input);
            System.out.println(font);
        }
    }

    public static String[] getWords(String text) {
        String[] words = text.split(nonWordCharactersPattern);
        return words;
    }

    public static String[] sub_array(String[] array, int start, int length) {
        if (array.length <= length) {
            return array;
        }
        String[] newArray = new String[length];
        int i = 0;
        while (i < length) {
            newArray[i] = array[i];
            ++i;
        }
        return newArray;
    }

    public static class TextCat_Comparator
    implements Comparator {
        Hashtable hash;
        boolean increasingOrder;

        public TextCat_Comparator(Hashtable hash, boolean increasingOrder) {
            this.hash = hash;
            this.increasingOrder = increasingOrder;
        }

        public int compare(Object arg0, Object arg1) {
            if ((Integer)this.hash.get(arg0) > (Integer)this.hash.get(arg1)) {
                if (this.increasingOrder) {
                    return 1;
                }
                return -1;
            }
            if ((Integer)this.hash.get(arg0) < (Integer)this.hash.get(arg1)) {
                if (this.increasingOrder) {
                    return -1;
                }
                return 1;
            }
            return 0;
        }
    }

    static class TextCat_FilenameFilter
    implements FilenameFilter {
        File dir;

        public TextCat_FilenameFilter(File dir) {
            this.dir = dir;
        }

        public boolean accept(File dir, String name) {
            return dir == this.dir && name.matches(".+\\.lm$");
        }
    }
}

