/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.domimpl.NodeImpl;
import org.lobobrowser.html.domimpl.UINode;
import org.lobobrowser.html.gui.DocumentNotification;
import org.lobobrowser.html.renderer.BoundableRenderable;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.FrameContext;
import org.lobobrowser.html.renderer.NodeRenderer;
import org.lobobrowser.html.renderer.RBlock;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.renderer.RenderableSpot;
import org.lobobrowser.util.Nodes;
import org.lobobrowser.util.gui.ColorFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class HtmlBlockPanel
extends JComponent
implements NodeRenderer,
RenderableContainer,
ClipboardOwner {
    private static final Logger logger;
    private static final boolean loggableInfo;
    protected final FrameContext frameContext;
    protected final UserAgentContext ucontext;
    protected final HtmlRendererContext rcontext;
    protected RenderableSpot startSelection;
    protected RenderableSpot endSelection;
    protected RBlock rblock;
    protected int preferredWidth = -1;
    private Insets defaultPaddingInsets = null;
    private BoundableRenderable mousePressTarget;
    private boolean processingDocumentNotification = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.html.gui.HtmlBlockPanel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        loggableInfo = logger.isLoggable(Level.INFO);
    }

    public HtmlBlockPanel(int listNesting, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext) {
        this(listNesting, ColorFactory.TRANSPARENT, false, pcontext, rcontext, frameContext);
    }

    public HtmlBlockPanel(int listNesting, Color background, boolean opaque, UserAgentContext pcontext, HtmlRendererContext rcontext, FrameContext frameContext) {
        this.setLayout(null);
        this.setAutoscrolls(true);
        this.frameContext = frameContext;
        this.ucontext = pcontext;
        this.rcontext = rcontext;
        this.setOpaque(opaque);
        this.setBackground(background);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                if ("copy".equals(command)) {
                    HtmlBlockPanel.this.copy();
                }
            }
        };
        this.registerKeyboardAction(actionListener, "copy", KeyStroke.getKeyStroke(65485, 0), 0);
        this.registerKeyboardAction(actionListener, "copy", KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 0);
        this.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                HtmlBlockPanel.this.onMouseClick(e);
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
                HtmlBlockPanel.this.onMouseExited(e);
            }

            public void mousePressed(MouseEvent e) {
                HtmlBlockPanel.this.onMousePressed(e);
            }

            public void mouseReleased(MouseEvent e) {
                HtmlBlockPanel.this.onMouseReleased(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                HtmlBlockPanel.this.onMouseDragged(e);
            }

            public void mouseMoved(MouseEvent arg0) {
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                HtmlBlockPanel.this.onMouseWheelMoved(e);
            }
        });
    }

    public BoundableRenderable getRootRenderable() {
        return this.rblock;
    }

    public void setPreferredWidth(int width) {
        this.preferredWidth = width;
    }

    public Dimension getPreferredSize() {
        RBlock block;
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        int pw = this.preferredWidth;
        if (pw != -1 && (block = this.rblock) != null) {
            block.layout(pw, 0, false, false, 0);
            int newPw = Math.max(block.width + block.getVScrollBarWidth(), pw);
            return new Dimension(newPw, block.height);
        }
        return new Dimension(600, 400);
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public boolean copy() {
        String selection = this.getSelectionText();
        if (selection != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(selection), this);
            return true;
        }
        return false;
    }

    public void setDefaultPaddingInsets(Insets insets) {
        this.defaultPaddingInsets = insets;
    }

    public int getFirstLineHeight() {
        RBlock block = this.rblock;
        return block == null ? 0 : block.getFirstLineHeight();
    }

    public void setSelectionEnd(RenderableSpot rpoint) {
        this.endSelection = rpoint;
    }

    public void setSelectionStart(RenderableSpot rpoint) {
        this.startSelection = rpoint;
    }

    public boolean isSelectionAvailable() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        return start != null && end != null && !start.equals(end);
    }

    public Node getSelectionNode() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        if (start != null && end != null) {
            return Nodes.getCommonAncestor((Node)((Object)start.renderable.getModelNode()), (Node)((Object)end.renderable.getModelNode()));
        }
        return null;
    }

    public void setRootNode(NodeImpl node) {
        if (node != null) {
            RBlock block = new RBlock(node, 0, this.ucontext, this.rcontext, this.frameContext, this, 5);
            block.setDefaultPaddingInsets(this.defaultPaddingInsets);
            node.setUINode(block);
            this.rblock = block;
        } else {
            this.rblock = null;
        }
        this.invalidate();
        this.validateAll();
        this.repaint();
    }

    protected void validateAll() {
        Container parent;
        Container toValidate = this;
        while ((parent = toValidate.getParent()) != null && !parent.isValid()) {
            toValidate = parent;
        }
        ((Component)toValidate).validate();
    }

    public void setRootNode(NodeImpl node, boolean setContainer) {
        this.setRootNode(node);
    }

    protected void revalidatePanel() {
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public NodeImpl getRootNode() {
        RBlock block = this.rblock;
        return block == null ? null : (NodeImpl)block.getModelNode();
    }

    private void onMouseClick(MouseEvent event) {
        RBlock block = this.rblock;
        if (block != null && event.getButton() == 1 && event.getClickCount() > 1) {
            Point point = event.getPoint();
            block.onDoubleClick(event, point.x, point.y);
        }
    }

    private void onMousePressed(MouseEvent event) {
        this.requestFocus();
        RBlock block = this.rblock;
        if (block != null) {
            Point point = event.getPoint();
            this.mousePressTarget = block;
            int rx = point.x;
            int ry = point.y;
            block.onMousePressed(event, point.x, point.y);
            RenderableSpot rp = block.getLowestRenderableSpot(rx, ry);
            if (rp != null) {
                this.frameContext.resetSelection(rp);
            } else {
                this.frameContext.resetSelection(null);
            }
        }
    }

    private void onMouseReleased(MouseEvent event) {
        RBlock block = this.rblock;
        if (block != null) {
            Point point = event.getPoint();
            int rx = point.x;
            int ry = point.y;
            if (event.getButton() == 1) {
                block.onMouseClick(event, rx, ry);
            }
            block.onMouseReleased(event, rx, ry);
            BoundableRenderable oldTarget = this.mousePressTarget;
            if (oldTarget != null) {
                this.mousePressTarget = null;
                if (oldTarget != block) {
                    oldTarget.onMouseDisarmed(event);
                }
            }
        } else {
            this.mousePressTarget = null;
        }
    }

    private void onMouseExited(MouseEvent event) {
        BoundableRenderable oldTarget = this.mousePressTarget;
        if (oldTarget != null) {
            this.mousePressTarget = null;
            oldTarget.onMouseDisarmed(event);
        }
    }

    private void onMouseWheelMoved(MouseWheelEvent mwe) {
        RBlock block = this.rblock;
        if (block != null) {
            switch (mwe.getScrollType()) {
                case 0: {
                    int units = mwe.getWheelRotation() * mwe.getScrollAmount();
                    block.scrollByUnits(1, units);
                }
            }
        }
    }

    private void onMouseDragged(MouseEvent event) {
        RBlock block = this.rblock;
        if (block != null) {
            Point point = event.getPoint();
            RenderableSpot rp = block.getLowestRenderableSpot(point.x, point.y);
            if (rp != null) {
                this.frameContext.expandSelection(rp);
            }
            block.ensureVisible(point);
        }
    }

    public void paint(Graphics g) {
        RBlock block;
        if (this.isOpaque()) {
            Rectangle clipBounds = g.getClipBounds();
            g.setColor(this.getBackground());
            g.fillRect(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height);
        }
        if (g instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if ((block = this.rblock) != null) {
            boolean liflag = loggableInfo;
            long time1 = liflag ? System.currentTimeMillis() : 0L;
            block.paint(g);
            if (liflag) {
                long time2 = System.currentTimeMillis();
                NodeImpl rootNode = this.getRootNode();
                String uri = rootNode instanceof Document ? ((Document)((Object)rootNode)).getDocumentURI() : "";
                logger.info("paintComponent(): URI=[" + uri + "]. Block paint elapsed: " + (time2 - time1) + " ms.");
            }
            RenderableSpot start = this.startSelection;
            RenderableSpot end = this.endSelection;
            if (start != null && end != null && !start.equals(end)) {
                block.paintSelection(g, false, start, end);
            }
        }
    }

    public void doLayout() {
        if (EventQueue.isDispatchThread()) {
            Dimension size = this.getSize();
            boolean liflag = loggableInfo;
            long time1 = 0L;
            if (liflag) {
                time1 = System.currentTimeMillis();
            }
            this.removeAll();
            RBlock block = this.rblock;
            if (block != null) {
                ModelNode rootNode = block.getModelNode();
                block.layout(size.width, size.height, true, true);
                block.setOrigin(0, 0);
                block.updateWidgetBounds(0, 0);
                if (liflag) {
                    long time2 = System.currentTimeMillis();
                    String uri = rootNode instanceof Document ? ((Document)((Object)rootNode)).getDocumentURI() : "";
                    logger.info("doLayout(): URI=[" + uri + "]. Block layout elapsed: " + (time2 - time1) + " ms. Component count: " + this.getComponentCount() + ".");
                }
            }
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    HtmlBlockPanel.this.doLayout();
                }
            });
        }
    }

    public void repaint(ModelNode modelNode) {
        this.repaint();
    }

    public String getSelectionText() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        if (start != null && end != null) {
            StringBuffer buffer = new StringBuffer();
            this.rblock.extractSelectionText(buffer, false, start, end);
            return buffer.toString();
        }
        return null;
    }

    public boolean hasSelection() {
        RenderableSpot start = this.startSelection;
        RenderableSpot end = this.endSelection;
        return start != null && end != null && !start.equals(end);
    }

    protected void paintChildren(Graphics g) {
    }

    public Color getPaintedBackgroundColor() {
        return this.isOpaque() ? this.getBackground() : null;
    }

    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }

    public void relayout() {
        this.revalidatePanel();
    }

    public void invalidateLayoutUpTree() {
    }

    public void updateAllWidgetBounds() {
        this.rblock.updateWidgetBounds(0, 0);
    }

    public Point getGUIPoint(int clientX, int clientY) {
        return new Point(clientX, clientY);
    }

    public void focus() {
        this.grabFocus();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void processDocumentNotifications(DocumentNotification[] notifications) {
        if (this.processingDocumentNotification) {
            throw new IllegalStateException("Recursive");
        }
        this.processingDocumentNotification = true;
        try {
            boolean topLayout = false;
            ArrayList<RElement> repainters = null;
            int length = notifications.length;
            int i = 0;
            while (i < length) {
                DocumentNotification dn = notifications[i];
                int type = dn.type;
                switch (type) {
                    case 2: 
                    case 3: {
                        RElement relement;
                        UINode uiNode;
                        NodeImpl node = dn.node;
                        if (node == null) {
                            if (loggableInfo) {
                                logger.info("processDocumentNotifications(): Calling invalidateLayoutDeep().");
                            }
                            this.rblock.invalidateLayoutDeep();
                        } else {
                            uiNode = node.findUINode();
                            if (uiNode != null) {
                                relement = (RElement)uiNode;
                                relement.invalidateLayoutUpTree();
                            } else if (loggableInfo) {
                                logger.info("processDocumentNotifications(): Unable to find UINode for " + node);
                            }
                        }
                        topLayout = true;
                        break;
                    }
                    case 1: {
                        UINode uiNode;
                        NodeImpl node = dn.node;
                        NodeImpl parent = (NodeImpl)node.getParentNode();
                        if (parent != null && (uiNode = parent.findUINode()) != null) {
                            RElement relement = (RElement)uiNode;
                            relement.invalidateLayoutUpTree();
                        }
                        topLayout = true;
                        break;
                    }
                    case 0: {
                        NodeImpl node = dn.node;
                        UINode uiNode = node.findUINode();
                        if (uiNode == null) break;
                        if (repainters == null) {
                            repainters = new ArrayList<RElement>(1);
                        }
                        RElement relement = (RElement)uiNode;
                        repainters.add(relement);
                        break;
                    }
                }
                ++i;
            }
            if (topLayout) {
                this.revalidatePanel();
            } else if (repainters != null) {
                Iterator i2 = repainters.iterator();
                while (i2.hasNext()) {
                    RElement element = (RElement)i2.next();
                    element.repaint();
                }
            }
            Object var12_15 = null;
            this.processingDocumentNotification = false;
            return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.processingDocumentNotification = false;
            throw throwable;
        }
    }

    public void addDelayedPair(DelayedPair pair) {
    }

    public RenderableContainer getParentContainer() {
        return null;
    }

    public Collection getDelayedPairs() {
        return null;
    }

    public void clearDelayedPairs() {
    }
}

