/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import org.lobobrowser.html.HttpRequest;
import org.lobobrowser.html.ReadyStateChangeListener;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.domimpl.HTMLDocumentImpl;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.ModelNode;
import org.lobobrowser.html.renderer.BaseRCollection;
import org.lobobrowser.html.renderer.DelayedPair;
import org.lobobrowser.html.renderer.RCollection;
import org.lobobrowser.html.renderer.RElement;
import org.lobobrowser.html.renderer.RenderableContainer;
import org.lobobrowser.html.style.BackgroundInfo;
import org.lobobrowser.html.style.CSS2PropertiesImpl;
import org.lobobrowser.html.style.HtmlValues;
import org.lobobrowser.html.style.RenderState;
import org.lobobrowser.util.gui.ColorFactory;

abstract class BaseElementRenderable
extends BaseRCollection
implements RElement,
RenderableContainer,
ImageObserver {
    public static final int OVERFLOW_NONE = 0;
    public static final int OVERFLOW_SCROLL = 1;
    public static final int OVERFLOW_AUTO = 2;
    public static final int OVERFLOW_HIDDEN = 3;
    public static final int OVERFLOW_VISIBLE = 4;
    public static final int OVERFLOW_VERTICAL = 5;
    private Collection guiComponents = null;
    protected Collection delayedPairs = null;
    protected Color backgroundColor;
    protected volatile Image backgroundImage;
    protected int zIndex;
    protected Color borderTopColor;
    protected Color borderLeftColor;
    protected Color borderBottomColor;
    protected Color borderRightColor;
    protected Insets borderInsets;
    protected String lastBackgroundImageUri;
    protected Insets defaultMarginInsets;
    private int cachedOverflow = -1;
    protected final UserAgentContext userAgentContext;
    protected boolean layoutDeepCanBeInvalidated = false;
    protected static final int SCROLL_BAR_THICKNESS = 16;

    public BaseElementRenderable(RenderableContainer container, ModelNode modelNode, UserAgentContext ucontext) {
        super(container, modelNode);
        this.userAgentContext = ucontext;
    }

    public float getAlignmentX() {
        return 0.0f;
    }

    public float getAlignmentY() {
        return 0.0f;
    }

    public final void invalidateLayoutDeep() {
        if (this.layoutDeepCanBeInvalidated) {
            this.layoutDeepCanBeInvalidated = false;
            this.invalidateLayoutLocal();
            Iterator i = this.getRenderables();
            if (i != null) {
                while (i.hasNext()) {
                    Object r = i.next();
                    if (!(r instanceof RCollection)) continue;
                    ((RCollection)r).invalidateLayoutDeep();
                }
            }
        }
    }

    protected void invalidateLayoutLocal() {
        this.cachedOverflow = -1;
    }

    protected int getDeclaredWidth(RenderState renderState, int availWidth) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            CSS2PropertiesImpl props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String widthText = props.getWidth();
            if (widthText == null || "".equals(widthText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(widthText, renderState, -1, availWidth);
        }
        return -1;
    }

    protected int getDeclaredHeight(RenderState renderState, int availHeight) {
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLElementImpl) {
            HTMLElementImpl element = (HTMLElementImpl)rootNode;
            CSS2PropertiesImpl props = element.getCurrentStyle();
            if (props == null) {
                return -1;
            }
            String heightText = props.getHeight();
            if (heightText == null || "".equals(heightText)) {
                return -1;
            }
            return HtmlValues.getPixelSize(heightText, renderState, -1, availHeight);
        }
        return -1;
    }

    protected int getOverflow() {
        String overflowTextTL;
        String overflowText;
        HTMLElementImpl element;
        CSS2PropertiesImpl props;
        int co = this.cachedOverflow;
        if (co != -1) {
            return co;
        }
        ModelNode rootNode = this.modelNode;
        co = rootNode instanceof HTMLElementImpl ? ((props = (element = (HTMLElementImpl)rootNode).getCurrentStyle()) == null ? 0 : ((overflowText = props.getOverflow()) == null ? 0 : ("scroll".equals(overflowTextTL = overflowText.toLowerCase()) ? 1 : ("auto".equals(overflowTextTL) ? 2 : ("vertical".equals(overflowTextTL) ? 5 : ("hidden".equals(overflowTextTL) ? 3 : ("visible".equals(overflowTextTL) ? 4 : 0))))))) : 0;
        this.cachedOverflow = co;
        return co;
    }

    public void paint(Graphics g) {
    }

    public final void layout(int availWidth, int availHeight) {
        this.layout(availWidth, availHeight, false, false);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void layout(int availWidth, int availHeight, boolean expandWidth, boolean expandHeight) {
        try {
            this.doLayout(availWidth, availHeight, expandWidth, expandHeight);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.layoutUpTreeCanBeInvalidated = true;
            this.layoutDeepCanBeInvalidated = true;
            return;
        }
    }

    protected abstract void doLayout(int var1, int var2, boolean var3, boolean var4);

    protected final void sendGUIComponentsToParent() {
        Collection gc = this.guiComponents;
        int count = 0;
        if (gc != null) {
            RenderableContainer rc = this.container;
            Iterator i = gc.iterator();
            while (i.hasNext()) {
                ++count;
                rc.add((Component)i.next());
            }
        }
    }

    protected final void clearGUIComponents() {
        Collection gc = this.guiComponents;
        if (gc != null) {
            gc.clear();
        }
    }

    public Component add(Component component) {
        HashSet<Component> gc = this.guiComponents;
        if (gc == null) {
            this.guiComponents = gc = new HashSet<Component>(1);
        }
        gc.add(component);
        return component;
    }

    public void updateAllWidgetBounds() {
        this.container.updateAllWidgetBounds();
    }

    public void updateWidgetBounds() {
        Point guiPoint = this.getGUIPoint(0, 0);
        this.updateWidgetBounds(guiPoint.x, guiPoint.y);
    }

    protected void applyStyle() {
        String backgroundImageUri;
        HTMLElementImpl rootElement;
        ModelNode rootNode = this.modelNode;
        if (rootNode instanceof HTMLDocumentImpl) {
            HTMLDocumentImpl doc = (HTMLDocumentImpl)rootNode;
            rootElement = (HTMLElementImpl)doc.getBody();
        } else {
            rootElement = (HTMLElementImpl)rootNode;
        }
        if (rootElement == null) {
            this.clearStyle();
            this.backgroundColor = null;
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
            return;
        }
        RenderState rs = rootElement.getRenderState();
        if (rs == null) {
            throw new IllegalStateException("Element without render state: " + rootElement + "; parent=" + rootElement.getParentNode());
        }
        BackgroundInfo binfo = rs.getBackgroundInfo();
        this.backgroundColor = binfo == null ? null : binfo.backgroundColor;
        String string = backgroundImageUri = binfo == null ? null : binfo.backgroundImage;
        if (backgroundImageUri == null) {
            this.backgroundImage = null;
            this.lastBackgroundImageUri = null;
        } else if (!backgroundImageUri.equals(this.lastBackgroundImageUri)) {
            this.lastBackgroundImageUri = backgroundImageUri;
            this.loadBackgroundImage(backgroundImageUri);
        }
        CSS2PropertiesImpl props = rootElement.getCurrentStyle();
        if (props == null) {
            this.clearStyle();
        } else {
            String zIndex;
            String borderRightColorText;
            String borderBottomColorText;
            String borderLeftColorText;
            String borderTopColorText;
            this.borderInsets = null;
            this.borderTopColor = null;
            this.borderLeftColor = null;
            this.borderBottomColor = null;
            this.borderRightColor = null;
            String border = props.getBorder();
            if (border != null) {
                this.applyBorder(rs, border);
            }
            this.borderInsets = HtmlValues.getBorderInsets(this.borderInsets, props, rs);
            String borderColorText = props.getBorderColor();
            if (borderColorText != null) {
                Color[] colorsArray = HtmlValues.getColors(borderColorText);
                this.borderTopColor = colorsArray[0];
                this.borderLeftColor = colorsArray[1];
                this.borderBottomColor = colorsArray[2];
                this.borderRightColor = colorsArray[3];
            }
            if ((borderTopColorText = props.getBorderTopColor()) != null) {
                this.borderTopColor = ColorFactory.getInstance().getColor(borderTopColorText);
            }
            if ((borderLeftColorText = props.getBorderLeftColor()) != null) {
                this.borderLeftColor = ColorFactory.getInstance().getColor(borderLeftColorText);
            }
            if ((borderBottomColorText = props.getBorderBottomColor()) != null) {
                this.borderBottomColor = ColorFactory.getInstance().getColor(borderBottomColorText);
            }
            if ((borderRightColorText = props.getBorderRightColor()) != null) {
                this.borderRightColor = ColorFactory.getInstance().getColor(borderRightColorText);
            }
            if ((zIndex = props.getZIndex()) != null) {
                try {
                    this.zIndex = Integer.parseInt(zIndex);
                }
                catch (NumberFormatException err) {
                    logger.log(Level.WARNING, "Unable to parse z-index [" + zIndex + "] in element " + this.modelNode + ".", err);
                    this.zIndex = 0;
                }
            } else {
                this.zIndex = 0;
            }
        }
    }

    protected void loadBackgroundImage(String uri) {
        ModelNode rc = this.modelNode;
        UserAgentContext ctx = this.userAgentContext;
        if (ctx != null) {
            final HttpRequest request = ctx.createHttpRequest();
            request.addReadyStateChangeListener(new ReadyStateChangeListener(){

                public void readyStateChanged() {
                    int status;
                    int readyState = request.getReadyState();
                    if (readyState == 4 && ((status = request.getStatus()) == 200 || status == 0)) {
                        Image img;
                        BaseElementRenderable.this.backgroundImage = img = request.getResponseImage();
                        int w = img.getWidth(BaseElementRenderable.this);
                        int h = img.getHeight(BaseElementRenderable.this);
                        if (w != -1 && h != -1) {
                            BaseElementRenderable.this.repaint();
                        }
                    }
                }
            });
            try {
                final URL fullUrl = rc.getFullURL(uri);
                SecurityManager sm = System.getSecurityManager();
                if (sm == null) {
                    request.open("GET", fullUrl);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            request.open("GET", fullUrl);
                            return null;
                        }
                    });
                }
            }
            catch (MalformedURLException mfu) {
                rc.warn("Bad image URI: [" + uri + "]", mfu);
            }
        }
    }

    public int getZIndex() {
        return this.zIndex;
    }

    void applyBorder(RenderState renderState, String border) {
        String[] tokens = HtmlValues.splitCssValue(border);
        int i = 0;
        while (i < tokens.length) {
            Insets bi;
            String token = tokens[i];
            if (HtmlValues.isLength(token)) {
                Insets bi2;
                int pixelSize = HtmlValues.getPixelSize(token, renderState, 0);
                this.borderInsets = bi2 = new Insets(pixelSize, pixelSize, pixelSize, pixelSize);
            } else if (ColorFactory.getInstance().isColor(token)) {
                Color color;
                this.borderLeftColor = color = ColorFactory.getInstance().getColor(token);
                this.borderRightColor = color;
                this.borderTopColor = color;
                this.borderBottomColor = color;
            } else if (HtmlValues.isBorderStyle(token) && ("solid".equalsIgnoreCase(token) || "dashed".equalsIgnoreCase(token)) && (bi = this.borderInsets) == null) {
                this.borderInsets = bi = new Insets(4, 4, 4, 4);
            }
            ++i;
        }
    }

    private Color getBorderTopColor() {
        Color c = this.borderTopColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderLeftColor() {
        Color c = this.borderLeftColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderBottomColor() {
        Color c = this.borderBottomColor;
        return c == null ? Color.black : c;
    }

    private Color getBorderRightColor() {
        Color c = this.borderRightColor;
        return c == null ? Color.black : c;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void prePaint(Graphics g) {
        Insets borderInsets;
        int startWidth = this.width;
        int startHeight = this.height;
        int totalWidth = startWidth;
        int totalHeight = startHeight;
        int startX = 0;
        int startY = 0;
        ModelNode node = this.modelNode;
        RenderState rs = node.getRenderState();
        Insets marginInsets = this.getMarginInsets(rs);
        if (marginInsets != null) {
            totalWidth -= marginInsets.left + marginInsets.right;
            totalHeight -= marginInsets.top + marginInsets.bottom;
            startX += marginInsets.left;
            startY += marginInsets.top;
        }
        if ((borderInsets = this.borderInsets) != null) {
            int bleft = borderInsets.left;
            int newStartX = startX + bleft;
            int btop = borderInsets.top;
            int newStartY = startY + btop;
            int bright = borderInsets.right;
            int newTotalWidth = totalWidth - (bleft + bright);
            int bbottom = borderInsets.bottom;
            int newTotalHeight = totalHeight - (btop + bbottom);
            Rectangle clientRegion = new Rectangle(newStartX, newStartY, newTotalWidth, newTotalHeight);
            Rectangle clipBounds = g.getClipBounds();
            if (!clientRegion.contains(clipBounds)) {
                int i;
                int i2;
                if (btop > 0) {
                    g.setColor(this.getBorderTopColor());
                    i2 = 0;
                    while (i2 < btop) {
                        int leftOffset = i2 * bleft / btop;
                        int rightOffset = i2 * bright / btop;
                        g.drawLine(startX + leftOffset, startY + i2, startX + totalWidth - rightOffset - 1, startY + i2);
                        ++i2;
                    }
                }
                if (bright > 0) {
                    g.setColor(this.getBorderRightColor());
                    int lastX = startX + totalWidth - 1;
                    i = 0;
                    while (i < bright) {
                        int topOffset = i * btop / bright;
                        int bottomOffset = i * bbottom / bright;
                        g.drawLine(lastX - i, startY + topOffset, lastX - i, startY + totalHeight - bottomOffset - 1);
                        ++i;
                    }
                }
                if (bleft > 0) {
                    g.setColor(this.getBorderLeftColor());
                    i2 = 0;
                    while (i2 < bleft) {
                        int topOffset = i2 * btop / bleft;
                        int bottomOffset = i2 * bbottom / bleft;
                        g.drawLine(startX + i2, startY + topOffset, startX + i2, startY + totalHeight - bottomOffset - 1);
                        ++i2;
                    }
                }
                if (bbottom > 0) {
                    g.setColor(this.getBorderBottomColor());
                    int lastY = startY + totalHeight - 1;
                    i = 0;
                    while (i < bbottom) {
                        int leftOffset = i * bleft / bbottom;
                        int rightOffset = i * bright / bbottom;
                        g.drawLine(startX + leftOffset, lastY - i, startX + totalWidth - rightOffset - 1, lastY - i);
                        ++i;
                    }
                }
            }
            totalWidth = newTotalWidth;
            totalHeight = newTotalHeight;
            startX = newStartX;
            startY = newStartY;
        }
        Graphics clientG = g.create(startX, startY, totalWidth, totalHeight);
        try {
            Rectangle bkgBounds = null;
            if (node != null) {
                Color bkg = this.backgroundColor;
                if (bkg != null && bkg.getAlpha() > 0) {
                    clientG.setColor(bkg);
                    bkgBounds = clientG.getClipBounds();
                    clientG.fillRect(bkgBounds.x, bkgBounds.y, bkgBounds.width, bkgBounds.height);
                }
                BackgroundInfo binfo = rs == null ? null : rs.getBackgroundInfo();
                Image image = this.backgroundImage;
                if (image != null) {
                    if (bkgBounds == null) {
                        bkgBounds = clientG.getClipBounds();
                    }
                    int w = image.getWidth(this);
                    int h = image.getHeight(this);
                    if (w != -1 && h != -1) {
                        switch (binfo == null ? 0 : binfo.backgroundRepeat) {
                            case 1: {
                                int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w) / 100;
                                int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h) / 100;
                                clientG.drawImage(image, imageX, imageY, w, h, this);
                                break;
                            }
                            case 2: {
                                int imageY = binfo.backgroundYPositionAbsolute ? binfo.backgroundYPosition : binfo.backgroundYPosition * (totalHeight - h) / 100;
                                int x = bkgBounds.x / w * w;
                                int topX = bkgBounds.x + bkgBounds.width;
                                while (x < topX) {
                                    clientG.drawImage(image, x, imageY, w, h, this);
                                    x += w;
                                }
                                break;
                            }
                            case 3: {
                                int imageX = binfo.backgroundXPositionAbsolute ? binfo.backgroundXPosition : binfo.backgroundXPosition * (totalWidth - w) / 100;
                                int y = bkgBounds.y / h * h;
                                int topY = bkgBounds.y + bkgBounds.height;
                                while (y < topY) {
                                    clientG.drawImage(image, imageX, y, w, h, this);
                                    y += h;
                                }
                                break;
                            }
                            default: {
                                int baseX = bkgBounds.x / w * w;
                                int baseY = bkgBounds.y / h * h;
                                int topX = bkgBounds.x + bkgBounds.width;
                                int topY = bkgBounds.y + bkgBounds.height;
                                int x = baseX;
                                block14: while (x < topX) {
                                    int y = baseY;
                                    while (true) {
                                        if (y >= topY) {
                                            x += w;
                                            continue block14;
                                        }
                                        clientG.drawImage(image, x, y, w, h, this);
                                        y += h;
                                    }
                                }
                                break block2;
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var25_38 = null;
            clientG.dispose();
            throw throwable;
        }
        {
            Object var25_39 = null;
            clientG.dispose();
            return;
        }
    }

    void clearStyle() {
        this.borderInsets = null;
        this.borderTopColor = null;
        this.borderLeftColor = null;
        this.borderBottomColor = null;
        this.borderRightColor = null;
        this.zIndex = 0;
    }

    protected final Insets getMarginInsets(RenderState rs) {
        Insets mi = rs.getMarginInsets();
        if (mi == null) {
            return this.defaultMarginInsets;
        }
        return mi;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        if ((infoflags & 0x20) != 0 || (infoflags & 0x10) != 0) {
            this.repaint();
        }
        return true;
    }

    public Insets getInsets(boolean hscroll, boolean vscroll) {
        RenderState rs = this.modelNode.getRenderState();
        Insets mi = this.getMarginInsets(rs);
        Insets bi = this.borderInsets;
        int top = 0;
        int bottom = 0;
        int left = 0;
        int right = 0;
        if (mi != null) {
            top += mi.top;
            left += mi.left;
            bottom += mi.bottom;
            right += mi.right;
        }
        if (bi != null) {
            top += bi.top;
            left += bi.left;
            bottom += bi.bottom;
            right += bi.right;
        }
        if (hscroll) {
            bottom += 16;
        }
        if (vscroll) {
            right += 16;
        }
        return new Insets(top, left, bottom, right);
    }

    protected final void sendDelayedPairsToParent() {
        Collection gc = this.delayedPairs;
        if (gc != null) {
            RenderableContainer rc = this.container;
            Iterator i = gc.iterator();
            while (i.hasNext()) {
                DelayedPair pair = (DelayedPair)i.next();
                if (pair.targetParent == this) continue;
                rc.addDelayedPair(pair);
            }
        }
    }

    public final void clearDelayedPairs() {
        Collection gc = this.delayedPairs;
        if (gc != null) {
            gc.clear();
        }
    }

    public final Collection getDelayedPairs() {
        return this.delayedPairs;
    }

    public void addDelayedPair(DelayedPair pair) {
        LinkedList<DelayedPair> gc = this.delayedPairs;
        if (gc == null) {
            this.delayedPairs = gc = new LinkedList<DelayedPair>();
        }
        gc.add(pair);
    }

    public RenderableContainer getParentContainer() {
        return this.container;
    }
}

