/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.renderer;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComboBox;
import org.lobobrowser.html.domimpl.HTMLBaseInputElement;
import org.lobobrowser.html.domimpl.HTMLElementImpl;
import org.lobobrowser.html.domimpl.NodeFilter;
import org.lobobrowser.html.renderer.BaseInputControl;
import org.lobobrowser.util.gui.WrapperLayout;
import org.w3c.dom.Node;
import org.w3c.dom.html2.HTMLOptionElement;

class InputSelectControl
extends BaseInputControl {
    private static final OptionFilter OPTION_FILTER = new OptionFilter();
    private final JComboBox comboBox;

    public InputSelectControl(HTMLBaseInputElement modelNode) {
        super(modelNode);
        this.setLayout(WrapperLayout.getInstance());
        JComboBox comboBox = new JComboBox();
        this.add(comboBox);
        this.comboBox = comboBox;
    }

    public void reset(int availWidth, int availHeight) {
        super.reset(availWidth, availHeight);
        HTMLElementImpl selectElement = this.controlElement;
        ArrayList list = selectElement.getDescendents(OPTION_FILTER);
        Iterator i = list.iterator();
        JComboBox comboBox = this.comboBox;
        comboBox.removeAllItems();
        while (i.hasNext()) {
            HTMLOptionElement option = (HTMLOptionElement)i.next();
            OptionItem item = new OptionItem(option);
            comboBox.addItem(item);
            if (!option.getDefaultSelected()) continue;
            comboBox.setSelectedItem(item);
        }
    }

    public String getValue() {
        OptionItem item = (OptionItem)this.comboBox.getSelectedItem();
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    public boolean getMultiple() {
        return false;
    }

    public void setMultiple(boolean value) {
        if (value) {
            throw new UnsupportedOperationException();
        }
    }

    public int getSelectedIndex() {
        return this.comboBox.getSelectedIndex();
    }

    public void setSelectedIndex(int value) {
        this.comboBox.setSelectedIndex(value);
    }

    public int getVisibleSize() {
        return this.comboBox.getMaximumRowCount();
    }

    public void setVisibleSize(int value) {
        this.comboBox.setMaximumRowCount(value);
    }

    public void resetInput() {
        this.comboBox.setSelectedIndex(-1);
    }

    private static class OptionFilter
    implements NodeFilter {
        private OptionFilter() {
        }

        public boolean accept(Node node) {
            return node instanceof HTMLOptionElement;
        }
    }

    private static class OptionItem {
        private final HTMLOptionElement option;
        private final String caption;

        public OptionItem(HTMLOptionElement option) {
            this.option = option;
            String label = option.getLabel();
            this.caption = label == null ? option.getText() : label;
        }

        public String toString() {
            return this.caption;
        }

        public String getValue() {
            String value = this.option.getValue();
            if (value == null) {
                value = this.option.getText();
            }
            return value;
        }
    }
}

