/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.js;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.lobobrowser.js.JavaFunctionObject;
import org.lobobrowser.js.PropertyInfo;
import org.mozilla.javascript.Function;

public class JavaClassWrapper {
    private final Class javaClass;
    private final Map functions = new HashMap();
    private final Map properties = new HashMap();
    private PropertyInfo nameIndexer;
    private PropertyInfo integerIndexer;
    static /* synthetic */ Class class$0;

    public JavaClassWrapper(Class class1) {
        this.javaClass = class1;
        this.scanMethods();
    }

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        return this.javaClass.newInstance();
    }

    public String getClassName() {
        String className = this.javaClass.getName();
        int lastDotIdx = className.lastIndexOf(46);
        return lastDotIdx == -1 ? className : className.substring(lastDotIdx + 1);
    }

    public Function getFunction(String name) {
        return (Function)this.functions.get(name);
    }

    public PropertyInfo getProperty(String name) {
        return (PropertyInfo)this.properties.get(name);
    }

    private void scanMethods() {
        Method[] methods = this.javaClass.getMethods();
        int len = methods.length;
        int i = 0;
        while (i < len) {
            Method method = methods[i];
            String name = method.getName();
            if (this.isPropertyMethod(name, method)) {
                this.ensurePropertyKnown(name, method);
            }
            if (this.isNameIndexer(name, method)) {
                this.updateNameIndexer(name, method);
            } else if (this.isIntegerIndexer(name, method)) {
                this.updateIntegerIndexer(name, method);
            } else {
                JavaFunctionObject f = (JavaFunctionObject)((Object)this.functions.get(name));
                if (f == null) {
                    f = new JavaFunctionObject(name);
                    this.functions.put(name, f);
                }
                f.addMethod(method);
            }
            ++i;
        }
    }

    private boolean isNameIndexer(String name, Method method) {
        return "namedItem".equals(name) && method.getParameterTypes().length == 1 || "setNamedItem".equals(name) && method.getParameterTypes().length == 2;
    }

    private boolean isIntegerIndexer(String name, Method method) {
        return "item".equals(name) && method.getParameterTypes().length == 1 || "setItem".equals(name) && method.getParameterTypes().length == 2;
    }

    private void updateNameIndexer(String methodName, Method method) {
        PropertyInfo indexer;
        boolean getter = true;
        if (methodName.startsWith("set")) {
            getter = false;
        }
        if ((indexer = this.nameIndexer) == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Object");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.nameIndexer = indexer = new PropertyInfo("$item", clazz);
        }
        if (getter) {
            indexer.setGetter(method);
        } else {
            indexer.setSetter(method);
        }
    }

    private void updateIntegerIndexer(String methodName, Method method) {
        PropertyInfo indexer;
        boolean getter = true;
        if (methodName.startsWith("set")) {
            getter = false;
        }
        if ((indexer = this.integerIndexer) == null) {
            Class<?> pt = getter ? method.getReturnType() : method.getParameterTypes()[1];
            this.integerIndexer = indexer = new PropertyInfo("$item", pt);
        }
        if (getter) {
            indexer.setGetter(method);
        } else {
            indexer.setSetter(method);
        }
    }

    public PropertyInfo getIntegerIndexer() {
        return this.integerIndexer;
    }

    public PropertyInfo getNameIndexer() {
        return this.nameIndexer;
    }

    private boolean isPropertyMethod(String name, Method method) {
        if (name.startsWith("get") || name.startsWith("is")) {
            return method.getParameterTypes().length == 0;
        }
        if (name.startsWith("set")) {
            return method.getParameterTypes().length == 1;
        }
        return false;
    }

    private String uncapitalize(String text) {
        try {
            return String.valueOf(Character.toLowerCase(text.charAt(0))) + text.substring(1);
        }
        catch (IndexOutOfBoundsException iob) {
            return text;
        }
    }

    private void ensurePropertyKnown(String methodName, Method method) {
        String propertyName;
        boolean getter = false;
        if (methodName.startsWith("get")) {
            String capPropertyName = methodName.substring(3);
            propertyName = this.uncapitalize(capPropertyName);
            getter = true;
        } else if (methodName.startsWith("set")) {
            String capPropertyName = methodName.substring(3);
            propertyName = this.uncapitalize(capPropertyName);
        } else if (methodName.startsWith("is")) {
            String capPropertyName = methodName.substring(2);
            propertyName = this.uncapitalize(capPropertyName);
            getter = true;
        } else {
            throw new IllegalArgumentException("methodName=" + methodName);
        }
        PropertyInfo pinfo = (PropertyInfo)this.properties.get(propertyName);
        if (pinfo == null) {
            Class<?> pt = getter ? method.getReturnType() : method.getParameterTypes()[0];
            pinfo = new PropertyInfo(propertyName, pt);
            this.properties.put(propertyName, pinfo);
        }
        if (getter) {
            pinfo.setGetter(method);
        } else {
            pinfo.setSetter(method);
        }
    }

    public String toString() {
        return this.javaClass.getName();
    }
}

