/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.js;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.js.JavaClassWrapper;
import org.lobobrowser.js.JavaConstructorObject;
import org.lobobrowser.js.JavaInstantiator;
import org.lobobrowser.js.JavaScript;
import org.lobobrowser.js.PropertyInfo;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrappedException;

public class JavaObjectWrapper
extends ScriptableObject {
    private static final Logger logger;
    private static final boolean loggableInfo;
    private final Object delegate;
    private final JavaClassWrapper classWrapper;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.js.JavaObjectWrapper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        loggableInfo = logger.isLoggable(Level.INFO);
    }

    public JavaObjectWrapper(JavaClassWrapper classWrapper) throws InstantiationException, IllegalAccessException {
        Object delegate;
        this.classWrapper = classWrapper;
        this.delegate = delegate = this.classWrapper.newInstance();
    }

    public JavaObjectWrapper(JavaClassWrapper classWrapper, Object delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Argument delegate cannot be null.");
        }
        this.classWrapper = classWrapper;
        this.delegate = delegate;
    }

    public Object getJavaObject() {
        return this.delegate;
    }

    public String getClassName() {
        return this.classWrapper.getClassName();
    }

    public Object get(int index, Scriptable start) {
        PropertyInfo pinfo = this.classWrapper.getIntegerIndexer();
        if (pinfo == null) {
            return super.get(index, start);
        }
        try {
            Method getter = pinfo.getGetter();
            if (getter == null) {
                throw new EvaluatorException("Indexer is write-only");
            }
            Object javaObject = this.getJavaObject();
            if (javaObject == null) {
                throw new IllegalStateException("Java object (class=" + this.classWrapper + ") is null.");
            }
            Object raw = getter.invoke(javaObject, new Integer(index));
            return JavaScript.getInstance().getJavascriptObject(raw, this.getParentScope());
        }
        catch (Exception err) {
            throw new WrappedException((Throwable)err);
        }
    }

    public Object get(String name, Scriptable start) {
        PropertyInfo pinfo = this.classWrapper.getProperty(name);
        if (pinfo != null) {
            Method getter = pinfo.getGetter();
            if (getter == null) {
                throw new EvaluatorException("Property '" + name + "' is not readable");
            }
            try {
                Object javaObject = this.getJavaObject();
                if (javaObject == null) {
                    throw new IllegalStateException("Java object (class=" + this.classWrapper + ") is null.");
                }
                Object val = getter.invoke(javaObject, null);
                return JavaScript.getInstance().getJavascriptObject(val, start.getParentScope());
            }
            catch (Exception err) {
                throw new WrappedException((Throwable)err);
            }
        }
        Function f = this.classWrapper.getFunction(name);
        if (f != null) {
            return f;
        }
        PropertyInfo ni = this.classWrapper.getNameIndexer();
        if (ni != null) {
            Method getter = ni.getGetter();
            if (getter != null) {
                Object javaObject = this.getJavaObject();
                if (javaObject == null) {
                    throw new IllegalStateException("Java object (class=" + this.classWrapper + ") is null.");
                }
                try {
                    Object val = getter.invoke(javaObject, name);
                    if (val == null) {
                        return super.get(name, start);
                    }
                    return JavaScript.getInstance().getJavascriptObject(val, start.getParentScope());
                }
                catch (Exception err) {
                    throw new WrappedException((Throwable)err);
                }
            }
            return super.get(name, start);
        }
        return super.get(name, start);
    }

    public void put(int index, Scriptable start, Object value) {
        PropertyInfo pinfo = this.classWrapper.getIntegerIndexer();
        if (pinfo == null) {
            super.put(index, start, value);
        } else {
            try {
                Method setter = pinfo.getSetter();
                if (setter == null) {
                    throw new EvaluatorException("Indexer is read-only");
                }
                Object actualValue = JavaScript.getInstance().getJavaObject(value, pinfo.getPropertyType());
                setter.invoke(this.getJavaObject(), new Integer(index), actualValue);
            }
            catch (Exception err) {
                throw new WrappedException((Throwable)err);
            }
        }
    }

    public void put(String name, Scriptable start, Object value) {
        PropertyInfo pinfo = this.classWrapper.getProperty(name);
        if (pinfo != null) {
            Method setter = pinfo.getSetter();
            if (setter == null) {
                throw new EvaluatorException("Property '" + name + "' is not settable in " + this.classWrapper.getClassName() + ".");
            }
            try {
                Object actualValue = JavaScript.getInstance().getJavaObject(value, pinfo.getPropertyType());
                setter.invoke(this.getJavaObject(), actualValue);
            }
            catch (IllegalArgumentException iae) {
                IllegalArgumentException newException = new IllegalArgumentException("Property named '" + name + "' could not be set with value " + value + ".", iae);
                throw new WrappedException((Throwable)newException);
            }
            catch (Exception err) {
                throw new WrappedException((Throwable)err);
            }
        } else {
            PropertyInfo ni = this.classWrapper.getNameIndexer();
            if (ni != null) {
                Method setter = ni.getSetter();
                if (setter != null) {
                    try {
                        Object actualValue = JavaScript.getInstance().getJavaObject(value, ni.getPropertyType());
                        setter.invoke(this.getJavaObject(), name, actualValue);
                    }
                    catch (Exception err) {
                        throw new WrappedException((Throwable)err);
                    }
                } else {
                    super.put(name, start, value);
                }
            } else {
                super.put(name, start, value);
            }
        }
    }

    public static Function getConstructor(String className, JavaClassWrapper classWrapper, Scriptable scope) {
        return new JavaConstructorObject(className, classWrapper);
    }

    public static Function getConstructor(String className, JavaClassWrapper classWrapper, Scriptable scope, JavaInstantiator instantiator) {
        return new JavaConstructorObject(className, classWrapper, instantiator);
    }

    public Object getDefaultValue(Class hint) {
        block17: {
            Object javaObject;
            block16: {
                if (loggableInfo) {
                    logger.info("getDefaultValue(): hint=" + hint + ",this=" + this.getJavaObject());
                }
                if (hint == null) break block16;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.equals(hint)) break block17;
            }
            if ((javaObject = this.getJavaObject()) == null) {
                throw new IllegalStateException("Java object (class=" + this.classWrapper + ") is null.");
            }
            return javaObject.toString();
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(hint)) {
            Object javaObject = this.getJavaObject();
            if (javaObject instanceof Number) {
                return javaObject;
            }
            if (javaObject instanceof String) {
                return Double.valueOf((String)javaObject);
            }
            return super.getDefaultValue(hint);
        }
        return super.getDefaultValue(hint);
    }

    public String toString() {
        Object javaObject = this.getJavaObject();
        String type = javaObject == null ? "<null>" : javaObject.getClass().getName();
        return "JavaObjectWrapper[object=" + this.getJavaObject() + ",type=" + type + "]";
    }
}

