/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.lobobrowser.util.ObjectFilter;

public class FilteredCollection
implements Collection {
    private final ObjectFilter filter;
    private final Collection sourceCollection;

    public FilteredCollection(Collection sourceCollection, ObjectFilter filter) {
        this.filter = filter;
        this.sourceCollection = sourceCollection;
    }

    public int size() {
        int count = 0;
        Iterator i = this.sourceCollection.iterator();
        while (i.hasNext()) {
            if (this.filter.decode(i.next()) == null) continue;
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        Iterator i = this.sourceCollection.iterator();
        while (i.hasNext()) {
            if (this.filter.decode(i.next()) == null) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object o) {
        return this.sourceCollection.contains(this.filter.encode(o));
    }

    public Iterator iterator() {
        final Iterator sourceIterator = this.sourceCollection.iterator();
        return new Iterator(){
            private Boolean hasNext;
            private Object next;

            private void scanNext() {
                while (sourceIterator.hasNext()) {
                    Object item = FilteredCollection.this.filter.decode(sourceIterator.next());
                    if (item == null) continue;
                    this.hasNext = Boolean.TRUE;
                    this.next = item;
                }
                this.hasNext = Boolean.FALSE;
            }

            public boolean hasNext() {
                if (this.hasNext == null) {
                    this.scanNext();
                }
                return this.hasNext;
            }

            public Object next() {
                if (this.hasNext == null) {
                    this.scanNext();
                }
                if (Boolean.FALSE.equals(this.hasNext)) {
                    throw new NoSuchElementException();
                }
                Object next = this.next;
                this.hasNext = null;
                return next;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    public Object[] toArray(Object[] a) {
        ArrayList<Object> bucket = new ArrayList<Object>();
        Iterator i = this.sourceCollection.iterator();
        while (i.hasNext()) {
            Object item = this.filter.decode(i.next());
            if (item == null) continue;
            bucket.add(item);
        }
        return bucket.toArray(a);
    }

    public boolean add(Object o) {
        return this.sourceCollection.add(this.filter.encode(o));
    }

    public boolean remove(Object o) {
        return this.sourceCollection.remove(this.filter.encode(o));
    }

    public boolean containsAll(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (this.contains(i.next())) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(Collection c) {
        boolean result = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.add(i.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean removeAll(Collection c) {
        boolean result = false;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            if (!this.remove(i.next())) continue;
            result = true;
        }
        return result;
    }

    public boolean retainAll(Collection c) {
        boolean result = false;
        Object[] values = this.toArray();
        int i = 0;
        while (i < values.length) {
            if (!c.contains(values[i]) && this.remove(values[i])) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    public void clear() {
        Object[] values = this.toArray();
        int i = 0;
        while (i < values.length) {
            this.sourceCollection.remove(this.filter.encode(values[i]));
            ++i;
        }
    }
}

