/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ID {
    private static final Random RANDOM1;
    private static final Random RANDOM2;
    private static final Random RANDOM3;
    private static final long globalProcessID;
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        long addressHashCode;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.util.ID");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        long time = System.currentTimeMillis();
        long nanoTime = System.nanoTime();
        long freeMemory = Runtime.getRuntime().freeMemory();
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            addressHashCode = inetAddress.getHostName().hashCode() ^ inetAddress.getHostAddress().hashCode();
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "Unable to get local host information.", err);
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.lobobrowser.util.ID");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            addressHashCode = clazz2.hashCode();
        }
        globalProcessID = time ^ nanoTime ^ freeMemory ^ addressHashCode;
        RANDOM1 = new Random(time);
        RANDOM2 = new Random(nanoTime);
        RANDOM3 = new Random(addressHashCode ^ freeMemory);
    }

    private ID() {
    }

    public static long generateLong() {
        return Math.abs(RANDOM1.nextLong() ^ RANDOM2.nextLong() ^ RANDOM3.nextLong());
    }

    public static int generateInt() {
        return (int)ID.generateLong();
    }

    public static byte[] getMD5Bytes(String content) {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return digest.digest(content.getBytes("UTF-8"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException(uee);
        }
    }

    public static String getHexString(byte[] bytes) {
        BigInteger bigInteger = BigInteger.ZERO;
        int shift = 0;
        int i = bytes.length;
        while (--i >= 0) {
            BigInteger contrib = BigInteger.valueOf(bytes[i] & 0xFF);
            contrib = contrib.shiftLeft(shift);
            bigInteger = bigInteger.add(contrib);
            shift += 8;
        }
        return bigInteger.toString(16).toUpperCase();
    }

    public static long getGlobalProcessID() {
        return globalProcessID;
    }

    public static int random(int min, int max) {
        if (max <= min) {
            return min;
        }
        return Math.abs(RANDOM1.nextInt()) % (max - min) + min;
    }
}

