/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.util.Collection;
import org.lobobrowser.util.BaseClassLoader;

public abstract class MultiplexClassLoader
extends BaseClassLoader {
    private static final BaseClassLoader[] EMPTY_CLASS_LOADERS = new BaseClassLoader[0];
    private final BaseClassLoader[] parentLoaders;

    public MultiplexClassLoader(Collection classLoaders) {
        super(null);
        this.parentLoaders = classLoaders.toArray(EMPTY_CLASS_LOADERS);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class c = this.findLoadedClass(name);
        if (c == null) {
            block10: {
                try {
                    int len = this.parentLoaders.length;
                    if (len == 0) {
                        c = this.findSystemClass(name);
                        break block10;
                    }
                    int i = 0;
                    while (i < len) {
                        BaseClassLoader parent = this.parentLoaders[i];
                        try {
                            c = parent.loadClass(name, false);
                            if (c != null) {
                                return c;
                            }
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        ++i;
                    }
                }
                catch (ClassNotFoundException e) {
                    c = this.findClass(name);
                }
            }
            if (c == null) {
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }
}

