/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.lobobrowser.util.FilteredCollection;
import org.lobobrowser.util.ObjectFilter;
import org.lobobrowser.util.Objects;

public class WeakValueHashMap
implements Map {
    private final Map map = new HashMap();
    private final ReferenceQueue queue = new ReferenceQueue();

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean containsKey(Object key) {
        WeakReference wf = (WeakReference)this.map.get(key);
        return wf != null && wf.get() != null;
    }

    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Object get(Object key) {
        this.checkQueue();
        WeakReference wf = (WeakReference)this.map.get(key);
        return wf == null ? null : wf.get();
    }

    public Object put(Object key, Object value) {
        if (value == null) {
            throw new IllegalArgumentException("null values not accepted");
        }
        this.checkQueue();
        LocalWeakReference ref = new LocalWeakReference(key, value, this.queue);
        WeakReference oldWf = this.map.put(key, ref);
        return oldWf == null ? null : oldWf.get();
    }

    public Object remove(Object key) {
        this.checkQueue();
        WeakReference wf = (WeakReference)this.map.remove(key);
        return wf == null ? null : wf.get();
    }

    public void putAll(Map t) {
        this.checkQueue();
        Iterator i = t.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void clear() {
        this.checkQueue();
        this.map.clear();
    }

    public Set keySet() {
        return this.map.keySet();
    }

    private final void checkQueue() {
        LocalWeakReference ref;
        ReferenceQueue queue = this.queue;
        while ((ref = (LocalWeakReference)queue.poll()) != null) {
            this.map.remove(ref.getKey());
        }
    }

    public Collection values() {
        return new FilteredCollection(this.map.values(), new LocalFilter());
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    private class LocalFilter
    implements ObjectFilter {
        private LocalFilter() {
        }

        public Object decode(Object source) {
            WeakReference wf = (WeakReference)source;
            return wf == null ? null : wf.get();
        }

        public Object encode(Object source) {
            throw new UnsupportedOperationException("Read-only collection.");
        }
    }

    private static class LocalWeakReference
    extends WeakReference {
        private final Object key;

        public LocalWeakReference(Object key, Object target, ReferenceQueue queue) {
            super(target, queue);
            this.key = key;
        }

        public Object getKey() {
            return this.key;
        }

        public boolean equals(Object other) {
            Object target1 = this.get();
            Object target2 = other instanceof LocalWeakReference ? ((LocalWeakReference)other).get() : null;
            return Objects.equals(target1, target2);
        }

        public int hashCode() {
            Object target = this.get();
            return target == null ? 0 : target.hashCode();
        }
    }
}

