/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.gui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ColorFactory {
    private static final Logger logger;
    public static final Color TRANSPARENT;
    private static ColorFactory instance;
    private final Map colorMap = new HashMap();
    private static final String RGB_START = "rgb(";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.util.gui.ColorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        TRANSPARENT = new Color(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ColorFactory() {
        Map colorMap = this.colorMap;
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            colorMap.put("transparent", new Color(0, 0, 0, 0));
            colorMap.put("black", Color.black);
            colorMap.put("blue", Color.blue);
            colorMap.put("cyan", Color.cyan);
            colorMap.put("darkGray", Color.darkGray);
            colorMap.put("gray", Color.gray);
            colorMap.put("green", new Color(0, 100, 0));
            colorMap.put("magenta", Color.magenta);
            colorMap.put("orange", Color.orange);
            colorMap.put("pink", Color.pink);
            colorMap.put("red", Color.red);
            colorMap.put("white", Color.white);
            colorMap.put("yellow", Color.yellow);
            colorMap.put("grey", new Color(50, 100, 0));
            colorMap.put("brown", new Color(100, 50, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ColorFactory getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lobobrowser.util.gui.ColorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new ColorFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isColor(String colorSpec) {
        if (colorSpec.startsWith("#")) {
            return true;
        }
        String normalSpec = colorSpec.toLowerCase();
        if (normalSpec.startsWith(RGB_START)) {
            return true;
        }
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            return this.colorMap.containsKey(normalSpec);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Color getColor(String colorSpec) {
        String normalSpec = colorSpec.toLowerCase();
        ColorFactory colorFactory = this;
        synchronized (colorFactory) {
            Color color = (Color)this.colorMap.get(normalSpec);
            if (color == null) {
                if (normalSpec.startsWith(RGB_START)) {
                    int endIdx = normalSpec.lastIndexOf(41);
                    String commaValues = endIdx == -1 ? normalSpec.substring(RGB_START.length()) : normalSpec.substring(RGB_START.length(), endIdx);
                    StringTokenizer tok = new StringTokenizer(commaValues, ",");
                    int r = 0;
                    int g = 0;
                    int b = 0;
                    if (tok.hasMoreTokens()) {
                        String rstr = tok.nextToken().trim();
                        try {
                            r = Integer.parseInt(rstr);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (tok.hasMoreTokens()) {
                            String gstr = tok.nextToken().trim();
                            try {
                                g = Integer.parseInt(gstr);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (tok.hasMoreTokens()) {
                                String bstr = tok.nextToken().trim();
                                try {
                                    b = Integer.parseInt(bstr);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    color = new Color(r, g, b);
                } else if (normalSpec.startsWith("#")) {
                    int len = normalSpec.length();
                    int[] rgba = new int[4];
                    rgba[3] = 255;
                    int i = 0;
                    while (i < rgba.length) {
                        int idx = 2 * i + 1;
                        if (idx < len) {
                            String hexText = normalSpec.substring(idx, idx + Math.min(2, len - idx));
                            try {
                                rgba[i] = Integer.parseInt(hexText, 16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        ++i;
                    }
                    color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
                } else {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.warning("getColor(): Color spec [" + normalSpec + "] unknown.");
                    }
                    return Color.RED;
                }
                this.colorMap.put(normalSpec, color);
            }
            return color;
        }
    }
}

