/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class RecordedInputStream
extends InputStream {
    private final InputStream delegate;
    private final ByteArrayOutputStream store = new ByteArrayOutputStream();
    private boolean hasReachedEOF = false;
    private int markPosition = -1;
    private int readPosition = -1;
    private byte[] resetBuffer = null;

    public RecordedInputStream(InputStream delegate) {
        this.delegate = delegate;
    }

    public int read() throws IOException {
        if (this.readPosition != -1 && this.readPosition < this.resetBuffer.length) {
            byte b = this.resetBuffer[this.readPosition];
            ++this.readPosition;
            return b;
        }
        int b = this.delegate.read();
        if (b != -1) {
            this.store.write(b);
        } else {
            this.hasReachedEOF = true;
        }
        return b;
    }

    public int available() throws IOException {
        return this.delegate.available();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int readlimit) {
        this.markPosition = this.store.size();
    }

    public synchronized void reset() throws IOException {
        int mp = this.markPosition;
        byte[] wholeBuffer = this.store.toByteArray();
        byte[] resetBuffer = new byte[wholeBuffer.length - mp];
        System.arraycopy(wholeBuffer, mp, resetBuffer, 0, resetBuffer.length);
        this.resetBuffer = resetBuffer;
        this.readPosition = 0;
    }

    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.readPosition != -1 && this.readPosition < this.resetBuffer.length) {
            int minLength = Math.min(this.resetBuffer.length - this.readPosition, length);
            System.arraycopy(this.resetBuffer, this.readPosition, buffer, offset, minLength);
            this.readPosition += minLength;
            return minLength;
        }
        int numRead = this.delegate.read(buffer, offset, length);
        if (numRead != -1) {
            this.store.write(buffer, offset, numRead);
        } else {
            this.hasReachedEOF = true;
        }
        return numRead;
    }

    public byte[] getBytesRead() {
        return this.store.toByteArray();
    }

    public String getString(String encoding) throws UnsupportedEncodingException {
        byte[] bytes = this.store.toByteArray();
        return new String(bytes, encoding);
    }

    public boolean hasReachedEOF() {
        return this.hasReachedEOF;
    }
}

