/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.io.Serializable;
import org.shiftone.jrat.util.log.Logger;

public class Accumulator
implements Serializable {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$Accumulator == null ? (class$org$shiftone$jrat$core$Accumulator = Accumulator.class$("org.shiftone.jrat.core.Accumulator")) : class$org$shiftone$jrat$core$Accumulator);
    private static final long serialVersionUID = 1L;
    private long totalEnters = 0L;
    private long totalExits = 0L;
    private long totalErrors = 0L;
    private long totalDuration = 0L;
    private long sumOfSquares = 0L;
    private long maxDuration = Long.MIN_VALUE;
    private long minDuration = Long.MAX_VALUE;
    private int concurThreads = 0;
    private int maxConcurrentThreads = 0;
    static /* synthetic */ Class class$org$shiftone$jrat$core$Accumulator;

    public Accumulator() {
    }

    public Accumulator(long totalEnters, long totalExits, long totalErrors, long totalDuration, long totalOfSquares, long maxDuration, long minDuration, int maxConcurThreads) {
        this.setStatistics(totalEnters, totalExits, totalErrors, totalDuration, totalOfSquares, maxDuration, minDuration, maxConcurThreads);
    }

    public void setStatistics(long totalEnters, long totalExits, long totalErrors, long totalDuration, long totalOfSquares, long maxDuration, long minDuration, int maxConcurThreads) {
        this.totalEnters = totalEnters;
        this.totalExits = totalExits;
        this.totalErrors = totalErrors;
        this.totalDuration = totalDuration;
        this.sumOfSquares = totalOfSquares;
        this.maxDuration = maxDuration;
        this.minDuration = minDuration;
        this.maxConcurrentThreads = maxConcurThreads;
    }

    public void combine(Accumulator accumulator) {
        this.totalEnters += accumulator.totalEnters;
        this.totalExits += accumulator.totalExits;
        this.totalErrors += accumulator.totalErrors;
        this.totalDuration += accumulator.totalDuration;
        this.sumOfSquares += accumulator.sumOfSquares;
        this.maxDuration = Math.max(this.maxDuration, accumulator.maxDuration);
        this.minDuration = Math.min(this.minDuration, accumulator.minDuration);
        this.concurThreads += accumulator.concurThreads;
        this.maxConcurrentThreads = Math.max(this.maxConcurrentThreads, accumulator.maxConcurrentThreads);
    }

    public synchronized void reset() {
        this.totalEnters = 0L;
        this.totalExits = 0L;
        this.totalErrors = 0L;
        this.totalDuration = 0L;
        this.sumOfSquares = 0L;
        this.maxDuration = 0L;
        this.minDuration = 0L;
        this.maxConcurrentThreads = this.concurThreads;
    }

    public final synchronized void onMethodStart() {
        ++this.totalEnters;
        ++this.concurThreads;
        if (this.concurThreads > this.maxConcurrentThreads) {
            this.maxConcurrentThreads = this.concurThreads;
        }
    }

    public final synchronized void onMethodFinish(long durationMs, boolean success) {
        ++this.totalExits;
        this.totalDuration += durationMs;
        this.sumOfSquares += durationMs * durationMs;
        if (!success) {
            ++this.totalErrors;
        }
        if (durationMs < this.minDuration) {
            this.minDuration = durationMs;
        }
        if (durationMs > this.maxDuration) {
            this.maxDuration = durationMs;
        }
        --this.concurThreads;
    }

    public final Double getAverageDuration() {
        Double average = null;
        if (this.totalExits > 0L) {
            average = new Double((double)this.totalDuration / (double)this.totalExits);
        }
        return average;
    }

    public final Double getStdDeviation() {
        Double stdDeviation = null;
        if (this.totalExits > 1L) {
            double numerator = (double)this.sumOfSquares - (double)(this.totalDuration * this.totalDuration) / (double)this.totalExits;
            double denominator = (double)this.totalExits - 1.0;
            stdDeviation = new Double(Math.sqrt(numerator / denominator));
        }
        return stdDeviation;
    }

    public long getTotalDuration() {
        return this.totalDuration;
    }

    public int getMaxConcurrentThreads() {
        return this.maxConcurrentThreads;
    }

    public long getSumOfSquares() {
        return this.sumOfSquares;
    }

    public final int getConcurrentThreads() {
        return this.concurThreads;
    }

    public long getTotalErrors() {
        return this.totalErrors;
    }

    public final long getTotalEnters() {
        return this.totalEnters;
    }

    public final long getTotalExits() {
        return this.totalExits;
    }

    public final long getMinDuration() {
        return this.minDuration;
    }

    public final long getMaxDuration() {
        return this.maxDuration;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

