/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class ClassKey
implements Serializable,
Comparable {
    private static final long serialVersionUID = 1L;
    private String packageName;
    private String className;
    private int hashCode;
    private static final Map CACHE = new HashMap();

    public static ClassKey getInstance(String fullyQualifiedClassName) {
        ClassKey classKey = (ClassKey)CACHE.get(fullyQualifiedClassName);
        if (classKey == null) {
            classKey = new ClassKey(fullyQualifiedClassName);
        }
        return classKey;
    }

    private ClassKey(String fullyQualifiedClassName) {
        int dot = fullyQualifiedClassName.lastIndexOf(46);
        this.packageName = dot == -1 ? "" : fullyQualifiedClassName.substring(0, dot).intern();
        this.className = dot == -1 ? fullyQualifiedClassName : fullyQualifiedClassName.substring(dot + 1);
        this.hashCode = this.packageName.hashCode();
        this.hashCode = 29 * this.hashCode + this.className.hashCode();
    }

    public String[] getPackageNameParts() {
        String[] result = new String[]{};
        if (this.packageName.length() != 0) {
            StringTokenizer st = new StringTokenizer(this.packageName, ".");
            ArrayList<String> parts = new ArrayList<String>();
            while (st.hasMoreTokens()) {
                parts.add(st.nextToken());
            }
            result = parts.toArray(new String[parts.size()]);
        }
        return result;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public final String getFullyQualifiedClassName() {
        return this.packageName.length() == 0 ? this.className : this.packageName + "." + this.className;
    }

    public String getClassName() {
        return this.className;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassKey)) {
            return false;
        }
        ClassKey other = (ClassKey)o;
        if (!other.equals(other)) {
            return false;
        }
        if (!this.className.equals(other.className)) {
            return false;
        }
        return this.packageName.equals(other.packageName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int compareTo(Object o) {
        ClassKey other = (ClassKey)o;
        int c = this.packageName.compareTo(other.packageName);
        if (c == 0) {
            c = this.className.compareTo(other.className);
        }
        return c;
    }
}

