/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Date;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.core.Mode;
import org.shiftone.jrat.core.config.Configuration;
import org.shiftone.jrat.core.config.ConfigurationParser;
import org.shiftone.jrat.core.config.Settings;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.io.ResourceUtil;
import org.shiftone.jrat.util.log.Logger;

public class Environment {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$Environment == null ? (class$org$shiftone$jrat$core$Environment = Environment.class$("org.shiftone.jrat.core.Environment")) : class$org$shiftone$jrat$core$Environment);
    private static final String CONFIG_FILE = "jrat.xml";
    private static final String DEFAULT_FILE = "org/shiftone/jrat/core/default-jrat.xml";
    public static final Environment INSTANCE = new Environment();
    private final Configuration configuration;
    static /* synthetic */ Class class$org$shiftone$jrat$core$Environment;

    public Environment() {
        if (Mode.get().isEnvironmentLoadingEnabled()) {
            File file = new File(CONFIG_FILE);
            byte[] configurationData = this.getConfigurationData(file);
            this.configuration = ConfigurationParser.parse(new ByteArrayInputStream(configurationData));
        } else {
            this.configuration = new Configuration();
        }
    }

    private byte[] getConfigurationData(File file) {
        if (!file.exists()) {
            LOG.info("Initializing configuration file with default...");
            LOG.info("Edit this file to further configure JRat.");
            this.copyDefaultFile(file);
        } else {
            LOG.info("Using existing configuration file.");
        }
        LOG.info("Loading JRat Configuration : " + file.getAbsolutePath() + "...");
        LOG.info("File was last modified " + new Date(file.lastModified()));
        return IOUtil.readAndClose(IOUtil.openInputStream(file));
    }

    private void copyDefaultFile(File file) {
        try {
            InputStream defaultStream = ResourceUtil.loadResourceAsStream(DEFAULT_FILE);
            FileOutputStream outputStream = new FileOutputStream(file);
            IOUtil.copy(defaultStream, outputStream);
        }
        catch (Exception e) {
            throw new JRatException("unable to copy default configuration file to : " + file.getAbsolutePath(), e);
        }
    }

    public static Configuration getConfiguration() {
        return Environment.INSTANCE.configuration;
    }

    public static Settings getSettings() {
        return Environment.getConfiguration().getSettings();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

