/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import org.shiftone.jrat.core.Environment;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.RuntimeContextImpl;
import org.shiftone.jrat.core.config.CacheMethodHandlerFactory;
import org.shiftone.jrat.core.config.ConfigMethodHandlerFactory;
import org.shiftone.jrat.core.spi.MethodHandler;
import org.shiftone.jrat.core.spi.MethodHandlerFactory;
import org.shiftone.jrat.provider.silent.SilentMethodHandler;
import org.shiftone.jrat.util.log.Logger;

public class HandlerFactory {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$HandlerFactory == null ? (class$org$shiftone$jrat$core$HandlerFactory = HandlerFactory.class$("org.shiftone.jrat.core.HandlerFactory")) : class$org$shiftone$jrat$core$HandlerFactory);
    static /* synthetic */ Class class$org$shiftone$jrat$core$HandlerFactory;

    public static void initialize() {
        Singleton.initialize();
    }

    public static synchronized MethodHandler getMethodHandler(MethodKey methodKey) {
        return Singleton.getMethodHandler(methodKey);
    }

    public static synchronized MethodHandler getMethodHandler(String className, String methodName, String signature) {
        return Singleton.getMethodHandler(MethodKey.getInstance(className, methodName, signature));
    }

    public static synchronized MethodHandler getMethodHandler(Class klass, String methodName, String signature) {
        return Singleton.getMethodHandler(MethodKey.getInstance(klass.getName(), methodName, signature));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Singleton {
        private static MethodHandlerFactory rootHandlerFactory;

        private Singleton() {
        }

        public static void initialize() {
        }

        public static synchronized MethodHandler getMethodHandler(MethodKey methodKey) {
            try {
                return rootHandlerFactory.createMethodHandler(methodKey);
            }
            catch (Exception e) {
                LOG.error("failed to column MethodHandler for : " + methodKey, e);
                return SilentMethodHandler.METHOD_HANDLER;
            }
        }

        static {
            try {
                rootHandlerFactory = new CacheMethodHandlerFactory(new ConfigMethodHandlerFactory(Environment.getConfiguration()));
                rootHandlerFactory.startup(new RuntimeContextImpl());
            }
            catch (Exception e) {
                rootHandlerFactory = SilentMethodHandler.HANDLER_FACTORY;
                LOG.error("There was an error starting up a handler factory", e);
                LOG.info("JRat will ignore all configuration and use the slient handler");
            }
        }
    }
}

