/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.io.Writer;
import org.shiftone.jrat.core.shutdown.ShutdownListener;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class MemoryMonitor
implements ShutdownListener {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$MemoryMonitor == null ? (class$org$shiftone$jrat$core$MemoryMonitor = MemoryMonitor.class$("org.shiftone.jrat.core.MemoryMonitor")) : class$org$shiftone$jrat$core$MemoryMonitor);
    private final RuntimeContext context;
    private final Writer writer;
    private final Thread thread;
    private static final Runtime RT = Runtime.getRuntime();
    private volatile boolean running = true;
    static /* synthetic */ Class class$org$shiftone$jrat$core$MemoryMonitor;

    public MemoryMonitor(RuntimeContext context) {
        this.context = context;
        this.writer = context.createWriter("memory.csv");
        this.thread = new Thread(new Ticker());
        this.thread.setDaemon(true);
        this.thread.setName("Memory Ticker");
        this.thread.setPriority(4);
        this.thread.start();
        context.registerShutdownListener(this);
    }

    public void shutdown() throws InterruptedException {
        this.running = false;
        this.thread.join(10000L);
    }

    private void header() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append("time ms");
        sb.append(",");
        sb.append("free");
        sb.append(",");
        sb.append("max");
        sb.append(",");
        sb.append("total");
        sb.append("\n");
        this.writer.write(sb.toString());
    }

    private void execute() throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(System.currentTimeMillis() - this.context.getStartTimeMs());
        sb.append(",");
        sb.append(RT.freeMemory());
        sb.append(",");
        sb.append(RT.maxMemory());
        sb.append(",");
        sb.append(RT.totalMemory());
        sb.append("\n");
        this.writer.write(sb.toString());
        this.writer.flush();
    }

    public String toString() {
        return "Memory Monitor";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Ticker
    implements Runnable {
        private Ticker() {
        }

        public void run() {
            try {
                MemoryMonitor.this.header();
                while (MemoryMonitor.this.running) {
                    MemoryMonitor.this.execute();
                    Thread.sleep(1000L);
                }
            }
            catch (Exception e) {
                MemoryMonitor.this.running = false;
            }
            IOUtil.close(MemoryMonitor.this.writer);
        }
    }
}

