/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.io.Serializable;
import java.util.Map;
import java.util.WeakHashMap;
import org.shiftone.jrat.core.ClassKey;
import org.shiftone.jrat.core.Signature;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Logger;

public class MethodKey
implements Serializable,
Comparable {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$MethodKey == null ? (class$org$shiftone$jrat$core$MethodKey = MethodKey.class$("org.shiftone.jrat.core.MethodKey")) : class$org$shiftone$jrat$core$MethodKey);
    private static final long serialVersionUID = 1L;
    private ClassKey classKey = null;
    private String methodName = null;
    private String signature = null;
    private int hashCode = 0;
    private transient String toStringValue = null;
    private transient Signature sig = null;
    private static Map CACHE = new WeakHashMap();
    static /* synthetic */ Class class$org$shiftone$jrat$core$MethodKey;

    public static MethodKey getInstance(String fullyQualifiedClassName, String methodName, String signature) {
        ClassKey classKey = ClassKey.getInstance(fullyQualifiedClassName);
        MethodKey key = new MethodKey(classKey, methodName, signature);
        MethodKey value = (MethodKey)CACHE.get(key);
        if (value == null) {
            CACHE.put(key, key);
            value = key;
        }
        return value;
    }

    private MethodKey() {
    }

    private MethodKey(ClassKey classKey, String methodName, String signature) {
        Assert.assertNotNull("classKey", classKey);
        Assert.assertNotNull("methodName", methodName);
        Assert.assertNotNull("signature", signature);
        this.classKey = classKey;
        this.methodName = methodName;
        this.signature = signature;
        this.hashCode = classKey.hashCode();
        this.hashCode = 29 * this.hashCode + methodName.hashCode();
        this.hashCode = 29 * this.hashCode + signature.hashCode();
    }

    public final String getShortMethodDescription() {
        return this.methodName + "(" + this.getSig().getShortText() + ")";
    }

    public final String getMethodName() {
        return this.methodName;
    }

    public final String getSignature() {
        return this.signature;
    }

    public String getPackageName() {
        return this.classKey.getPackageName();
    }

    public String[] getPackageNameParts() {
        return this.classKey.getPackageNameParts();
    }

    public final String getFullyQualifiedClassName() {
        return this.classKey.getFullyQualifiedClassName();
    }

    public final String getClassName() {
        return this.classKey.getClassName();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodKey)) {
            return false;
        }
        MethodKey other = (MethodKey)o;
        if (!this.classKey.equals(this.classKey)) {
            return false;
        }
        if (!this.methodName.equals(other.methodName)) {
            return false;
        }
        return this.signature.equals(other.signature);
    }

    public final String toString() {
        if (this.toStringValue == null) {
            this.toStringValue = this.classKey.getClassName() + '.' + this.methodName + this.getPrettySignature();
        }
        return this.toStringValue;
    }

    public Signature getSig() {
        if (this.sig == null) {
            this.sig = new Signature(this.signature);
        }
        return this.sig;
    }

    public int compareTo(Object o) {
        MethodKey other = (MethodKey)o;
        int c = this.classKey.compareTo(other.classKey);
        if (c == 0 && (c = this.methodName.compareTo(other.methodName)) == 0) {
            c = this.signature.compareTo(other.signature);
        }
        return c;
    }

    public final String getPrettySignature() {
        return "(" + this.getSig().getShortText() + ")";
    }

    public final int hashCode() {
        return this.hashCode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

