/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.shiftone.jrat.core.MemoryMonitor;
import org.shiftone.jrat.core.ServiceFactory;
import org.shiftone.jrat.core.command.CommandletRegistry;
import org.shiftone.jrat.core.jmx.JmxRegistry;
import org.shiftone.jrat.core.output.OutputDirectory;
import org.shiftone.jrat.core.shutdown.ShutdownListener;
import org.shiftone.jrat.core.shutdown.ShutdownRegistry;
import org.shiftone.jrat.core.spi.Commandlet;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.util.AtomicLong;
import org.shiftone.jrat.util.VersionUtil;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;
import org.shiftone.jrat.util.log.LoggerFactory;

class RuntimeContextImpl
implements RuntimeContext {
    protected static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$RuntimeContextImpl == null ? (class$org$shiftone$jrat$core$RuntimeContextImpl = RuntimeContextImpl.class$("org.shiftone.jrat.core.RuntimeContextImpl")) : class$org$shiftone$jrat$core$RuntimeContextImpl);
    private final AtomicLong sequence = new AtomicLong();
    private final long startTimeMs = System.currentTimeMillis();
    private final ShutdownRegistry shutdownRegistry;
    private final JmxRegistry jmxRegistry;
    private final CommandletRegistry commandletRegistry;
    private final OutputDirectory outputDirectory;
    private final Properties systemPropertiesAtStartup;
    private final MemoryMonitor memoryMonitor;
    static /* synthetic */ Class class$org$shiftone$jrat$core$RuntimeContextImpl;

    RuntimeContextImpl() {
        LOG.info("new");
        ServiceFactory serviceFactory = ServiceFactory.getInstance();
        this.outputDirectory = OutputDirectory.create(serviceFactory.getFileOutputFactory());
        this.shutdownRegistry = serviceFactory.getShutdownRegistry();
        this.jmxRegistry = serviceFactory.getJmxRegistry();
        this.commandletRegistry = serviceFactory.getCommandletRegistry();
        this.memoryMonitor = new MemoryMonitor(this);
        this.systemPropertiesAtStartup = new Properties();
        this.systemPropertiesAtStartup.putAll((Map<?, ?>)System.getProperties());
        this.redirectLogStream();
    }

    public Properties getSystemPropertiesAtStartup() {
        return this.systemPropertiesAtStartup;
    }

    public String getHostAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public String getHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            return "unknown";
        }
    }

    public long getStartTimeMs() {
        return this.startTimeMs;
    }

    public void registerMBean(Object mbean) {
        this.registerMBean(mbean, null);
    }

    public void registerMBean(Object mbean, String objectNameText) {
        this.jmxRegistry.registerMBean(mbean, objectNameText);
    }

    public void register(Commandlet commandlet) {
        this.commandletRegistry.register(commandlet);
    }

    private void redirectLogStream() {
        try {
            PrintWriter printWriter = this.outputDirectory.createPrintWriter("jrat.log");
            LoggerFactory.redirectLogging(printWriter);
            LOG.info("logfile created");
            LOG.info("Running JRat version " + VersionUtil.getVersion() + " - built on " + VersionUtil.getBuiltOn());
        }
        catch (Exception e) {
            LOG.warn("unable to redirect LOG to file", e);
        }
    }

    public PrintWriter createPrintWriter(String fileName) {
        return this.outputDirectory.createPrintWriter(fileName);
    }

    public OutputStream createOutputStream(String fileName) {
        return this.outputDirectory.createOutputStream(fileName);
    }

    public Writer createWriter(String fileName) {
        return this.outputDirectory.createWriter(fileName);
    }

    public synchronized long uniqNumber() {
        return this.sequence.incrementAndGet();
    }

    public void registerShutdownListener(ShutdownListener listener) {
        this.shutdownRegistry.registerShutdownListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSerializable(String fileName, Serializable serializable) {
        OutputStream outputStream = this.createOutputStream(fileName);
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = new GZIPOutputStream(outputStream);
            objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception e) {
            try {
                LOG.error("unable to write object '" + serializable + "' to file : " + fileName, e);
            }
            catch (Throwable throwable) {
                IOUtil.close(objectOutputStream);
                throw throwable;
            }
            IOUtil.close(objectOutputStream);
        }
        IOUtil.close(objectOutputStream);
    }

    public String toString() {
        return "RuntimeContextImpl created @ " + this.startTimeMs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

