/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Logger;

public class Signature {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$Signature == null ? (class$org$shiftone$jrat$core$Signature = Signature.class$("org.shiftone.jrat.core.Signature")) : class$org$shiftone$jrat$core$Signature);
    private static Map PRIM_CODES = new HashMap();
    private String returnType;
    private List parameterTypes = new ArrayList(5);
    static /* synthetic */ Class class$org$shiftone$jrat$core$Signature;

    public Signature(String descriptors) {
        this.parseSig(new CharacterIterator(descriptors));
    }

    public String getReturnType() {
        return this.returnType;
    }

    public int getParameterCount() {
        return this.parameterTypes.size();
    }

    public String getParameterType(int index) {
        return (String)this.parameterTypes.get(index);
    }

    public String getShortParameterType(int index) {
        String type = this.getParameterType(index);
        int dotIndex = type.lastIndexOf(46);
        if (dotIndex != -1) {
            type = type.substring(dotIndex + 1);
        }
        return type;
    }

    public String getShortText() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.getShortParameterType(i));
        }
        return sb.toString();
    }

    public String getLongText() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.getParameterCount(); ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(this.getParameterType(i));
        }
        return sb.toString();
    }

    private void parseSig(CharacterIterator in) {
        Assert.assertTrue("first char is (", in.next() && in.get() == '(');
        boolean inParams = true;
        while (in.next()) {
            char c = in.get();
            if (c == ')') {
                inParams = false;
            }
            if (inParams) {
                this.parameterTypes.add(this.parseType(in));
                continue;
            }
            this.returnType = this.parseType(in);
        }
    }

    private String parseType(CharacterIterator in) {
        char c = in.get();
        if (c == 'L') {
            return this.parseClassType(in);
        }
        if (c == '[') {
            return this.parseArrayType(in);
        }
        return (String)PRIM_CODES.get(String.valueOf(c));
    }

    private String parseArrayType(CharacterIterator in) {
        StringBuffer sb = new StringBuffer("[]");
        while (in.next() && in.get() == '[') {
            sb.append("[]");
        }
        sb.insert(0, this.parseType(in));
        return sb.toString();
    }

    private String parseClassType(CharacterIterator in) {
        char c;
        StringBuffer className = new StringBuffer();
        while (in.next() && (c = in.get()) != ';') {
            if (c == '/') {
                className.append('.');
                continue;
            }
            className.append(c);
        }
        return className.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PRIM_CODES.put("Z", "boolean");
        PRIM_CODES.put("B", "byte");
        PRIM_CODES.put("C", "char");
        PRIM_CODES.put("D", "double");
        PRIM_CODES.put("F", "float");
        PRIM_CODES.put("I", "int");
        PRIM_CODES.put("J", "long");
        PRIM_CODES.put("S", "short");
        PRIM_CODES.put("V", "void");
    }

    private static class CharacterIterator {
        private char[] chars;
        private int pos = -1;
        private char current;

        public CharacterIterator(String text) {
            this.chars = text.toCharArray();
        }

        public CharacterIterator(char[] chars) {
            this.chars = chars;
        }

        public boolean next() {
            ++this.pos;
            if (this.pos >= this.chars.length) {
                return false;
            }
            this.current = this.chars[this.pos];
            return true;
        }

        public char get() {
            return this.current;
        }
    }
}

