/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import org.shiftone.jrat.core.command.CommandletRegistry;
import org.shiftone.jrat.core.spi.Commandlet;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class TinyWebServer
extends Thread {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$command$TinyWebServer == null ? (class$org$shiftone$jrat$core$command$TinyWebServer = TinyWebServer.class$("org.shiftone.jrat.core.command.TinyWebServer")) : class$org$shiftone$jrat$core$command$TinyWebServer);
    private ServerSocket serverSocket = null;
    private int flushNumber;
    private final CommandletRegistry registry;
    private final int port;
    static /* synthetic */ Class class$org$shiftone$jrat$core$command$TinyWebServer;

    public TinyWebServer(CommandletRegistry registry, int port) {
        this.registry = registry;
        this.port = port;
        this.setDaemon(true);
        this.setName("HTTP");
    }

    private Commandlet readRequest(Socket socket) throws IOException {
        boolean doRefresh = false;
        InputStream inputStream = null;
        LineNumberReader reader = null;
        inputStream = socket.getInputStream();
        reader = new LineNumberReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        String commandletKey = null;
        int a = line.indexOf(32);
        int b = line.lastIndexOf(32);
        String uri = line.substring(a + 1, b);
        LOG.info("LINE = " + line + ">" + uri + "<");
        int commandletIndex = uri.indexOf("commandlet=");
        if (commandletIndex != -1) {
            commandletKey = uri.substring(commandletIndex + 11);
            LOG.info("commandletKey = " + commandletKey);
        }
        while (line != null && line.length() > 0) {
            line = reader.readLine();
        }
        Commandlet commandlet = null;
        if (commandletKey != null) {
            commandlet = (Commandlet)this.registry.getCommandlets().get(commandletKey);
        }
        if (commandlet == null) {
            LOG.warn("line(" + line + ") using default key");
            commandlet = this.registry.getDefaultCommandlet();
        }
        return commandlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Socket socket = null;
        OutputStream outputStream = null;
        OutputStreamWriter writer = null;
        try {
            LOG.info("starting on port " + this.port + "...");
            this.serverSocket = new ServerSocket(this.port);
            while (true) {
                socket = this.serverSocket.accept();
                LOG.info("accept");
                try {
                    outputStream = socket.getOutputStream();
                    writer = new OutputStreamWriter(outputStream);
                    long start = System.currentTimeMillis();
                    ++this.flushNumber;
                    Commandlet commandlet = this.readRequest(socket);
                    writer.write("HTTP/1.1 200 OK\n");
                    writer.write("Content-Type: " + commandlet.getContentType() + "\n");
                    writer.write("Cache-Control: no-store, no-cache, must-revalidate\n");
                    writer.write("Cache-Control: post-check=0, pre-check=0");
                    writer.write("Pragma: no-cache\n");
                    writer.write("Expires: Sat, 6 May 1995 12:00:00 GMT\n");
                    writer.write("\n");
                    ((Writer)writer).flush();
                    commandlet.execute(outputStream);
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        LOG.error("Flush error", e);
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(writer);
                        IOUtil.close(outputStream);
                        IOUtil.close(socket);
                        throw throwable;
                    }
                    IOUtil.close(writer);
                    IOUtil.close(outputStream);
                    IOUtil.close(socket);
                    continue;
                }
                IOUtil.close(writer);
                IOUtil.close(outputStream);
                IOUtil.close(socket);
                continue;
                break;
            }
        }
        catch (Exception e) {
            LOG.error("unable to listen on port : " + this.port, e);
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

