/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.shiftone.jrat.core.MethodKey;
import org.shiftone.jrat.core.config.CompositeMethodHandler;
import org.shiftone.jrat.core.config.Configuration;
import org.shiftone.jrat.core.config.Handler;
import org.shiftone.jrat.core.config.Profile;
import org.shiftone.jrat.core.criteria.MethodCriteria;
import org.shiftone.jrat.core.spi.MethodHandler;
import org.shiftone.jrat.core.spi.MethodHandlerFactory;
import org.shiftone.jrat.core.spi.RuntimeContext;
import org.shiftone.jrat.provider.silent.SilentMethodHandler;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.log.Logger;

public class ConfigMethodHandlerFactory
implements MethodHandlerFactory {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$config$ConfigMethodHandlerFactory == null ? (class$org$shiftone$jrat$core$config$ConfigMethodHandlerFactory = ConfigMethodHandlerFactory.class$("org.shiftone.jrat.core.config.ConfigMethodHandlerFactory")) : class$org$shiftone$jrat$core$config$ConfigMethodHandlerFactory);
    private final List profileFactories = new ArrayList();
    static /* synthetic */ Class class$org$shiftone$jrat$core$config$ConfigMethodHandlerFactory;

    public ConfigMethodHandlerFactory(Configuration configuration) {
        List profiles = configuration.getProfiles();
        for (int p = 0; p < profiles.size(); ++p) {
            Profile profile = (Profile)profiles.get(p);
            String profileName = profile.getName() != null ? "'" + profile.getName() + "'" : String.valueOf(p);
            LOG.info("Loading profile " + profileName + "...");
            List factories = profile.getFactories();
            for (int f = 0; f < factories.size(); ++f) {
                Handler handler = (Handler)factories.get(f);
                String factoryName = profileName + ", factory " + f + " (" + handler.getClassName() + ")";
                LOG.info("Loading factory " + handler + "...");
                try {
                    this.profileFactories.add(new FactoryInstance(handler.buildMethodHandlerFactory(), profile));
                    continue;
                }
                catch (Exception e) {
                    LOG.error("There was an error loading factory " + factoryName, e);
                    LOG.info("Execution will proceed, however this factory will not receieve events.");
                }
            }
        }
    }

    public MethodHandler createMethodHandler(MethodKey methodKey) throws Exception {
        ArrayList methodHandlers = new ArrayList();
        Iterator iterator = this.profileFactories.iterator();
        while (iterator.hasNext()) {
            FactoryInstance factoryInstance = (FactoryInstance)iterator.next();
            factoryInstance.addHandlerIfApplicable(methodHandlers, methodKey);
        }
        if (methodHandlers.isEmpty()) {
            return SilentMethodHandler.METHOD_HANDLER;
        }
        if (methodHandlers.size() == 1) {
            return (MethodHandler)methodHandlers.get(0);
        }
        return new CompositeMethodHandler(methodHandlers);
    }

    public void startup(RuntimeContext context) throws Exception {
        LOG.info("startup");
        Iterator iterator = this.profileFactories.iterator();
        while (iterator.hasNext()) {
            FactoryInstance factoryInstance = (FactoryInstance)iterator.next();
            factoryInstance.methodHandlerFactory.startup(context);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FactoryInstance {
        private final MethodHandlerFactory methodHandlerFactory;
        private final MethodCriteria methodCriteria;

        public FactoryInstance(MethodHandlerFactory methodHandlerFactory, MethodCriteria methodCriteria) {
            Assert.assertNotNull(methodHandlerFactory);
            Assert.assertNotNull(methodCriteria);
            this.methodHandlerFactory = methodHandlerFactory;
            this.methodCriteria = methodCriteria;
        }

        public void addHandlerIfApplicable(Collection methodHandlers, MethodKey methodKey) throws Exception {
            if (this.methodCriteria.isMatch(methodKey.getClassName(), methodKey.getMethodName(), methodKey.getSignature(), 0L)) {
                methodHandlers.add(this.methodHandlerFactory.createMethodHandler(methodKey));
            }
        }
    }
}

