/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.config;

import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.shiftone.jrat.core.JRatException;
import org.shiftone.jrat.core.config.Configuration;
import org.shiftone.jrat.core.config.Handler;
import org.shiftone.jrat.core.config.Profile;
import org.shiftone.jrat.core.criteria.MatcherMethodCriteria;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.PropertyUtil;
import org.shiftone.jrat.util.log.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ConfigurationParser {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$config$ConfigurationParser == null ? (class$org$shiftone$jrat$core$config$ConfigurationParser = ConfigurationParser.class$("org.shiftone.jrat.core.config.ConfigurationParser")) : class$org$shiftone$jrat$core$config$ConfigurationParser);
    static /* synthetic */ Class class$org$shiftone$jrat$core$config$ConfigurationParser;

    public static Configuration parse(InputStream in) {
        ConfigurationParser parser = new ConfigurationParser();
        Configuration configuration = new Configuration();
        parser.parse(configuration, in);
        return configuration;
    }

    public void parse(Configuration configuration, InputStream in) {
        LOG.info("parsing configuration...");
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(in);
            this.processJrat(configuration, document.getDocumentElement());
        }
        catch (Exception e) {
            throw new JRatException("failed to parse configuration", e);
        }
    }

    private void processJrat(Configuration configuration, Element jratElement) {
        Assert.assertNotNull(jratElement);
        NodeList settings = jratElement.getElementsByTagName("settings");
        for (int i = 0; i < settings.getLength(); ++i) {
            this.processSettings(configuration, (Element)settings.item(i));
        }
        NodeList handlers = jratElement.getElementsByTagName("profile");
        for (int i = 0; i < handlers.getLength(); ++i) {
            this.processProfile(configuration.createProfile(), (Element)handlers.item(i));
        }
    }

    private void processSettings(Configuration configuration, Element settingsElement) {
        Assert.assertNotNull(settingsElement);
        NodeList properties = settingsElement.getElementsByTagName("property");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < properties.getLength(); ++i) {
            Element propertyElement = (Element)properties.item(i);
            map.put(propertyElement.getAttribute("name"), propertyElement.getAttribute("value"));
        }
        PropertyUtil.setProperties(configuration.getSettings(), map);
    }

    private void processProfile(Profile profile, Element profileElement) {
        Assert.assertNotNull(profileElement);
        profile.setName(profileElement.getAttribute("name"));
        NodeList includes = profileElement.getElementsByTagName("include");
        for (int i = 0; i < includes.getLength(); ++i) {
            this.processCriteria(profile.createInclude(), (Element)includes.item(i));
        }
        NodeList excludes = profileElement.getElementsByTagName("exclude");
        for (int i = 0; i < excludes.getLength(); ++i) {
            this.processCriteria(profile.createExclude(), (Element)excludes.item(i));
        }
        NodeList handlers = profileElement.getElementsByTagName("handler");
        for (int i = 0; i < handlers.getLength(); ++i) {
            this.processHandler(profile.createFactory(), (Element)handlers.item(i));
        }
    }

    private void processHandler(Handler handler, Element factoryElement) {
        handler.setClassName(factoryElement.getAttribute("factory"));
        NodeList properties = factoryElement.getElementsByTagName("property");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element property = (Element)properties.item(i);
            String name = this.nvl(property.getAttribute("name"));
            String value = this.nvl(property.getAttribute("value"));
            Assert.assertNotNull("name", name);
            handler.getProperties().put(name, value);
        }
    }

    private void processCriteria(MatcherMethodCriteria criteria, Element criteriaElement) {
        criteria.setClassName(this.nvl(criteriaElement.getAttribute("className")));
        criteria.setMethodName(this.nvl(criteriaElement.getAttribute("methodName")));
        criteria.setSignature(this.nvl(criteriaElement.getAttribute("signature")));
        LOG.info("processCriteria " + criteria);
    }

    private String nvl(String s) {
        if (s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

