/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.jmx;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.shiftone.jrat.core.Environment;
import org.shiftone.jrat.core.jmx.JmxRegistry;
import org.shiftone.jrat.util.log.Logger;

public class ServerJmxRegistry
implements JmxRegistry {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$jmx$ServerJmxRegistry == null ? (class$org$shiftone$jrat$core$jmx$ServerJmxRegistry = ServerJmxRegistry.class$("org.shiftone.jrat.core.jmx.ServerJmxRegistry")) : class$org$shiftone$jrat$core$jmx$ServerJmxRegistry);
    private MBeanServer mBeanServer;
    private String agentId = Environment.getSettings().getMBeanServerAgentId();
    public static final String JMX_INITIAL_BUILDER = "javax.management.builder.initial";
    static /* synthetic */ Class class$org$shiftone$jrat$core$jmx$ServerJmxRegistry;

    public ServerJmxRegistry(boolean create) throws Exception {
        if (create) {
            this.mBeanServer = ServerJmxRegistry.createMBeanServer();
        }
    }

    private static MBeanServer createMBeanServer() throws Exception {
        if (Environment.getSettings().isRmiRegistryCreationEnabled()) {
            int port = Environment.getSettings().getRmiRegistryPort();
            LOG.info("Creating local RMI jmx on port " + port + ".");
            Registry registry = LocateRegistry.createRegistry(port);
        }
        LOG.info("Creating MBeanServer (MBeanServerFactory will refer to property 'javax.management.builder.initial').");
        MBeanServer mBeanServer = MBeanServerFactory.createMBeanServer();
        String urlText = Environment.getSettings().getMBeanServerServerUrl();
        if (urlText != null) {
            JMXServiceURL url = new JMXServiceURL(urlText);
            LOG.info("Binding JMXConnectorServer to RMI jmx.");
            JMXConnectorServer connectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, mBeanServer);
            LOG.info("Starting JMXConnectorServer.");
            connectorServer.start();
        }
        return mBeanServer;
    }

    protected synchronized MBeanServer getMBeanServer() {
        if (this.mBeanServer == null) {
            ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(this.agentId);
            if (servers.size() == 0) {
                LOG.debug("No MBeanServers were found.");
                return null;
            }
            if (servers.size() > 1) {
                LOG.warn("More than one MBeanServers (" + servers.size() + ") was found with agentId='" + this.agentId + "'.  Returning first.");
            }
            this.mBeanServer = servers.get(0);
        }
        return this.mBeanServer;
    }

    public boolean isReady() {
        return this.getMBeanServer() != null;
    }

    public void registerMBean(Object object, String objectNameText) {
        LOG.debug("registerMBean...");
        MBeanServer server = this.getMBeanServer();
        if (server == null) {
            LOG.info("MBeanServer is not available");
            return;
        }
        if (objectNameText == null) {
            objectNameText = "shiftone.jrat:service=" + object.getClass().getName();
        }
        try {
            LOG.info("registerMBean " + object + " " + objectNameText);
            ObjectName objectName = new ObjectName(objectNameText);
            String domain = objectName.getDomain();
            Hashtable<String, String> properties = objectName.getKeyPropertyList();
            int index = 0;
            while (server.isRegistered(objectName)) {
                properties.put("index", String.valueOf(++index));
                objectName = new ObjectName(domain, properties);
            }
            server.registerMBean(object, objectName);
        }
        catch (Exception e) {
            LOG.warn("MBean registration failed", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

