/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.output;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.shiftone.jrat.core.Environment;
import org.shiftone.jrat.core.output.FileOutputRegistry;
import org.shiftone.jrat.util.io.nop.NullOutputStream;
import org.shiftone.jrat.util.io.nop.NullPrintWriter;
import org.shiftone.jrat.util.io.nop.NullWriter;
import org.shiftone.jrat.util.log.Logger;

public class FileOutputFactory {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$output$FileOutputFactory == null ? (class$org$shiftone$jrat$core$output$FileOutputFactory = FileOutputFactory.class$("org.shiftone.jrat.core.output.FileOutputFactory")) : class$org$shiftone$jrat$core$output$FileOutputFactory);
    private final FileOutputRegistry fileOutputRegistry;
    private final int bufferSize;
    static /* synthetic */ Class class$org$shiftone$jrat$core$output$FileOutputFactory;

    public FileOutputFactory(FileOutputRegistry fileOutputRegistry, int bufferSize) {
        this.fileOutputRegistry = fileOutputRegistry;
        this.bufferSize = bufferSize;
    }

    public FileOutputFactory(FileOutputRegistry fileOutputRegistry) {
        this(fileOutputRegistry, Environment.getSettings().getOutputBufferSize());
    }

    public OutputStream createOutputStreamSafely(File file) {
        try {
            return this.createOutputStream(file);
        }
        catch (Throwable e) {
            LOG.error("unable to column OutputStream for '" + file + "' return /dev/null");
            return NullOutputStream.INSTANCE;
        }
    }

    public Writer createWriterSafely(File file) {
        try {
            return this.createWriter(file);
        }
        catch (Throwable e) {
            LOG.error("unable to column Writer for '" + file + "' return /dev/null");
            return NullWriter.INSTANCE;
        }
    }

    public PrintWriter createPrintWriterSafely(File file) {
        try {
            return this.createPrintWriter(file);
        }
        catch (Throwable e) {
            LOG.error("unable to column PrintWriter for '" + file + "' return /dev/null");
            return NullPrintWriter.INSTANCE;
        }
    }

    public OutputStream createOutputStream(File file) throws IOException {
        LOG.info("createOutputStream " + file.getAbsolutePath());
        OutputStream out = this.internalCreateOutputStream(file);
        return this.fileOutputRegistry.add(out, file.getName());
    }

    public Writer createWriter(File file) throws IOException {
        LOG.info("createWriter " + file.getAbsolutePath());
        OutputStreamWriter out = new OutputStreamWriter(this.internalCreateOutputStream(file));
        return this.fileOutputRegistry.add(out, file.getName());
    }

    public PrintWriter createPrintWriter(File file) throws IOException {
        LOG.info("createPrintWriter " + file.getAbsolutePath());
        PrintWriter out = new PrintWriter(new OutputStreamWriter(this.internalCreateOutputStream(file)));
        return this.fileOutputRegistry.add(out, file.getName());
    }

    private OutputStream internalCreateOutputStream(File file) throws IOException {
        LOG.info("createOutputStream " + file.getAbsolutePath());
        File parent = file.getParentFile();
        if (!parent.exists()) {
            LOG.info("creating parent directory : " + parent.getAbsolutePath());
            parent.mkdirs();
        }
        OutputStream out = new FileOutputStream(file);
        if (this.bufferSize > 0) {
            out = new BufferedOutputStream(out, this.bufferSize);
        }
        return out;
    }

    public String toString() {
        return "FileOutputFactory[" + this.fileOutputRegistry + "]";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

