/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.output;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Stack;
import org.shiftone.jrat.core.output.FileOutput;
import org.shiftone.jrat.core.output.FileOutputOutputStream;
import org.shiftone.jrat.core.output.FileOutputPrintWriter;
import org.shiftone.jrat.core.output.FileOutputRegistryMBean;
import org.shiftone.jrat.core.output.FileOutputWriter;
import org.shiftone.jrat.core.shutdown.ShutdownListener;
import org.shiftone.jrat.util.HtmlUtil;
import org.shiftone.jrat.util.log.Logger;

public class FileOutputRegistry
implements FileOutputRegistryMBean,
ShutdownListener {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$output$FileOutputRegistry == null ? (class$org$shiftone$jrat$core$output$FileOutputRegistry = FileOutputRegistry.class$("org.shiftone.jrat.core.output.FileOutputRegistry")) : class$org$shiftone$jrat$core$output$FileOutputRegistry);
    private Stack fileOutputs = new Stack();
    static /* synthetic */ Class class$org$shiftone$jrat$core$output$FileOutputRegistry;

    public int getRegisteredFileOutputCount() {
        return this.fileOutputs.size();
    }

    public String getRegisteredFileOutputsHtml() {
        return HtmlUtil.toHtml(this.fileOutputs);
    }

    public synchronized OutputStream add(OutputStream outputStream, String title) {
        return (OutputStream)((Object)this.add(new FileOutputOutputStream(this, outputStream, title)));
    }

    public synchronized Writer add(Writer writer, String title) {
        return (Writer)((Object)this.add(new FileOutputWriter(this, writer, title)));
    }

    public synchronized PrintWriter add(PrintWriter printWriter, String title) {
        return (PrintWriter)((Object)this.add(new FileOutputPrintWriter(this, printWriter, title)));
    }

    public synchronized FileOutput add(FileOutput fileOutput) {
        LOG.info("add " + fileOutput);
        this.fileOutputs.push(fileOutput);
        return fileOutput;
    }

    synchronized void remove(FileOutput fileOutput) {
        LOG.info("remove " + fileOutput);
        this.fileOutputs.remove(fileOutput);
    }

    public synchronized void closeFileOutputs() {
        LOG.info("closeFileOutputs " + this.fileOutputs);
        while (!this.fileOutputs.isEmpty()) {
            FileOutputRegistry.close((FileOutput)this.fileOutputs.pop());
        }
    }

    public synchronized void flushFileOutputs() {
        LOG.info("flushFileOutputs " + this.fileOutputs);
        Iterator iterator = this.fileOutputs.iterator();
        while (iterator.hasNext()) {
            FileOutputRegistry.flush((FileOutput)iterator.next());
        }
    }

    public static void close(FileOutput fileOutput) {
        if (fileOutput != null) {
            try {
                LOG.info("closing : " + fileOutput);
                fileOutput.close();
            }
            catch (Throwable e) {
                LOG.error("unable to close " + fileOutput, e);
            }
        }
    }

    public static void flush(FileOutput fileOutput) {
        if (fileOutput != null) {
            try {
                LOG.info("flushing : " + fileOutput);
                fileOutput.flush();
            }
            catch (Throwable e) {
                LOG.error("unable to flush " + fileOutput, e);
            }
        }
    }

    public void shutdown() {
        this.closeFileOutputs();
    }

    public String toString() {
        return "FileOutputRegistry" + this.fileOutputs;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

