/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.output;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.shiftone.jrat.core.Environment;
import org.shiftone.jrat.core.output.FileOutputFactory;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.AtomicLong;
import org.shiftone.jrat.util.io.Dir;
import org.shiftone.jrat.util.io.IOUtil;
import org.shiftone.jrat.util.log.Logger;

public class OutputDirectory {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$output$OutputDirectory == null ? (class$org$shiftone$jrat$core$output$OutputDirectory = OutputDirectory.class$("org.shiftone.jrat.core.output.OutputDirectory")) : class$org$shiftone$jrat$core$output$OutputDirectory);
    private final List fileList = new ArrayList(10);
    private final NumberFormat fileSeqFormat = new DecimalFormat("000");
    private final AtomicLong fileSequence = new AtomicLong();
    private final FileOutputFactory outputFactory;
    private final Dir outputDir;
    static /* synthetic */ Class class$org$shiftone$jrat$core$output$OutputDirectory;

    public OutputDirectory(FileOutputFactory outputFactory, Dir outputDir) {
        Assert.assertTrue(outputDir + ".exists()", outputDir.exists());
        Assert.assertTrue(outputDir + ".isDirectory()", outputDir.isDirectory());
        this.outputFactory = outputFactory;
        this.outputDir = outputDir;
    }

    public static OutputDirectory create(FileOutputFactory outputFactory) {
        return new OutputDirectory(outputFactory, OutputDirectory.createOutputDir());
    }

    private static Dir createOutputDir() {
        String applicationName = Environment.getSettings().getApplicationName();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd_a-hh-mm-ss");
        Dir parent = Environment.getSettings().getBaseDirectory();
        if (applicationName != null) {
            parent = parent.createChildDir(applicationName);
        }
        parent.make();
        Dir outputDir = null;
        for (int maxAttempts = 100; outputDir == null && maxAttempts > 0; --maxAttempts) {
            try {
                Dir dir = parent.createChildDir(format.format((Object)new Date()));
                dir.make();
                outputDir = dir;
                continue;
            }
            catch (Exception e) {
                OutputDirectory.pause();
            }
        }
        LOG.info("output DIR = " + outputDir);
        return outputDir;
    }

    private static void pause() {
        try {
            Thread.sleep(50L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized File createFile(String fileName) {
        Assert.assertNotNull("fileName", fileName);
        File file = this.outputDir.createChild(fileName);
        int i = 2;
        while (file.exists()) {
            file = this.outputDir.createChild(i + "_" + fileName);
            ++i;
        }
        IOUtil.createNewFile(file);
        this.fileList.add(file);
        return file;
    }

    public PrintWriter createPrintWriter(String fileName) {
        return this.outputFactory.createPrintWriterSafely(this.createFile(fileName));
    }

    public OutputStream createOutputStream(String fileName) {
        return this.outputFactory.createOutputStreamSafely(this.createFile(fileName));
    }

    public Writer createWriter(String fileName) {
        return this.outputFactory.createWriterSafely(this.createFile(fileName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

