/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.core.shutdown;

import java.util.Stack;
import org.shiftone.jrat.core.shutdown.ShutdownListener;
import org.shiftone.jrat.core.shutdown.ShutdownRegistryMBean;
import org.shiftone.jrat.util.Assert;
import org.shiftone.jrat.util.HtmlUtil;
import org.shiftone.jrat.util.log.Logger;

public class ShutdownRegistry
implements ShutdownRegistryMBean {
    private static final Logger LOG = Logger.getLogger(class$org$shiftone$jrat$core$shutdown$ShutdownRegistry == null ? (class$org$shiftone$jrat$core$shutdown$ShutdownRegistry = ShutdownRegistry.class$("org.shiftone.jrat.core.shutdown.ShutdownRegistry")) : class$org$shiftone$jrat$core$shutdown$ShutdownRegistry);
    private Stack shutdownStack = new Stack();
    private ShutdownListener firstShutdownListener;
    static /* synthetic */ Class class$org$shiftone$jrat$core$shutdown$ShutdownRegistry;

    public ShutdownRegistry() {
        LOG.info("new");
        Thread shutdownHook = new Thread((Runnable)new ShutdownRunnable(), "JRat-Shutdown");
        shutdownHook.setDaemon(true);
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    public void setFirstShutdownListener(ShutdownListener firstShutdownListener) {
        this.firstShutdownListener = firstShutdownListener;
    }

    public synchronized void registerShutdownListener(ShutdownListener shutdownListener) {
        LOG.info("registerShutdownListener " + shutdownListener);
        Assert.assertNotNull("ShutdownListener", shutdownListener);
        this.shutdownStack.push(shutdownListener);
    }

    private static void shutdown(ShutdownListener shutdownListener) {
        try {
            LOG.info("shutting down " + shutdownListener + "...");
            shutdownListener.shutdown();
            LOG.info("shutdown " + shutdownListener + " complete.");
        }
        catch (Throwable e) {
            LOG.error("shutdown failed for " + shutdownListener, e);
            e.printStackTrace(System.err);
        }
    }

    private synchronized void shutdown() {
        LOG.info("shutting down..." + this.shutdownStack);
        if (this.firstShutdownListener != null) {
            ShutdownRegistry.shutdown(this.firstShutdownListener);
        }
        while (!this.shutdownStack.isEmpty()) {
            ShutdownRegistry.shutdown((ShutdownListener)this.shutdownStack.pop());
        }
        LOG.info("shutdown complete.");
        this.shutdownStack.clear();
    }

    public int getShutdownListenerCount() {
        return this.shutdownStack.size();
    }

    public String getShutdownListenersHtml() {
        return HtmlUtil.toHtml(this.shutdownStack);
    }

    public void forceShutdownNow() {
        LOG.info("forceShutdownNow");
        this.shutdown();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ShutdownRunnable
    implements Runnable {
        private ShutdownRunnable() {
        }

        public void run() {
            ShutdownRegistry.this.shutdown();
        }
    }
}

