/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.asm.optimizer;

import org.shiftone.jrat.depends.asm.ClassWriter;

class Constant {
    char type;
    int intVal;
    long longVal;
    float floatVal;
    double doubleVal;
    String strVal1;
    String strVal2;
    String strVal3;
    int hashCode;

    public Constant() {
    }

    public Constant(Constant constant) {
        this.type = constant.type;
        this.intVal = constant.intVal;
        this.longVal = constant.longVal;
        this.floatVal = constant.floatVal;
        this.doubleVal = constant.doubleVal;
        this.strVal1 = constant.strVal1;
        this.strVal2 = constant.strVal2;
        this.strVal3 = constant.strVal3;
        this.hashCode = constant.hashCode;
    }

    void set(int n) {
        this.type = (char)73;
        this.intVal = n;
        this.hashCode = Integer.MAX_VALUE & this.type + n;
    }

    void set(long l) {
        this.type = (char)74;
        this.longVal = l;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)l;
    }

    void set(float f) {
        this.type = (char)70;
        this.floatVal = f;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)f;
    }

    void set(double d) {
        this.type = (char)68;
        this.doubleVal = d;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)d;
    }

    void set(char c, String string, String string2, String string3) {
        this.type = c;
        this.strVal1 = string;
        this.strVal2 = string2;
        this.strVal3 = string3;
        switch (c) {
            case 'C': 
            case 'S': 
            case 's': {
                this.hashCode = Integer.MAX_VALUE & c + string.hashCode();
                return;
            }
            case 'T': {
                this.hashCode = Integer.MAX_VALUE & c + string.hashCode() * string2.hashCode();
                return;
            }
        }
        this.hashCode = Integer.MAX_VALUE & c + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    void write(ClassWriter classWriter) {
        switch (this.type) {
            case 'I': {
                classWriter.newConst(new Integer(this.intVal));
                break;
            }
            case 'J': {
                classWriter.newConst(new Long(this.longVal));
                break;
            }
            case 'F': {
                classWriter.newConst(new Float(this.floatVal));
                break;
            }
            case 'D': {
                classWriter.newConst(new Double(this.doubleVal));
                break;
            }
            case 'S': {
                classWriter.newConst(this.strVal1);
                break;
            }
            case 's': {
                classWriter.newUTF8(this.strVal1);
                break;
            }
            case 'C': {
                classWriter.newClass(this.strVal1);
                break;
            }
            case 'T': {
                classWriter.newNameType(this.strVal1, this.strVal2);
                break;
            }
            case 'G': {
                classWriter.newField(this.strVal1, this.strVal2, this.strVal3);
                break;
            }
            case 'M': {
                classWriter.newMethod(this.strVal1, this.strVal2, this.strVal3, false);
                break;
            }
            case 'N': {
                classWriter.newMethod(this.strVal1, this.strVal2, this.strVal3, true);
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof Constant)) {
            return false;
        }
        Constant constant = (Constant)object;
        if (constant.type == this.type) {
            switch (this.type) {
                case 'I': {
                    return constant.intVal == this.intVal;
                }
                case 'J': {
                    return constant.longVal == this.longVal;
                }
                case 'F': {
                    return constant.floatVal == this.floatVal;
                }
                case 'D': {
                    return constant.doubleVal == this.doubleVal;
                }
                case 'C': 
                case 'S': 
                case 's': {
                    return constant.strVal1.equals(this.strVal1);
                }
                case 'T': {
                    return constant.strVal1.equals(this.strVal1) && constant.strVal2.equals(this.strVal2);
                }
            }
            return constant.strVal1.equals(this.strVal1) && constant.strVal2.equals(this.strVal2) && constant.strVal3.equals(this.strVal3);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

