/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.asm.optimizer;

import java.util.HashMap;
import org.shiftone.jrat.depends.asm.Type;
import org.shiftone.jrat.depends.asm.optimizer.Constant;

public class ConstantPool
extends HashMap {
    private Constant key1 = new Constant();
    private Constant key2 = new Constant();
    private Constant key3 = new Constant();

    public Constant newInteger(int n) {
        this.key1.set(n);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    public Constant newFloat(float f) {
        this.key1.set(f);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    public Constant newLong(long l) {
        this.key1.set(l);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    public Constant newDouble(double d) {
        this.key1.set(d);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    public Constant newUTF8(String string) {
        this.key1.set('s', string, null, null);
        Constant constant = this.get(this.key1);
        if (constant == null) {
            constant = new Constant(this.key1);
            this.put(constant);
        }
        return constant;
    }

    private Constant newString(String string) {
        this.key2.set('S', string, null, null);
        Constant constant = this.get(this.key2);
        if (constant == null) {
            this.newUTF8(string);
            constant = new Constant(this.key2);
            this.put(constant);
        }
        return constant;
    }

    public Constant newClass(String string) {
        this.key2.set('C', string, null, null);
        Constant constant = this.get(this.key2);
        if (constant == null) {
            this.newUTF8(string);
            constant = new Constant(this.key2);
            this.put(constant);
        }
        return constant;
    }

    public Constant newConst(Object object) {
        if (object instanceof Integer) {
            int n = (Integer)object;
            return this.newInteger(n);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            return this.newFloat(f);
        }
        if (object instanceof Long) {
            long l = (Long)object;
            return this.newLong(l);
        }
        if (object instanceof Double) {
            double d = (Double)object;
            return this.newDouble(d);
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.newClass(type.getSort() == 10 ? type.getInternalName() : type.getDescriptor());
        }
        throw new IllegalArgumentException("value " + object);
    }

    public Constant newField(String string, String string2, String string3) {
        this.key3.set('G', string, string2, string3);
        Constant constant = this.get(this.key3);
        if (constant == null) {
            this.newClass(string);
            this.newNameType(string2, string3);
            constant = new Constant(this.key3);
            this.put(constant);
        }
        return constant;
    }

    public Constant newMethod(String string, String string2, String string3, boolean bl) {
        this.key3.set(bl ? (char)'N' : 'M', string, string2, string3);
        Constant constant = this.get(this.key3);
        if (constant == null) {
            this.newClass(string);
            this.newNameType(string2, string3);
            constant = new Constant(this.key3);
            this.put(constant);
        }
        return constant;
    }

    public Constant newNameType(String string, String string2) {
        this.key2.set('T', string, string2, null);
        Constant constant = this.get(this.key2);
        if (constant == null) {
            this.newUTF8(string);
            this.newUTF8(string2);
            constant = new Constant(this.key2);
            this.put(constant);
        }
        return constant;
    }

    private Constant get(Constant constant) {
        return (Constant)this.get((Object)constant);
    }

    private void put(Constant constant) {
        this.put(constant, constant);
    }
}

