/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.asm.optimizer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class JarOptimizer {
    public static void main(String[] stringArray) throws IOException {
        File file = new File(stringArray[0]);
        JarOptimizer.optimize(file);
    }

    static void optimize(File file) throws IOException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                JarOptimizer.optimize(fileArray[i]);
            }
        } else if (file.getName().endsWith(".jar")) {
            File file2 = new File(file.getParentFile(), file.getName() + ".new");
            ZipFile zipFile = new ZipFile(file);
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            byte[] byArray = new byte[10000];
            while (enumeration.hasMoreElements()) {
                int n;
                ZipEntry zipEntry = enumeration.nextElement();
                if (zipEntry.isDirectory()) continue;
                zipOutputStream.putNextEntry(zipEntry);
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                do {
                    if ((n = inputStream.read(byArray, 0, byArray.length)) == -1) continue;
                    zipOutputStream.write(byArray, 0, n);
                } while (n != -1);
                zipOutputStream.closeEntry();
            }
            zipOutputStream.close();
            zipFile.close();
            file.delete();
            file2.renameTo(file);
        }
    }
}

