/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JXRadioGroup<T>
extends JPanel {
    private static final long serialVersionUID = 3257285842266567986L;
    private ButtonGroup buttonGroup;
    private final List<T> values = new ArrayList<T>();
    private ActionSelectionListener actionHandler;
    private List<ActionListener> actionListeners;

    public JXRadioGroup() {
        this.setLayout(new BoxLayout(this, 0));
        this.buttonGroup = new ButtonGroup();
    }

    public void setLayoutAxis(int axis) {
        this.setLayout(new BoxLayout(this, axis));
    }

    public static <T> JXRadioGroup<T> create(T[] radioValues) {
        return new JXRadioGroup<T>(radioValues);
    }

    public JXRadioGroup(T[] radioValues) {
        this();
        for (int i = 0; i < radioValues.length; ++i) {
            this.add(radioValues[i]);
        }
    }

    public void setValues(T[] radioValues) {
        this.clearAll();
        for (int i = 0; i < radioValues.length; ++i) {
            this.add(radioValues[i]);
        }
    }

    private void clearAll() {
        this.values.clear();
        this.buttonGroup = new ButtonGroup();
        this.removeAll();
    }

    public void add(T radioValue) {
        if (this.values.contains(radioValue)) {
            throw new IllegalArgumentException("cannot add the same value twice " + radioValue);
        }
        if (radioValue instanceof AbstractButton) {
            this.values.add(radioValue);
            this.addButton((AbstractButton)radioValue);
        } else {
            this.values.add(radioValue);
            this.addButton(new JRadioButton("" + radioValue));
        }
    }

    private void addButton(AbstractButton button) {
        this.buttonGroup.add(button);
        super.add(button);
        if (this.actionHandler == null) {
            this.actionHandler = new ActionSelectionListener();
        }
        button.addActionListener(this.actionHandler);
        button.addItemListener(this.actionHandler);
    }

    public AbstractButton getSelectedButton() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        AbstractButton[] children = this.getButtonComponents();
        for (int i = 0; i < children.length; ++i) {
            AbstractButton button = children[i];
            if (button.getModel() != selectedModel) continue;
            return button;
        }
        return null;
    }

    private AbstractButton[] getButtonComponents() {
        Component[] children = this.getComponents();
        ArrayList<AbstractButton> buttons = new ArrayList<AbstractButton>();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof AbstractButton)) continue;
            buttons.add((AbstractButton)children[i]);
        }
        return buttons.toArray(new AbstractButton[buttons.size()]);
    }

    private int getSelectedIndex() {
        ButtonModel selectedModel = this.buttonGroup.getSelection();
        AbstractButton[] children = this.getButtonComponents();
        for (int i = 0; i < children.length; ++i) {
            AbstractButton button = children[i];
            if (button.getModel() != selectedModel) continue;
            return i;
        }
        return -1;
    }

    public T getSelectedValue() {
        int index = this.getSelectedIndex();
        return index < 0 || index >= this.values.size() ? null : (T)this.values.get(index);
    }

    public void setSelectedValue(T value) {
        int index = this.values.indexOf(value);
        AbstractButton button = this.getButtonComponents()[index];
        button.setSelected(true);
    }

    public AbstractButton getChildButton(int index) {
        return this.getButtonComponents()[index];
    }

    public AbstractButton getChildButton(T value) {
        int index = this.values.indexOf(value);
        return this.getButtonComponents()[index];
    }

    public int getChildButtonCount() {
        return this.getButtonComponents().length;
    }

    public void addActionListener(ActionListener l) {
        if (this.actionListeners == null) {
            this.actionListeners = new ArrayList<ActionListener>();
        }
        this.actionListeners.add(l);
    }

    public void removeActionListener(ActionListener l) {
        if (this.actionListeners != null) {
            this.actionListeners.remove(l);
        }
    }

    public ActionListener[] getActionListeners() {
        if (this.actionListeners != null) {
            return this.actionListeners.toArray(new ActionListener[0]);
        }
        return new ActionListener[0];
    }

    protected void fireActionEvent(ActionEvent e) {
        if (this.actionListeners != null) {
            for (int i = 0; i < this.actionListeners.size(); ++i) {
                ActionListener l = this.actionListeners.get(i);
                l.actionPerformed(e);
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Enumeration<AbstractButton> en = this.buttonGroup.getElements();
        while (en.hasMoreElements()) {
            AbstractButton button = en.nextElement();
            if (enabled && button.getAction() != null && !button.getAction().isEnabled()) continue;
            button.setEnabled(enabled);
        }
    }

    private class ActionSelectionListener
    implements ActionListener,
    ItemListener {
        private ActionSelectionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            JXRadioGroup.this.fireActionEvent(e);
        }

        public void itemStateChanged(ItemEvent e) {
            JXRadioGroup.this.fireActionEvent(null);
        }
    }
}

