/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.shiftone.jrat.depends.jdesktop.swingx.JXCollapsiblePane;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.JXTaskPaneAddon;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.TaskPaneUI;

public class JXTaskPane
extends JPanel
implements JXCollapsiblePane.JCollapsiblePaneContainer {
    public static final String uiClassID = "swingx/TaskPaneUI";
    public static final String EXPANDED_CHANGED_KEY = "expanded";
    public static final String SCROLL_ON_EXPAND_CHANGED_KEY = "scrollOnExpand";
    public static final String TITLE_CHANGED_KEY = "title";
    public static final String ICON_CHANGED_KEY = "icon";
    public static final String SPECIAL_CHANGED_KEY = "special";
    public static final String ANIMATED_CHANGED_KEY = "animated";
    private String title;
    private Icon icon;
    private boolean special;
    private boolean expanded = true;
    private boolean scrollOnExpand;
    private JXCollapsiblePane collapsePane = new JXCollapsiblePane();

    public JXTaskPane() {
        super.setLayout(new BorderLayout(0, 0));
        super.addImpl(this.collapsePane, "Center", -1);
        this.updateUI();
        this.setFocusable(true);
        this.setOpaque(false);
        this.setAnimated(!Boolean.FALSE.equals(UIManager.get("TaskPane.animate")));
        this.collapsePane.addPropertyChangeListener("animationState", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                JXTaskPane.this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
    }

    public Container getContentPane() {
        return this.collapsePane.getContentPane();
    }

    public void updateUI() {
        if (this.collapsePane == null) {
            return;
        }
        this.setUI((TaskPaneUI)LookAndFeelAddons.getUI(this, TaskPaneUI.class));
    }

    public void setUI(TaskPaneUI ui) {
        super.setUI(ui);
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        String old = this.title;
        this.title = title;
        this.firePropertyChange(TITLE_CHANGED_KEY, old, title);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        Icon old = this.icon;
        this.icon = icon;
        this.firePropertyChange(ICON_CHANGED_KEY, old, icon);
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void setSpecial(boolean special) {
        if (this.special != special) {
            this.special = special;
            this.firePropertyChange(SPECIAL_CHANGED_KEY, !special, special);
        }
    }

    public void setScrollOnExpand(boolean scrollOnExpand) {
        if (this.scrollOnExpand != scrollOnExpand) {
            this.scrollOnExpand = scrollOnExpand;
            this.firePropertyChange(SCROLL_ON_EXPAND_CHANGED_KEY, !scrollOnExpand, scrollOnExpand);
        }
    }

    public boolean isScrollOnExpand() {
        return this.scrollOnExpand;
    }

    public void setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            this.collapsePane.setCollapsed(!expanded);
            this.firePropertyChange(EXPANDED_CHANGED_KEY, !expanded, expanded);
        }
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setAnimated(boolean animated) {
        if (this.isAnimated() != animated) {
            this.collapsePane.setAnimated(animated);
            this.firePropertyChange(ANIMATED_CHANGED_KEY, !this.isAnimated(), this.isAnimated());
        }
    }

    public boolean isAnimated() {
        return this.collapsePane.isAnimated();
    }

    public Component add(Action action) {
        Component c = ((TaskPaneUI)this.ui).createAction(action);
        this.add(c);
        return c;
    }

    public Container getValidatingContainer() {
        return this.getParent();
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        this.getContentPane().add(comp, constraints, index);
    }

    public void setLayout(LayoutManager mgr) {
        if (this.collapsePane != null) {
            this.getContentPane().setLayout(mgr);
        }
    }

    public void remove(Component comp) {
        this.getContentPane().remove(comp);
    }

    public void remove(int index) {
        this.getContentPane().remove(index);
    }

    public void removeAll() {
        this.getContentPane().removeAll();
    }

    protected String paramString() {
        return super.paramString() + ",title=" + this.getTitle() + ",icon=" + this.getIcon() + ",expanded=" + String.valueOf(this.isExpanded()) + ",special=" + String.valueOf(this.isSpecial()) + ",scrollOnExpand=" + String.valueOf(this.isScrollOnExpand()) + ",ui=" + this.getUI();
    }

    static {
        LookAndFeelAddons.contribute(new JXTaskPaneAddon());
    }
}

