/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx;

import java.awt.Component;
import java.awt.HeadlessException;
import java.util.prefs.Preferences;
import javax.swing.JDialog;
import org.shiftone.jrat.depends.jdesktop.swingx.JXPanel;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.JXTipOfTheDayAddon;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.shiftone.jrat.depends.jdesktop.swingx.plaf.TipOfTheDayUI;
import org.shiftone.jrat.depends.jdesktop.swingx.tips.DefaultTipOfTheDayModel;
import org.shiftone.jrat.depends.jdesktop.swingx.tips.TipOfTheDayModel;

public class JXTipOfTheDay
extends JXPanel {
    public static final String uiClassID = "swingx/TipOfTheDayUI";
    public static final String PREFERENCE_KEY = "ShowTipOnStartup";
    public static final String CURRENT_TIP_CHANGED_KEY = "currentTip";
    private TipOfTheDayModel model;
    private int currentTip = 0;

    public JXTipOfTheDay() {
        this(new DefaultTipOfTheDayModel(new TipOfTheDayModel.Tip[0]));
    }

    public JXTipOfTheDay(TipOfTheDayModel model) {
        this.model = model;
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((TipOfTheDayUI)LookAndFeelAddons.getUI(this, TipOfTheDayUI.class));
    }

    public void setUI(TipOfTheDayUI ui) {
        super.setUI(ui);
    }

    public TipOfTheDayUI getUI() {
        return (TipOfTheDayUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public TipOfTheDayModel getModel() {
        return this.model;
    }

    public void setModel(TipOfTheDayModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model can not be null");
        }
        TipOfTheDayModel old = this.model;
        this.model = model;
        this.firePropertyChange("model", old, model);
    }

    public int getCurrentTip() {
        return this.currentTip;
    }

    public void setCurrentTip(int currentTip) {
        if (currentTip < 0 || currentTip >= this.getModel().getTipCount()) {
            throw new IllegalArgumentException("Current tip must be within the bounds [0, " + this.getModel().getTipCount() + "[");
        }
        int oldTip = this.currentTip;
        this.currentTip = currentTip;
        this.firePropertyChange(CURRENT_TIP_CHANGED_KEY, oldTip, currentTip);
    }

    public void nextTip() {
        int count = this.getModel().getTipCount();
        if (count == 0) {
            return;
        }
        int nextTip = this.currentTip + 1;
        if (nextTip >= count) {
            nextTip = 0;
        }
        this.setCurrentTip(nextTip);
    }

    public void previousTip() {
        int count = this.getModel().getTipCount();
        if (count == 0) {
            return;
        }
        int previousTip = this.currentTip - 1;
        if (previousTip < 0) {
            previousTip = count - 1;
        }
        this.setCurrentTip(previousTip);
    }

    public void showDialog(Component parentComponent) throws HeadlessException {
        this.showDialog(parentComponent, (ShowOnStartupChoice)null);
    }

    public boolean showDialog(Component parentComponent, Preferences showOnStartupPref) throws HeadlessException {
        return this.showDialog(parentComponent, showOnStartupPref, false);
    }

    public boolean showDialog(Component parentComponent, final Preferences showOnStartupPref, boolean force) throws HeadlessException {
        if (showOnStartupPref == null) {
            throw new IllegalArgumentException("Preferences can not be null");
        }
        ShowOnStartupChoice store = new ShowOnStartupChoice(){

            public boolean isShowingOnStartup() {
                return showOnStartupPref.getBoolean(JXTipOfTheDay.PREFERENCE_KEY, true);
            }

            public void setShowingOnStartup(boolean showOnStartup) {
                if (showOnStartup && !showOnStartupPref.getBoolean(JXTipOfTheDay.PREFERENCE_KEY, true)) {
                    showOnStartupPref.remove(JXTipOfTheDay.PREFERENCE_KEY);
                } else if (!showOnStartup) {
                    showOnStartupPref.putBoolean(JXTipOfTheDay.PREFERENCE_KEY, showOnStartup);
                }
            }
        };
        return this.showDialog(parentComponent, store, force);
    }

    public boolean showDialog(Component parentComponent, ShowOnStartupChoice choice) {
        return this.showDialog(parentComponent, choice, false);
    }

    public boolean showDialog(Component parentComponent, ShowOnStartupChoice choice, boolean force) {
        if (choice == null) {
            JDialog dialog = this.createDialog(parentComponent, choice);
            dialog.setVisible(true);
            dialog.dispose();
            return true;
        }
        if (force || choice.isShowingOnStartup()) {
            JDialog dialog = this.createDialog(parentComponent, choice);
            dialog.setVisible(true);
            dialog.dispose();
            return choice.isShowingOnStartup();
        }
        return false;
    }

    public static boolean isShowingOnStartup(Preferences showOnStartupPref) {
        return showOnStartupPref.getBoolean(PREFERENCE_KEY, true);
    }

    public static void forceShowOnStartup(Preferences showOnStartupPref) {
        showOnStartupPref.remove(PREFERENCE_KEY);
    }

    protected JDialog createDialog(Component parentComponent, ShowOnStartupChoice choice) {
        return this.getUI().createDialog(parentComponent, choice);
    }

    static {
        LookAndFeelAddons.contribute(new JXTipOfTheDayAddon());
    }

    public static interface ShowOnStartupChoice {
        public void setShowingOnStartup(boolean var1);

        public boolean isShowingOnStartup();
    }
}

