/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.autocomplete;

import javax.swing.UIManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.shiftone.jrat.depends.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.shiftone.jrat.depends.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class AutoCompleteDocument
extends PlainDocument {
    boolean selecting = false;
    boolean strictMatching;
    AbstractAutoCompleteAdaptor adaptor;
    ObjectToStringConverter stringConverter;

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching, ObjectToStringConverter stringConverter) {
        this.adaptor = adaptor;
        this.strictMatching = strictMatching;
        this.stringConverter = stringConverter;
        Object selected = adaptor.getSelectedItem();
        if (selected != null) {
            this.setText(stringConverter.getPreferredStringForItem(selected));
        }
        adaptor.markEntireText();
    }

    public AutoCompleteDocument(AbstractAutoCompleteAdaptor adaptor, boolean strictMatching) {
        this(adaptor, strictMatching, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public boolean isStrictMatching() {
        return this.strictMatching;
    }

    public void remove(int offs, int len) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.remove(offs, len);
        if (!this.strictMatching) {
            this.setSelectedItem(this.getText(0, this.getLength()), this.getText(0, this.getLength()));
            this.adaptor.getTextComponent().setCaretPosition(offs);
        }
    }

    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(offs, str, a);
        LookupResult lookupResult = this.lookupItem(this.getText(0, this.getLength()));
        if (lookupResult.matchingItem != null) {
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        } else if (this.strictMatching) {
            lookupResult.matchingItem = this.adaptor.getSelectedItem();
            lookupResult.matchingString = this.adaptor.getSelectedItemAsString();
            offs -= str.length();
            UIManager.getLookAndFeel().provideErrorFeedback(this.adaptor.getTextComponent());
        } else {
            lookupResult.matchingItem = this.getText(0, this.getLength());
            lookupResult.matchingString = this.getText(0, this.getLength());
            this.setSelectedItem(lookupResult.matchingItem, lookupResult.matchingString);
        }
        this.setText(lookupResult.matchingString);
        this.adaptor.markText(offs + str.length());
    }

    private void setText(String text) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, text, null);
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e.toString());
        }
    }

    private void setSelectedItem(Object item, String itemAsString) {
        this.selecting = true;
        this.adaptor.setSelectedItem(item);
        this.adaptor.setSelectedItemAsString(itemAsString);
        this.selecting = false;
    }

    private LookupResult lookupItem(String pattern) {
        int possibleStrings;
        int j;
        String[] currentItem;
        Object n;
        Object selectedItem = this.adaptor.getSelectedItem();
        int n2 = 0;
        int i = this.adaptor.getItemCount();
        while (n2 < i) {
            n = this.adaptor.getItem(n2);
            currentItem = this.stringConverter.getPossibleStringsForItem(n);
            if (currentItem != null) {
                for (j = 0; j < currentItem.length; ++j) {
                    if (!currentItem[j].equalsIgnoreCase(pattern)) continue;
                    return new LookupResult(n, currentItem[j]);
                }
            }
            ++possibleStrings;
        }
        currentItem = this.stringConverter.getPossibleStringsForItem(selectedItem);
        if (currentItem != null) {
            for (possibleStrings = 0; possibleStrings < currentItem.length; ++possibleStrings) {
                if (!this.startsWithIgnoreCase(currentItem[possibleStrings], pattern)) continue;
                return new LookupResult(selectedItem, currentItem[possibleStrings]);
            }
        }
        i = this.adaptor.getItemCount();
        for (possibleStrings = 0; possibleStrings < i; ++possibleStrings) {
            n = this.adaptor.getItem(possibleStrings);
            currentItem = this.stringConverter.getPossibleStringsForItem(n);
            if (currentItem == null) continue;
            for (j = 0; j < currentItem.length; ++j) {
                if (!this.startsWithIgnoreCase(currentItem[j], pattern)) continue;
                return new LookupResult(n, currentItem[j]);
            }
        }
        return new LookupResult(null, "");
    }

    private boolean startsWithIgnoreCase(String base, String prefix) {
        if (base.length() < prefix.length()) {
            return false;
        }
        return base.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private static class LookupResult {
        Object matchingItem;
        String matchingString;

        public LookupResult(Object matchingItem, String matchingString) {
            this.matchingItem = matchingItem;
            this.matchingString = matchingString;
        }
    }
}

