/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.MatteBorder;

public class MatteBorderExt
extends MatteBorder {
    protected Icon[] tileIcons = null;
    private Icon defaultIcon = null;

    public MatteBorderExt(int top, int left, int bottom, int right, Icon[] tileIcons) {
        super(top, left, bottom, right, tileIcons == null || tileIcons.length == 0 ? null : tileIcons[0]);
        this.tileIcons = tileIcons;
    }

    public MatteBorderExt(int top, int left, int bottom, int right, Color matteColor) {
        super(top, left, bottom, right, matteColor);
    }

    public MatteBorderExt(Insets borderInsets, Color matteColor) {
        super(borderInsets, matteColor);
    }

    public MatteBorderExt(int top, int left, int bottom, int right, Icon tileIcon) {
        super(top, left, bottom, right, tileIcon);
    }

    public MatteBorderExt(Insets borderInsets, Icon tileIcon) {
        super(borderInsets, tileIcon);
    }

    public MatteBorderExt(Icon tileIcon) {
        super(tileIcon);
    }

    public Icon[] getTileIcons() {
        return this.tileIcons;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.tileIcons == null || this.tileIcons.length < 2) {
            super.paintBorder(c, g, x, y, width, height);
            return;
        }
        Insets insets = this.getBorderInsets(c);
        int clipWidth = Math.min(width, insets.left);
        int clipHeight = Math.min(height, insets.top);
        if (clipWidth <= 0 || clipHeight <= 0) {
            return;
        }
        Color oldColor = g.getColor();
        g.translate(x, y);
        for (int i = 0; i < this.tileIcons.length; ++i) {
            if (this.tileIcons[i] != null) continue;
            this.tileIcons[i] = this.getDefaultIcon();
        }
        this.paintTopLeft(c, g, 0, 0, insets.left, insets.top);
        this.paintTop(c, g, insets.left, 0, width - insets.left - insets.right, insets.top);
        this.paintTopRight(c, g, width - insets.right, 0, insets.right, insets.top);
        this.paintRight(c, g, width - insets.right, insets.top, insets.right, height - insets.top - insets.bottom);
        this.paintBottomRight(c, g, width - insets.right, height - insets.bottom, insets.right, insets.bottom);
        this.paintBottom(c, g, insets.left, height - insets.bottom, width - insets.left - insets.right, insets.bottom);
        this.paintBottomLeft(c, g, 0, height - insets.bottom, insets.left, insets.bottom);
        this.paintLeft(c, g, 0, insets.top, insets.left, height - insets.top - insets.bottom);
        g.translate(-x, -y);
        g.setColor(oldColor);
    }

    /*
     * WARNING - void declaration
     */
    protected void paint(Icon icon, Component c, Graphics g, int x, int y, int width, int height) {
        Graphics cg = g.create();
        cg.setClip(x, y, width, height);
        int tileW = icon.getIconWidth();
        int tileH = icon.getIconHeight();
        int n = 0;
        while (height - n > 0) {
            int ypos = 0;
            while (width - ypos > 0) {
                void xpos;
                icon.paintIcon(c, cg, x + ypos, y + xpos);
                ypos += tileW;
            }
            xpos += tileH;
        }
        cg.dispose();
    }

    protected void paintTopLeft(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics cg = g.create();
        cg.setClip(x, y, width, height);
        this.tileIcons[0].paintIcon(c, cg, x, y);
        cg.dispose();
    }

    protected void paintTop(Component c, Graphics g, int x, int y, int width, int height) {
        this.paint(this.tileIcons[1], c, g, x, y, width, height);
    }

    protected void paintTopRight(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[2], c, g, x, y, width, height);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintRight(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[3], c, g, x, y, width, height);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected void paintBottomRight(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[4], c, g, x, y, width, height);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintBottom(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[5], c, g, x, y, width, height);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected void paintBottomLeft(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[6], c, g, x, y, width, height);
        } else {
            Icon icon = this.tileIcons[0];
        }
    }

    protected void paintLeft(Component c, Graphics g, int x, int y, int width, int height) {
        if (this.tileIcons.length == 8) {
            this.paint(this.tileIcons[7], c, g, x, y, width, height);
        } else {
            Icon icon = this.tileIcons[1];
        }
    }

    protected Icon getDefaultIcon() {
        if (this.defaultIcon == null) {
            this.defaultIcon = new Icon(){
                private int width = 3;
                private int height = 3;

                public int getIconWidth() {
                    return this.width;
                }

                public int getIconHeight() {
                    return this.height;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    g.setColor(c.getBackground().darker().darker());
                    g.fillRect(x, y, this.width, this.height);
                }
            };
        }
        return this.defaultIcon;
    }
}

