/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ColorUtil {
    private static Paint checker_texture = null;

    public static Color removeAlpha(Color color) {
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public static Color setAlpha(Color col, int alpha) {
        return new Color(col.getRed(), col.getGreen(), col.getBlue(), alpha);
    }

    public static Color setBrightness(Color color, float brightness) {
        int alpha = color.getAlpha();
        float[] cols = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        cols[2] = brightness;
        Color c2 = Color.getHSBColor(cols[0], cols[1], cols[2]);
        return ColorUtil.setAlpha(c2, alpha);
    }

    public static String toHexString(Color color) {
        return "#" + ("" + Integer.toHexString(color.getRGB())).substring(2);
    }

    public static Paint getCheckerPaint() {
        return ColorUtil.getCheckerPaint(Color.white, Color.gray, 20);
    }

    public static Paint getCheckerPaint(Color c1, Color c2, int size) {
        BufferedImage img = new BufferedImage(size, size, 2);
        Graphics g = img.getGraphics();
        g.setColor(c1);
        g.fillRect(0, 0, size, size);
        g.setColor(c2);
        g.fillRect(0, 0, size / 2, size / 2);
        g.fillRect(size / 2, size / 2, size / 2, size / 2);
        g.dispose();
        return new TexturePaint(img, new Rectangle(0, 0, size, size));
    }

    public static void tileStretchPaint(Graphics g, JComponent comp, BufferedImage img, Insets ins) {
        int left = ins.left;
        int right = ins.right;
        int top = ins.top;
        int bottom = ins.bottom;
        g.drawImage(img, 0, 0, left, top, 0, 0, left, top, null);
        g.drawImage(img, left, 0, comp.getWidth() - right, top, left, 0, img.getWidth() - right, top, null);
        g.drawImage(img, comp.getWidth() - right, 0, comp.getWidth(), top, img.getWidth() - right, 0, img.getWidth(), top, null);
        g.drawImage(img, 0, top, left, comp.getHeight() - bottom, 0, top, left, img.getHeight() - bottom, null);
        g.drawImage(img, left, top, comp.getWidth() - right, comp.getHeight() - bottom, left, top, img.getWidth() - right, img.getHeight() - bottom, null);
        g.drawImage(img, comp.getWidth() - right, top, comp.getWidth(), comp.getHeight() - bottom, img.getWidth() - right, top, img.getWidth(), img.getHeight() - bottom, null);
        g.drawImage(img, 0, comp.getHeight() - bottom, left, comp.getHeight(), 0, img.getHeight() - bottom, left, img.getHeight(), null);
        g.drawImage(img, left, comp.getHeight() - bottom, comp.getWidth() - right, comp.getHeight(), left, img.getHeight() - bottom, img.getWidth() - right, img.getHeight(), null);
        g.drawImage(img, comp.getWidth() - right, comp.getHeight() - bottom, comp.getWidth(), comp.getHeight(), img.getWidth() - right, img.getHeight() - bottom, img.getWidth(), img.getHeight(), null);
    }

    public static Color setSaturation(Color color, float saturation) {
        int alpha = color.getAlpha();
        float[] cols = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null);
        cols[1] = saturation;
        Color c2 = Color.getHSBColor(cols[0], cols[1], cols[2]);
        return ColorUtil.setAlpha(c2, alpha);
    }

    public static Color interpolate(Color b, Color a, float t) {
        float[] acomp = a.getRGBComponents(null);
        float[] bcomp = b.getRGBComponents(null);
        float[] ccomp = new float[4];
        for (int i = 0; i < 4; ++i) {
            ccomp[i] = acomp[i] + (bcomp[i] - acomp[i]) * t;
        }
        return new Color(ccomp[0], ccomp[1], ccomp[2], ccomp[3]);
    }
}

