/*
 * Decompiled with CFR 0.152.
 */
package org.shiftone.jrat.depends.jdesktop.swingx.color;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.MouseInputAdapter;
import org.shiftone.jrat.depends.jdesktop.swingx.JXColorSelectionButton;
import org.shiftone.jrat.depends.jdesktop.swingx.color.ColorUtil;

public class EyeDropperColorChooserPanel
extends AbstractColorChooserPanel {
    private JButton activeColor;
    private JButton eyeDropper;
    private JTextField hexColor;
    private JLabel jLabel1;
    private JPanel magPanel;
    private JTextField rgbColor;

    public static void main(String ... args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JColorChooser chooser = new JColorChooser();
                chooser.addChooserPanel(new EyeDropperColorChooserPanel());
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                frame.add(chooser);
                frame.pack();
                frame.setVisible(true);
            }
        });
    }

    public EyeDropperColorChooserPanel() {
        this.initComponents();
        MouseInputAdapter mia = new MouseInputAdapter(){

            public void mousePressed(MouseEvent evt) {
            }

            public void mouseDragged(MouseEvent evt) {
                Point pt = evt.getPoint();
                SwingUtilities.convertPointToScreen(pt, evt.getComponent());
                ((MagnifyingPanel)EyeDropperColorChooserPanel.this.magPanel).setMagPoint(pt);
            }

            public void mouseReleased(MouseEvent evt) {
                Color newColor = new Color(((MagnifyingPanel)EyeDropperColorChooserPanel.this.magPanel).activeColor);
                EyeDropperColorChooserPanel.this.getColorSelectionModel().setSelectedColor(newColor);
            }
        };
        this.eyeDropper.addMouseListener(mia);
        this.eyeDropper.addMouseMotionListener(mia);
        try {
            this.eyeDropper.setIcon(new ImageIcon(this.getClass().getResource("mag.png")));
            this.eyeDropper.setText("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.magPanel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Color color = new Color(((MagnifyingPanel)EyeDropperColorChooserPanel.this.magPanel).activeColor);
                EyeDropperColorChooserPanel.this.activeColor.setBackground(color);
                EyeDropperColorChooserPanel.this.hexColor.setText(ColorUtil.toHexString(color).substring(1));
                EyeDropperColorChooserPanel.this.rgbColor.setText(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void initComponents() {
        void gridBagConstraints;
        this.eyeDropper = new JButton();
        this.magPanel = new MagnifyingPanel();
        this.activeColor = new JXColorSelectionButton();
        this.hexColor = new JTextField();
        JTextArea jTextArea = new JTextArea();
        this.jLabel1 = new JLabel();
        this.rgbColor = new JTextField();
        JLabel jTextArea1 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.eyeDropper.setText("eye");
        this.add((Component)this.eyeDropper, new GridBagConstraints());
        this.magPanel.setLayout(new BorderLayout());
        this.magPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.magPanel.setMinimumSize(new Dimension(100, 100));
        this.magPanel.setPreferredSize(new Dimension(100, 100));
        GridBagConstraints jLabel2 = new GridBagConstraints();
        jLabel2.gridx = 0;
        jLabel2.gridy = 1;
        jLabel2.gridheight = 3;
        jLabel2.fill = 1;
        jLabel2.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.magPanel, jLabel2);
        this.activeColor.setEnabled(false);
        this.activeColor.setPreferredSize(new Dimension(40, 40));
        jLabel2 = new GridBagConstraints();
        jLabel2.gridx = 2;
        jLabel2.gridy = 3;
        jLabel2.fill = 1;
        jLabel2.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.activeColor, jLabel2);
        this.hexColor.setEditable(false);
        jLabel2 = new GridBagConstraints();
        jLabel2.gridx = 2;
        jLabel2.gridy = 1;
        jLabel2.fill = 2;
        jLabel2.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.hexColor, jLabel2);
        gridBagConstraints.setColumns(20);
        gridBagConstraints.setEditable(false);
        gridBagConstraints.setLineWrap(true);
        gridBagConstraints.setRows(5);
        gridBagConstraints.setText("Drag the magnifying glass to select a color from the screen.");
        gridBagConstraints.setWrapStyleWord(true);
        gridBagConstraints.setOpaque(false);
        jLabel2 = new GridBagConstraints();
        jLabel2.gridwidth = 2;
        jLabel2.fill = 2;
        jLabel2.anchor = 11;
        jLabel2.weightx = 10.0;
        jLabel2.weighty = 10.0;
        jLabel2.insets = new Insets(0, 0, 7, 0);
        this.add((Component)gridBagConstraints, jLabel2);
        this.jLabel1.setText("#");
        jLabel2 = new GridBagConstraints();
        jLabel2.gridx = 1;
        jLabel2.gridy = 1;
        jLabel2.anchor = 13;
        jLabel2.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.jLabel1, jLabel2);
        this.rgbColor.setEditable(false);
        this.rgbColor.setText("255,255,255");
        jLabel2 = new GridBagConstraints();
        jLabel2.gridx = 2;
        jLabel2.gridy = 2;
        jLabel2.fill = 2;
        jLabel2.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.rgbColor, jLabel2);
        jTextArea1.setText("RGB");
        jLabel2 = new GridBagConstraints();
        jLabel2.gridx = 1;
        jLabel2.gridy = 2;
        jLabel2.anchor = 13;
        jLabel2.insets = new Insets(0, 4, 0, 4);
        this.add((Component)jTextArea1, jLabel2);
    }

    public void updateChooser() {
    }

    protected void buildChooser() {
    }

    public String getDisplayName() {
        return "Grab from Screen";
    }

    public Icon getSmallDisplayIcon() {
        return new ImageIcon();
    }

    public Icon getLargeDisplayIcon() {
        return new ImageIcon();
    }

    private class MagnifyingPanel
    extends JPanel {
        private Point2D point;
        private int activeColor;

        private MagnifyingPanel() {
        }

        public void setMagPoint(Point2D point) {
            this.point = point;
            this.repaint();
        }

        public void paintComponent(Graphics g) {
            if (this.point != null) {
                Rectangle rect = new Rectangle((int)this.point.getX() - 10, (int)this.point.getY() - 10, 20, 20);
                try {
                    BufferedImage img = new Robot().createScreenCapture(rect);
                    g.drawImage(img, 0, 0, this.getWidth(), this.getHeight(), null);
                    int oldColor = this.activeColor;
                    this.activeColor = img.getRGB(img.getWidth() / 2, img.getHeight() / 2);
                    this.firePropertyChange("activeColor", oldColor, this.activeColor);
                }
                catch (AWTException ex) {
                    ex.printStackTrace();
                }
            }
            g.setColor(Color.black);
            g.drawRect(this.getWidth() / 2 - 5, this.getHeight() / 2 - 5, 10, 10);
        }
    }
}

